/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ProtocolSSLFactory
extends SSLSocketFactory {
    public static final String PROTOCOL_DEFAULT = "TLS";
    public static final String CERT_FORMAT_DEFAULT = "PKCS12";
    public static final String CERT_STANDARD_DEFAULT = "X509";
    private final String[] protocols;
    private final SSLContext context;
    private final SSLSocketFactory factory;

    public static ProtocolSSLFactory getInstance(KeyManager[] keyManagers) throws Exception {
        return ProtocolSSLFactory.getInstance(keyManagers, null, new SecureRandom(), PROTOCOL_DEFAULT, new String[0]);
    }

    public static ProtocolSSLFactory getInstance(KeyManager[] keyManagers, TrustManager[] trustManagers) throws Exception {
        return ProtocolSSLFactory.getInstance(keyManagers, trustManagers, new SecureRandom(), PROTOCOL_DEFAULT, new String[0]);
    }

    public static ProtocolSSLFactory getInstance(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws Exception {
        return ProtocolSSLFactory.getInstance(keyManagers, trustManagers, secureRandom, PROTOCOL_DEFAULT, new String[0]);
    }

    public static ProtocolSSLFactory getInstance(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom, String ... protocols) throws Exception {
        return ProtocolSSLFactory.getInstance(keyManagers, trustManagers, secureRandom, PROTOCOL_DEFAULT, protocols);
    }

    public static ProtocolSSLFactory getInstance(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom, String contextProtocol, String ... protocols) throws Exception {
        return new ProtocolSSLFactory(keyManagers, trustManagers, secureRandom, contextProtocol, protocols);
    }

    private ProtocolSSLFactory(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom, String contextProtocol, String ... protocols) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (keyManagers == null || keyManagers.length == 0) {
            keyManagerFactory.init(null, null);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        if (trustManagers == null || trustManagers.length == 0) {
            trustManagerFactory.init((KeyStore)null);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        SSLContext context = SSLContext.getInstance(contextProtocol);
        context.init(keyManagers, trustManagers, secureRandom);
        this.protocols = protocols;
        this.context = context;
        this.factory = context.getSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.factory.createSocket();
        this.setProtocols(sslSocket);
        return sslSocket;
    }

    @Override
    public SSLSocket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket(s, host, port, autoClose);
        this.setProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket(host, port);
        this.setProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket(host, port, localHost, localPort);
        this.setProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket(host, port);
        this.setProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket(address, port, localAddress, localPort);
        this.setProtocols(socket);
        return socket;
    }

    private void setProtocols(SSLSocket socket) {
        if (this.protocols != null && this.protocols.length > 0) {
            socket.setEnabledProtocols(this.protocols);
        }
    }

    public static Set<TrustAnchor> getDefaultRootCAs() throws NoSuchAlgorithmException, KeyStoreException {
        X509TrustManager x509tm = ProtocolSSLFactory.getDefaultX509TrustManager();
        HashSet<TrustAnchor> rootCAs = new HashSet<TrustAnchor>();
        for (X509Certificate c : x509tm.getAcceptedIssuers()) {
            rootCAs.add(new TrustAnchor(c, null));
        }
        return rootCAs;
    }

    public static X509TrustManager getDefaultX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new IllegalStateException("X509TrustManager is not found");
    }
}

