/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.bean.ImResponseCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ImResponse {
    private int responseCode;
    private String responseMessage;
    private String stringContent;
    private byte[] bytesContent;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String cookieStr;
    private Map<String, String> cookies = new HashMap<String, String>();
    private Map<String, ImResponseCookie> cookiePropertys = new HashMap<String, ImResponseCookie>();

    protected ImResponse setResponseCode(int responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    protected ImResponse setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
        return this;
    }

    protected ImResponse setStringContent(String stringContent) {
        this.stringContent = stringContent;
        return this;
    }

    protected ImResponse setBytesContent(byte[] bytesContent) {
        this.bytesContent = bytesContent;
        return this;
    }

    protected ImResponse setFullCookie(String data) {
        this.cookieStr = data;
        return this;
    }

    protected ImResponse addCookie(String name, String data) {
        this.cookies.put(name, data);
        return this;
    }

    protected ImResponse addCookieProperty(ImResponseCookie imResponseCookie) {
        this.cookiePropertys.put(imResponseCookie.getName(), imResponseCookie);
        return this;
    }

    protected ImResponse setFullHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public byte[] getBytesContent() {
        return this.bytesContent;
    }

    public void get(byte[] bytesContent) {
        bytesContent = this.bytesContent;
    }

    public String getCookieStr() {
        return this.cookieStr;
    }

    public String getCookieData(String name) {
        return this.cookies.get(name);
    }

    public ImResponseCookie getCookieProperty(String name) {
        return this.cookiePropertys.get(name);
    }

    public Set<String> getCookieNames() {
        return this.cookies.keySet();
    }

    public int getCookieSize() {
        return this.cookies.size();
    }

    public List<String> getHeaderData(String name) {
        return this.headers.get(name);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public int getHeaderSize() {
        return this.headers.size();
    }

    protected ImResponse() {
    }
}

