/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.bean.ImBytesData;
import cn.sinlmao.commons.network.bean.ImFileData;
import cn.sinlmao.commons.network.bean.ImFormData;
import cn.sinlmao.commons.network.bean.ImMultipartFormData;
import cn.sinlmao.commons.network.bean.ImResponseCookie;
import cn.sinlmao.commons.network.callback.ImHttpClientCallback;
import cn.sinlmao.commons.network.callback.ImSessionCallback;
import cn.sinlmao.commons.network.exception.AuthenticationException;
import cn.sinlmao.commons.network.exception.ContentTypeException;
import cn.sinlmao.commons.network.exception.DataTypeException;
import cn.sinlmao.commons.network.exception.IgnoreSSLException;
import cn.sinlmao.commons.network.exception.MethodException;
import cn.sinlmao.commons.network.exception.QueryParamsException;
import cn.sinlmao.commons.network.exception.SessionException;
import cn.sinlmao.commons.network.http.ImCharset;
import cn.sinlmao.commons.network.http.ImContentType;
import cn.sinlmao.commons.network.http.ImMethod;
import cn.sinlmao.commons.network.http.ImRequest;
import cn.sinlmao.commons.network.http.ImResponse;
import cn.sinlmao.commons.network.http.ImSession;
import cn.sinlmao.commons.network.ssl.ProtocolSSLFactory;
import cn.sinlmao.commons.network.ssl.TrustAllCertificateContextBuilder;
import cn.sinlmao.commons.network.ssl.TrustAllHostnameVerifier;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.HttpsURLConnection;

public final class ImHttpClient {
    public static final String VERSION = "1.5.2";
    private static final String PREFIX = "--";
    private static final String WRAP = System.getProperty("line.separator");
    private static final ThreadFactory THREAD_FACTORY = Executors.defaultThreadFactory();

    public static String get(String url) throws IOException, IgnoreSSLException {
        return ImHttpClient.get(url, ImCharset.UTF_8, null);
    }

    public static String get(String url, ImCharset charset) throws IOException, IgnoreSSLException {
        return ImHttpClient.get(url, charset, null);
    }

    public static String get(String url, Map<String, String> params) throws IOException, IgnoreSSLException {
        return ImHttpClient.get(url, ImCharset.UTF_8, params);
    }

    public static String get(String url, ImCharset charset, Map<String, String> params) throws IOException, IgnoreSSLException {
        ImRequest imRequest = new ImRequest(url);
        imRequest.setCharset(charset);
        imRequest.setUrlEncode(true);
        if (params != null) {
            imRequest.setQueryParams(params);
        }
        ImResponse imResponse = ImHttpClient.send(imRequest);
        return imResponse.getStringContent();
    }

    public static String post(String url, Map<String, String> params) throws IOException, IgnoreSSLException {
        return ImHttpClient.post(url, ImCharset.UTF_8, params);
    }

    public static String post(String url, ImCharset charset, Map<String, String> params) throws IOException, IgnoreSSLException {
        ImRequest imRequest = new ImRequest(url);
        imRequest.setCharset(charset);
        imRequest.setMethod(ImMethod.POST);
        if (params != null) {
            imRequest.setInputData(params);
        }
        ImResponse imResponse = ImHttpClient.send(imRequest);
        return imResponse.getStringContent();
    }

    public static ImResponse send(ImRequest imRequest, ImSession imSession) throws SessionException, ContentTypeException, DataTypeException, MethodException, IgnoreSSLException, QueryParamsException, AuthenticationException, IOException {
        if (imRequest == null || imSession == null) {
            throw new NullPointerException();
        }
        if (imRequest.isAsync()) {
            THREAD_FACTORY.newThread(() -> {
                block5: {
                    ImHttpClientCallback httpClientCallback = imRequest.getCallback();
                    ImSessionCallback sessionCallback = imSession.getCallback();
                    try {
                        ImResponse imResponse = ImHttpClient.execute(imRequest, imSession);
                        if (httpClientCallback != null) {
                            httpClientCallback.onSuccess(imRequest, imResponse);
                            httpClientCallback.onComplete(imRequest, imResponse);
                        }
                    }
                    catch (ContentTypeException | DataTypeException | IgnoreSSLException | MethodException | QueryParamsException | IOException e) {
                        if (httpClientCallback != null) {
                            httpClientCallback.onError(imRequest, e);
                            httpClientCallback.onComplete(imRequest, null);
                        }
                    }
                    catch (AuthenticationException e) {
                        if (sessionCallback == null) break block5;
                        sessionCallback.onError(imSession, imRequest, e);
                    }
                }
            }).start();
            return null;
        }
        return ImHttpClient.execute(imRequest, imSession);
    }

    public static ImResponse send(final ImRequest imRequest) throws ContentTypeException, DataTypeException, MethodException, IgnoreSSLException, QueryParamsException, IOException {
        if (imRequest == null) {
            throw new NullPointerException();
        }
        if (imRequest.isAsync()) {
            THREAD_FACTORY.newThread(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        ImHttpClientCallback callback = imRequest.getCallback();
                        try {
                            ImResponse imResponse = ImHttpClient.execute(imRequest);
                            if (callback != null) {
                                callback.onSuccess(imRequest, imResponse);
                                callback.onComplete(imRequest, imResponse);
                            }
                        }
                        catch (ContentTypeException | DataTypeException | IgnoreSSLException | MethodException | QueryParamsException | IOException e) {
                            if (callback == null) break block3;
                            callback.onError(imRequest, e);
                            callback.onComplete(imRequest, null);
                        }
                    }
                }
            }).start();
            return null;
        }
        return ImHttpClient.execute(imRequest);
    }

    private static ImResponse execute(ImRequest imRequest) throws ContentTypeException, DataTypeException, MethodException, IgnoreSSLException, QueryParamsException, IOException {
        String output_line;
        byte[] out_bytes;
        ImHttpClientCallback callback;
        String urlPars;
        String boundary = "--------------------------" + String.valueOf(System.currentTimeMillis());
        Proxy proxy = null;
        if (imRequest.isEnableProxyServer()) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(imRequest.getProxyServerHost(), Integer.parseInt(imRequest.getProxyServerPort())));
        }
        if (!imRequest.isAllowNonStandard()) {
            if (imRequest.getContentType() != ImContentType.APPLICATION_X_WWW_FORM_URLENCODED && (imRequest.getMethod() == ImMethod.GET || imRequest.getMethod() == ImMethod.HEAD)) {
                throw new ContentTypeException("Can't use an inappropriate ContentType.");
            }
            if (imRequest.getContentType() != ImContentType.MULTIPART_FORM_DATA && imRequest.getInputData() != null) {
                if (imRequest.getInputData().getClass() == ImBytesData.class || imRequest.getInputData().getClass() == ImFileData.class || imRequest.getInputData().getClass() == ImMultipartFormData.class) {
                    throw new MethodException("Can't use an inappropriate Method.");
                }
                if (imRequest.getInputData().getClass() == ImFormData.class) {
                    throw new DataTypeException("This data type is not supported.");
                }
            }
            if (imRequest.getContentType() == ImContentType.MULTIPART_FORM_DATA && imRequest.getMethod() != ImMethod.POST && imRequest.getMethod() != ImMethod.PUT) {
                throw new MethodException("Can't use an inappropriate Method.");
            }
            if (imRequest.getQueryParams() != null) {
                if (imRequest.getUrl().contains("?")) {
                    throw new QueryParamsException("Improper use of URL after query parameter (QueryParams) setting.");
                }
                if (imRequest.getMethod() == ImMethod.GET && imRequest.getInputData() != null) {
                    throw new MethodException("If use GET Method, Can't simultaneously set InputData and QueryParams.");
                }
            }
        }
        if (imRequest.isForceInUrlSendData()) {
            if (imRequest.getInputData() != null && (imRequest.getInputData().getClass() == ImFileData.class || imRequest.getInputData().getClass() == ImMultipartFormData.class || imRequest.getInputData().getClass() == ImBytesData.class)) {
                throw new DataTypeException("This data type is not supported.");
            }
            if (imRequest.getContentType() != ImContentType.APPLICATION_X_WWW_FORM_URLENCODED) {
                throw new ContentTypeException("Can't use an inappropriate ContentType.");
            }
            if (imRequest.getQueryParams() != null) {
                throw new QueryParamsException("After the query parameter (QueryParams) is set, there is a conflict with the forced URL value.");
            }
        }
        String urlStr = imRequest.getUrl();
        if (imRequest.isForceInUrlSendData() && imRequest.getInputData() != null) {
            urlPars = ImHttpClient.getInputDataToString(imRequest, true);
            urlStr = urlStr.contains("?") ? urlStr + "&" + urlPars : urlStr + "?" + urlPars;
        }
        if (imRequest.getQueryParams() != null) {
            urlPars = ImHttpClient.getQueryParamsToString(imRequest);
            urlStr = urlStr.contains("?") ? urlStr + "&" + urlPars : urlStr + "?" + urlPars;
        }
        ImResponse imResponse = new ImResponse();
        URL url = new URL(urlStr);
        HttpURLConnection httpConnection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        if (urlStr.toLowerCase().startsWith("https://")) {
            if (imRequest.isIgnoreSSLCertVerify()) {
                try {
                    ((HttpsURLConnection)httpConnection).setSSLSocketFactory(TrustAllCertificateContextBuilder.build(imRequest.getKeyManagers()));
                    ((HttpsURLConnection)httpConnection).setHostnameVerifier(new TrustAllHostnameVerifier());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IgnoreSSLException("Can't set ignore SSL certificates.", e.getCause());
                }
            }
            try {
                ((HttpsURLConnection)httpConnection).setSSLSocketFactory(ProtocolSSLFactory.getInstance(imRequest.getKeyManagers(), imRequest.getTrustManager()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getCause());
            }
            if (imRequest.getHostnameVerifier() != null) {
                ((HttpsURLConnection)httpConnection).setHostnameVerifier(imRequest.getHostnameVerifier());
            }
        }
        if ((callback = imRequest.getCallback()) != null) {
            callback.onCallRequest(imRequest);
        }
        httpConnection.setRequestMethod(imRequest.getMethod().toString());
        httpConnection.setUseCaches(imRequest.isUseCache());
        httpConnection.setRequestProperty("User-Agent", imRequest.getUserAgent());
        httpConnection.setRequestProperty("Accept-Charset", imRequest.getCharset());
        httpConnection.setRequestProperty("Accept", "*/*");
        httpConnection.setRequestProperty("Content-Type", imRequest.getContentTypeStr() + "; charset=" + imRequest.getCharset());
        if (imRequest.isKeepAlive() || imRequest.getContentType() == ImContentType.MULTIPART_FORM_DATA) {
            httpConnection.setRequestProperty("Connection", "keep-alive");
        }
        if (imRequest.getContentType() == ImContentType.MULTIPART_FORM_DATA) {
            httpConnection.setRequestProperty("Content-Type", imRequest.getContentTypeStr() + "; charset=" + imRequest.getCharset() + "; boundary=" + boundary);
            httpConnection.setChunkedStreamingMode(0);
        }
        if (imRequest.hasContentTypeStr()) {
            httpConnection.setRequestProperty("Content-Type", imRequest.getContentTypeStr());
        }
        if (imRequest.getHeaderSize() > 0) {
            Set<String> headerNames = imRequest.getHeaderNames();
            for (String string : headerNames) {
                httpConnection.setRequestProperty(string, imRequest.getHeaderValue(string));
            }
        }
        StringBuilder cookieStrs = new StringBuilder();
        if (imRequest.getCookieSize() > 0) {
            Set<String> cookieNames = imRequest.getCookieNames();
            for (String cookieName : cookieNames) {
                cookieStrs.append(cookieName).append("=").append(imRequest.getCookieData(cookieName));
                cookieStrs.append(";");
            }
        }
        if (imRequest.isAutoServletSessionID() && (imRequest.getCookieData("JSESSIONID") == null || "".equals(imRequest.getCookieData("JSESSIONID").trim()))) {
            cookieStrs.append("JSESSIONID=").append(UUID.randomUUID().toString().replace("-", "").toUpperCase());
            cookieStrs.append(";");
        }
        if (cookieStrs.length() > 1) {
            httpConnection.setRequestProperty("Cookie", cookieStrs.substring(0, cookieStrs.length() - 1));
        }
        if (imRequest.getInputData() != null) {
            if (imRequest.getContentType() != ImContentType.MULTIPART_FORM_DATA) {
                String inputData = "";
                if (imRequest.getContentType() != ImContentType.APPLICATION_X_WWW_FORM_URLENCODED) {
                    inputData = ImHttpClient.getInputDataToString(imRequest);
                    httpConnection.setDoOutput(true);
                    httpConnection.setDoInput(true);
                    if (!imRequest.isForceInUrlSendData()) {
                        OutputStream outputStream = httpConnection.getOutputStream();
                        outputStream.write(inputData.getBytes(Charset.forName(imRequest.getCharset())));
                        outputStream.flush();
                        outputStream.close();
                    }
                } else {
                    inputData = ImHttpClient.getInputDataToString(imRequest, true);
                    httpConnection.setDoOutput(true);
                    httpConnection.setDoInput(true);
                    if (!imRequest.isForceInUrlSendData()) {
                        OutputStream outputStream = httpConnection.getOutputStream();
                        outputStream.write(inputData.getBytes(Charset.forName(imRequest.getCharset())));
                        outputStream.flush();
                        outputStream.close();
                    }
                }
            } else {
                httpConnection.setDoOutput(true);
                httpConnection.setDoInput(true);
                DataOutputStream dataOutputStream = new DataOutputStream(httpConnection.getOutputStream());
                String string = PREFIX + boundary + WRAP;
                String file_separate = WRAP + PREFIX + boundary + WRAP;
                String file_footer = WRAP + PREFIX + boundary + PREFIX;
                if (imRequest.getInputData().getClass() == ImFileData.class) {
                    ImFileData imFileData = imRequest.getInputData(ImFileData.class);
                    String file_disposition = "Content-Disposition: form-data; name=\"" + imFileData.getName() + "\"; filename=\"" + imFileData.getFileName() + "\"" + WRAP;
                    String file_content_type = "Content-Type: " + imFileData.getFileType() + WRAP + WRAP;
                    dataOutputStream.writeBytes(string);
                    dataOutputStream.writeBytes(file_disposition);
                    dataOutputStream.writeBytes(file_content_type);
                    dataOutputStream.write(imFileData.getBytes());
                    dataOutputStream.writeBytes(file_footer);
                }
                if (imRequest.getInputData().getClass() == ImMultipartFormData.class) {
                    ImMultipartFormData imMultipartFormData = imRequest.getInputData(ImMultipartFormData.class);
                    dataOutputStream.writeBytes(string);
                    while (imMultipartFormData.hasNext()) {
                        String file_content_type;
                        String file_disposition;
                        Object data = imMultipartFormData.nextData();
                        if (data.getClass() == ImFileData.class) {
                            ImFileData imFileData = (ImFileData)data;
                            file_disposition = "Content-Disposition: form-data; name=\"" + imFileData.getName() + "\"; filename=\"" + imFileData.getFileName() + "\"" + WRAP;
                            file_content_type = "Content-Type: " + imFileData.getFileType() + WRAP + WRAP;
                            dataOutputStream.writeBytes(file_disposition);
                            dataOutputStream.writeBytes(file_content_type);
                            dataOutputStream.write(imFileData.getBytes());
                        }
                        if (data.getClass() == ImFormData.class) {
                            ImFormData imFormData = (ImFormData)data;
                            file_disposition = "Content-Disposition: form-data; name=\"" + imFormData.getName() + "\"" + WRAP;
                            file_content_type = "Content-Type: " + imFormData.getContentType() + WRAP + WRAP;
                            dataOutputStream.writeBytes(file_disposition);
                            dataOutputStream.writeBytes(file_content_type);
                            dataOutputStream.writeBytes(imFormData.getValue());
                        }
                        if (!imMultipartFormData.hasNext()) continue;
                        dataOutputStream.writeBytes(file_separate);
                    }
                    dataOutputStream.writeBytes(file_footer);
                }
                if (imRequest.getInputData().getClass() == ImBytesData.class) {
                    ImBytesData imBytesData = imRequest.getInputData(ImBytesData.class);
                    dataOutputStream.write(imBytesData.getBytes());
                }
                dataOutputStream.flush();
                dataOutputStream.close();
            }
        }
        httpConnection.connect();
        imResponse.setResponseCode(httpConnection.getResponseCode());
        imResponse.setResponseMessage(httpConnection.getResponseMessage());
        if (String.valueOf(imResponse.getResponseCode()).startsWith("2")) {
            out_bytes = ImHttpClient.toByteArray(httpConnection.getInputStream(), 4096);
        } else {
            try {
                out_bytes = ImHttpClient.toByteArray(httpConnection.getErrorStream(), 4096);
            }
            catch (Exception exception) {
                out_bytes = new byte[]{};
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out_bytes), imRequest.getCharset()));
        StringBuffer output = new StringBuffer();
        while ((output_line = bufferedReader.readLine()) != null) {
            output.append(output_line);
            output.append(System.getProperty("line.separator"));
        }
        httpConnection.disconnect();
        imResponse.setStringContent(output.toString());
        imResponse.setBytesContent(out_bytes);
        String cookieStr = "";
        Map<String, List<String>> headers = httpConnection.getHeaderFields();
        Set<String> headerNames = headers.keySet();
        for (String headerName : headerNames) {
            if (!"Set-Cookie".equals(headerName)) continue;
            List<String> headerData = headers.get(headerName);
            StringBuilder builder = new StringBuilder();
            for (String data : headerData) {
                builder.append(data).append(",");
                String[] strs_arry = data.split("; ");
                ImResponseCookie imResponseCookie = new ImResponseCookie();
                for (String str : strs_arry) {
                    String[] str_arry = new String[2];
                    int index = str.indexOf("=");
                    if (index < 0) {
                        index = str.length();
                    }
                    str_arry[0] = str.substring(0, index);
                    str_arry[1] = str.indexOf("=") > 0 ? str.substring(index + 1) : "null";
                    if ("domain".equalsIgnoreCase(str_arry[0])) {
                        imResponseCookie.setDomain(str_arry[1]);
                        continue;
                    }
                    if ("path".equalsIgnoreCase(str_arry[0])) {
                        imResponseCookie.setPath(str_arry[1]);
                        continue;
                    }
                    if ("expires".equalsIgnoreCase(str_arry[0])) {
                        imResponseCookie.setExpires(str_arry[1]);
                        continue;
                    }
                    if ("max-age".equalsIgnoreCase(str_arry[0])) {
                        imResponseCookie.setMaxAge(str_arry[1]);
                        continue;
                    }
                    if ("secure".equalsIgnoreCase(str_arry[0])) {
                        imResponseCookie.setSecure(true);
                        continue;
                    }
                    if ("httponly".equalsIgnoreCase(str_arry[0])) {
                        imResponseCookie.setHttpOnly(true);
                        continue;
                    }
                    if (imResponseCookie.getName() != null) continue;
                    imResponseCookie.setName(str_arry[0]);
                    imResponseCookie.setValue(str_arry.length > 2 ? "null" : str_arry[1]);
                    imResponse.addCookie(str_arry[0], str_arry.length > 2 ? "null" : str_arry[1]);
                }
                imResponse.addCookieProperty(imResponseCookie);
            }
            cookieStr = builder.substring(0, builder.length() - 1).toString();
        }
        imResponse.setFullHeaders(headers);
        imResponse.setFullCookie(cookieStr);
        return imResponse;
    }

    private static ImResponse execute(ImRequest imRequest, ImSession imSession) throws ContentTypeException, DataTypeException, MethodException, IgnoreSSLException, QueryParamsException, AuthenticationException, IOException {
        ImResponse imResponse;
        ImSessionCallback callback;
        if (imSession.getHeaders().size() > 0) {
            imRequest.setHeader(imSession.getHeaders());
        }
        if (imSession.getCookies().size() > 0) {
            imRequest.setCookie(imSession.getCookies());
        }
        if ((callback = imSession.getCallback()) != null && !imSession.ExecCallbackNow && imSession.isNeedAuthentication()) {
            if (imSession.isAutoAuthentication()) {
                imSession.ExecCallbackNow = true;
                boolean isAuthentication = callback.isAuthentication(imSession, imRequest);
                for (int count = imSession.getAutoAuthenticationTryCount(); !isAuthentication && count > 0; --count) {
                    imSession.ExecCallbackNow = false;
                    imSession.ExecCallbackNow = true;
                    callback.doAuthentication(imSession, imRequest);
                    imSession.ExecCallbackNow = false;
                    imSession.ExecCallbackNow = true;
                    isAuthentication = callback.isAuthentication(imSession, imRequest);
                    if (!isAuthentication) continue;
                    imSession.ExecCallbackNow = false;
                }
                if (!isAuthentication) {
                    throw new AuthenticationException("Not have authentication.");
                }
            } else {
                throw new AuthenticationException("Not have authentication.");
            }
        }
        if (imSession.getHeaders().size() > 0) {
            imRequest.setHeader(imSession.getHeaders());
        }
        if (imSession.getCookies().size() > 0) {
            imRequest.setCookie(imSession.getCookies());
        }
        if ((imResponse = ImHttpClient.execute(imRequest)).getCookieSize() > 0) {
            Set<String> cookieNames = imResponse.getCookieNames();
            for (String cookieName : cookieNames) {
                imSession.setCookie(cookieName, imResponse.getCookieData(cookieName));
            }
        }
        return imResponse;
    }

    private static String getInputDataToString(ImRequest imRequest) throws UnsupportedEncodingException {
        return ImHttpClient.getInputDataToString(imRequest, false);
    }

    private static String getInputDataToString(ImRequest imRequest, boolean forceKeyValueModel) throws UnsupportedEncodingException {
        if (imRequest.getInputData() != null) {
            String inputData = "";
            if (imRequest.getInputData() instanceof String) {
                inputData = imRequest.isUrlEncode() ? URLEncoder.encode(imRequest.getInputData(String.class), imRequest.getCharset()) : imRequest.getInputData(String.class);
            }
            if (imRequest.getInputData().getClass() == JSONObject.class) {
                if (imRequest.getContentType() == ImContentType.APPLICATION_JSON && !forceKeyValueModel) {
                    inputData = imRequest.getInputData(JSONObject.class).toJSONString();
                } else {
                    JSONObject json = imRequest.getInputData(JSONObject.class);
                    for (String key : json.keySet()) {
                        if (imRequest.isUrlEncode()) {
                            inputData = inputData + key + "=" + URLEncoder.encode(json.getString(key), imRequest.getCharset()) + "&";
                            continue;
                        }
                        inputData = inputData + key + "=" + json.getString(key) + "&";
                    }
                    inputData = inputData.substring(0, inputData.length() - 1);
                }
            }
            if (imRequest.getInputData().getClass() != JSONObject.class && imRequest.getInputData() instanceof Map) {
                if (imRequest.getContentType() == ImContentType.APPLICATION_JSON && !forceKeyValueModel) {
                    inputData = JSON.toJSONString((Object)imRequest.getInputData(Map.class));
                } else {
                    Map map = imRequest.getInputData(Map.class);
                    for (String key : map.keySet()) {
                        if (imRequest.isUrlEncode()) {
                            inputData = inputData + key + "=" + URLEncoder.encode((String)map.get(key), imRequest.getCharset()) + "&";
                            continue;
                        }
                        inputData = inputData + key + "=" + (String)map.get(key) + "&";
                    }
                    inputData = inputData.substring(0, inputData.length() - 1);
                }
            }
            if (imRequest.getInputData().getClass() == ImFormData.class) {
                ImFormData imFormData = imRequest.getInputData(ImFormData.class);
                if (imRequest.getContentType() == ImContentType.APPLICATION_JSON && !forceKeyValueModel) {
                    JSONObject json = new JSONObject();
                    json.put(imFormData.getName(), (Object)imFormData.getValue());
                    inputData = json.toJSONString();
                } else {
                    inputData = imRequest.isUrlEncode() ? imFormData.getName() + "=" + URLEncoder.encode(imFormData.getValue(), imRequest.getCharset()) : imFormData.getName() + "=" + imFormData.getValue();
                }
            }
            return inputData;
        }
        return null;
    }

    private static String getQueryParamsToString(ImRequest imRequest) throws UnsupportedEncodingException {
        if (imRequest.getQueryParams() != null) {
            String queryParams = "";
            if (imRequest.getQueryParams() instanceof String) {
                queryParams = imRequest.isUrlEncode() ? URLEncoder.encode(imRequest.getQueryParams(String.class), imRequest.getCharset()) : imRequest.getQueryParams(String.class);
            }
            if (imRequest.getQueryParams().getClass() == JSONObject.class) {
                JSONObject json = imRequest.getQueryParams(JSONObject.class);
                for (String key : json.keySet()) {
                    if (imRequest.isUrlEncode()) {
                        queryParams = queryParams + key + "=" + URLEncoder.encode(json.getString(key), imRequest.getCharset()) + "&";
                        continue;
                    }
                    queryParams = queryParams + key + "=" + json.getString(key) + "&";
                }
                queryParams = queryParams.substring(0, queryParams.length() - 1);
            }
            if (imRequest.getQueryParams().getClass() != JSONObject.class && imRequest.getQueryParams() instanceof Map) {
                Map map = imRequest.getQueryParams(Map.class);
                for (String key : map.keySet()) {
                    if (imRequest.isUrlEncode()) {
                        queryParams = queryParams + key + "=" + URLEncoder.encode((String)map.get(key), imRequest.getCharset()) + "&";
                        continue;
                    }
                    queryParams = queryParams + key + "=" + (String)map.get(key) + "&";
                }
                queryParams = queryParams.substring(0, queryParams.length() - 1);
            }
            return queryParams;
        }
        return null;
    }

    private static ByteArrayOutputStream toByteArrayOutputStream(InputStream input, int bytesLength) throws IOException {
        if (bytesLength == 0) {
            bytesLength = 4096;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytesLength];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        return output;
    }

    private static byte[] toByteArray(InputStream input, int bytesLength) throws IOException {
        if (bytesLength == 0) {
            bytesLength = 4096;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytesLength];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        return output.toByteArray();
    }

    private ImHttpClient() {
    }
}

