/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.bean.ImBytesData;
import cn.sinlmao.commons.network.bean.ImFileData;
import cn.sinlmao.commons.network.bean.ImMultipartFormData;
import cn.sinlmao.commons.network.callback.ImHttpClientCallback;
import cn.sinlmao.commons.network.http.ImCharset;
import cn.sinlmao.commons.network.http.ImContentType;
import cn.sinlmao.commons.network.http.ImMethod;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImRequest {
    private String url;
    private ImMethod method = ImMethod.GET;
    private String charset = "utf-8";
    private Object inputData;
    private Object queryParams;
    private int bytesLength = 4096;
    private ImContentType contentType = ImContentType.APPLICATION_X_WWW_FORM_URLENCODED;
    private String contentTypeStr;
    private boolean ignoreSSLCertVerify = false;
    private boolean keepAlive = false;
    private boolean useCache = false;
    private boolean allowNonStandard = false;
    private boolean restfulMode = false;
    private boolean forceInUrlSendData = false;
    private boolean urlEncode = false;
    private boolean tomcatLowVersionCompatible = false;
    private String userAgent;
    private boolean async = false;
    private ImHttpClientCallback callback;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> cookies = new HashMap<String, String>();
    private boolean enableProxyServer = false;
    private String proxyServerHost;
    private String proxyServerPort;

    public ImRequest(String url) {
        this.url = url;
    }

    public ImRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public ImRequest setMethod(ImMethod method) {
        this.method = method;
        return this;
    }

    public ImRequest setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public ImRequest setCharset(ImCharset imCharset) {
        this.charset = imCharset.toString();
        return this;
    }

    public ImRequest setInputData(String inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(Map<String, String> inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(JSONObject inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(ImBytesData inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(ImFileData inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(ImMultipartFormData inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setQueryParams(String queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public ImRequest setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public ImRequest setQueryParams(JSONObject queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public ImRequest setBytesLength(int bytesLength) {
        this.bytesLength = bytesLength;
        return this;
    }

    public ImRequest setContentType(ImContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public ImRequest setContentType(String contentType) {
        this.contentTypeStr = contentType;
        return this;
    }

    public ImRequest setIgnoreSSLCertVerify(boolean ignoreSSLCertVerify) {
        this.ignoreSSLCertVerify = ignoreSSLCertVerify;
        return this;
    }

    public ImRequest setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public ImRequest setUseCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public ImRequest setAllowNonStandard(boolean allowNonStandard) {
        this.allowNonStandard = allowNonStandard;
        return this;
    }

    public ImRequest setRestfulMode(boolean restfulMode) {
        this.restfulMode = restfulMode;
        this.allowNonStandard = restfulMode;
        return this;
    }

    public ImRequest setForceInUrlSendData(boolean forceInUrlSendData) {
        this.forceInUrlSendData = forceInUrlSendData;
        return this;
    }

    public ImRequest setUrlEncode(boolean urlEncode) {
        this.urlEncode = urlEncode;
        return this;
    }

    public ImRequest enableProxyServer(String host, int port) {
        this.enableProxyServer = true;
        this.proxyServerHost = host;
        this.proxyServerPort = String.valueOf(port);
        return this;
    }

    public ImRequest enableProxyServer(int port) {
        this.enableProxyServer = true;
        this.proxyServerHost = "127.0.0.1";
        this.proxyServerPort = String.valueOf(port);
        return this;
    }

    public ImRequest disableProxyServer() {
        this.enableProxyServer = false;
        this.proxyServerHost = "";
        this.proxyServerPort = "";
        return this;
    }

    public ImRequest setTomcatLowVersionCompatible(boolean tomcatLowVersionCompatible) {
        this.tomcatLowVersionCompatible = tomcatLowVersionCompatible;
        return this;
    }

    public ImRequest setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ImRequest setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public ImRequest setCallback(ImHttpClientCallback callback) {
        this.callback = callback;
        return this;
    }

    public ImRequest addHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, value);
        }
        return this;
    }

    public ImRequest addHeader(Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.addHeader(key, headers.get(key));
            }
        }
        return this;
    }

    public ImRequest addHeader(JSONObject headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.addHeader(key, headers.getString(key));
            }
        }
        return this;
    }

    public ImRequest setHeader(String name, String value) {
        if (this.headers.containsKey(name)) {
            this.headers.remove(name);
        }
        this.headers.put(name, value);
        return this;
    }

    public ImRequest setHeader(JSONObject headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.setHeader(key, headers.getString(key));
            }
        }
        return this;
    }

    public ImRequest setHeader(Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.setHeader(key, headers.get(key));
            }
        }
        return this;
    }

    public ImRequest addCookie(String name, String value) {
        if (!this.cookies.containsKey(name)) {
            this.cookies.put(name, value);
        }
        return this;
    }

    public ImRequest addCookie(Map<String, String> cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.addCookie(key, cookies.get(key));
            }
        }
        return this;
    }

    public ImRequest addCookie(JSONObject cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.addCookie(key, cookies.getString(key));
            }
        }
        return this;
    }

    public ImRequest setCookie(String name, String value) {
        if (this.cookies.containsKey(name)) {
            this.cookies.remove(name);
        }
        this.cookies.put(name, value);
        return this;
    }

    public ImRequest setCookie(Map<String, String> cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.setCookie(key, cookies.get(key));
            }
        }
        return this;
    }

    public ImRequest setCookie(JSONObject cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.setCookie(key, cookies.getString(key));
            }
        }
        return this;
    }

    public boolean isIgnoreSSLCertVerify() {
        return this.ignoreSSLCertVerify;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public boolean isAllowNonStandard() {
        return this.allowNonStandard;
    }

    public boolean isRestfulMode() {
        return this.restfulMode;
    }

    public boolean isForceInUrlSendData() {
        return this.forceInUrlSendData;
    }

    public boolean isUrlEncode() {
        return this.urlEncode;
    }

    public boolean isTomcatLowVersionCompatible() {
        return this.tomcatLowVersionCompatible;
    }

    public String getUserAgent() {
        if (this.userAgent == null || "".equals(this.userAgent.trim())) {
            this.userAgent = "ImHttpClient/1.4.3 (" + System.getProperty("os.name", "--") + " " + System.getProperty("os.arch", "--") + " " + System.getProperty("os.version", "--") + "; Java " + System.getProperty("java.version", "--") + ")";
        }
        return this.userAgent;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getUrl() {
        return this.url;
    }

    public ImMethod getMethod() {
        return this.method;
    }

    public String getCharset() {
        return this.charset;
    }

    public Object getInputData() {
        return this.inputData;
    }

    public <T> T getInputData(Class<T> type) {
        return (T)this.inputData;
    }

    public Object getQueryParams() {
        return this.queryParams;
    }

    public <T> T getQueryParams(Class<T> type) {
        return (T)this.queryParams;
    }

    public int getBytesLength() {
        return this.bytesLength;
    }

    public ImContentType getContentType() {
        return this.contentType;
    }

    public String getContentTypeStr() {
        if (this.contentTypeStr != null && this.contentTypeStr.length() > 1) {
            return this.contentTypeStr;
        }
        return this.contentType.toString();
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public int getHeaderSize() {
        return this.headers.size();
    }

    public String getCookieData(String name) {
        return this.cookies.get(name);
    }

    public Set<String> getCookieNames() {
        return this.cookies.keySet();
    }

    public int getCookieSize() {
        return this.cookies.size();
    }

    protected boolean isEnableProxyServer() {
        return this.enableProxyServer;
    }

    protected String getProxyServerHost() {
        return this.proxyServerHost;
    }

    protected String getProxyServerPort() {
        return this.proxyServerPort;
    }

    protected ImHttpClientCallback getCallback() {
        return this.callback;
    }
}

