/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.bean.ImBytesData;
import cn.sinlmao.commons.network.bean.ImFileData;
import cn.sinlmao.commons.network.bean.ImMultipartFormData;
import cn.sinlmao.commons.network.http.ImContentType;
import cn.sinlmao.commons.network.http.ImMethod;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImRequest {
    private String url;
    private ImMethod method = ImMethod.GET;
    private String charset = "utf-8";
    private Object inputData;
    private int bytesLength = 4096;
    private ImContentType contentType = ImContentType.APPLICATION_X_WWW_FORM_URLENCODED;
    private String contentTypeStr;
    private boolean ignoreSSLCertVerify = false;
    private boolean keepAlive = false;
    private boolean useCache = false;
    private boolean allowNonStandard = false;
    private boolean restfulMode = false;
    private boolean forceInUrlSendData = false;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> cookies = new HashMap<String, String>();

    public ImRequest(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public ImRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public ImRequest setMethod(ImMethod method) {
        this.method = method;
        return this;
    }

    public ImRequest setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public ImRequest setInputData(String inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(Map<String, String> inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(JSONObject inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(ImBytesData inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(ImFileData inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(ImMultipartFormData inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setBytesLength(int bytesLength) {
        this.bytesLength = bytesLength;
        return this;
    }

    public ImRequest setContentType(ImContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public ImRequest setContentType(String contentType) {
        this.contentTypeStr = contentType;
        return this;
    }

    public boolean isIgnoreSSLCertVerify() {
        return this.ignoreSSLCertVerify;
    }

    public void setIgnoreSSLCertVerify(boolean ignoreSSLCertVerify) {
        this.ignoreSSLCertVerify = ignoreSSLCertVerify;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean isAllowNonStandard() {
        return this.allowNonStandard;
    }

    public void setAllowNonStandard(boolean allowNonStandard) {
        this.allowNonStandard = allowNonStandard;
    }

    public boolean isRestfulMode() {
        return this.restfulMode;
    }

    public void setRestfulMode(boolean restfulMode) {
        this.restfulMode = restfulMode;
        this.allowNonStandard = restfulMode;
    }

    public boolean isForceInUrlSendData() {
        return this.forceInUrlSendData;
    }

    public void setForceInUrlSendData(boolean forceInUrlSendData) {
        this.forceInUrlSendData = forceInUrlSendData;
    }

    public ImMethod getMethod() {
        return this.method;
    }

    public String getCharset() {
        return this.charset;
    }

    public Object getInputData() {
        return this.inputData;
    }

    public <T> T getInputData(Class<T> type) {
        return (T)this.inputData;
    }

    public int getBytesLength() {
        return this.bytesLength;
    }

    public ImContentType getContentType() {
        return this.contentType;
    }

    public String getContentTypeStr() {
        return this.contentTypeStr;
    }

    public void addHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, value);
        }
    }

    public void addHeader(Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.addHeader(key, headers.get(key));
            }
        }
    }

    public void addHeader(JSONObject headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.addHeader(key, headers.getString(key));
            }
        }
    }

    public void setHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.remove(name);
        }
        this.headers.put(name, value);
    }

    public void setHeader(JSONObject headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.setHeader(key, headers.getString(key));
            }
        }
    }

    public void setHeader(Map<String, String> headers) {
        if (headers != null && headers.size() > 0) {
            for (String key : headers.keySet()) {
                this.setHeader(key, headers.get(key));
            }
        }
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public int getHeaderSize() {
        return this.headers.size();
    }

    public void addCookie(String name, String value) {
        if (!this.cookies.containsKey(name)) {
            this.cookies.put(name, value);
        }
    }

    public void addCookie(Map<String, String> cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.addCookie(key, cookies.get(key));
            }
        }
    }

    public void addCookie(JSONObject cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.addCookie(key, cookies.getString(key));
            }
        }
    }

    public void setCookie(String name, String value) {
        if (!this.cookies.containsKey(name)) {
            this.cookies.remove(name);
        }
        this.cookies.put(name, value);
    }

    public void setCookie(Map<String, String> cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.setCookie(key, cookies.get(key));
            }
        }
    }

    public void setCookie(JSONObject cookies) {
        if (cookies != null && cookies.size() > 0) {
            for (String key : cookies.keySet()) {
                this.setCookie(key, cookies.getString(key));
            }
        }
    }

    public String getCookieData(String name) {
        return this.cookies.get(name);
    }

    public Set<String> getCookieNames() {
        return this.cookies.keySet();
    }

    public int getCookieSize() {
        return this.cookies.size();
    }
}

