/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.bean.ImBytesData;
import cn.sinlmao.commons.network.bean.ImFileData;
import cn.sinlmao.commons.network.bean.ImFormData;
import cn.sinlmao.commons.network.bean.ImMultipartFormData;
import cn.sinlmao.commons.network.exception.ContentTypeException;
import cn.sinlmao.commons.network.exception.DataTypeException;
import cn.sinlmao.commons.network.exception.MethodException;
import cn.sinlmao.commons.network.http.ImContentType;
import cn.sinlmao.commons.network.http.ImMethod;
import cn.sinlmao.commons.network.http.ImRequest;
import cn.sinlmao.commons.network.http.ImResponse;
import cn.sinlmao.commons.network.tools.IgnoreSSLTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImHttpClient {
    private static final String PREFIX = "--";
    private static final String WRAP = System.getProperty("line.separator");

    public static ImResponse send(ImRequest imRequest) throws Exception {
        String output_line;
        String boundary = "--------------------------" + String.valueOf(System.currentTimeMillis());
        if (!imRequest.isAllowNonStandard()) {
            if (imRequest.getContentType() != ImContentType.APPLICATION_X_WWW_FORM_URLENCODED && (imRequest.getMethod() == ImMethod.GET || imRequest.getMethod() == ImMethod.HEAD)) {
                throw new ContentTypeException("Can't use an inappropriate ContentType.");
            }
            if (imRequest.getContentType() != ImContentType.MULTIPART_FORM_DATA && imRequest.getInputData() != null) {
                if (imRequest.getInputData().getClass() == ImBytesData.class || imRequest.getInputData().getClass() == ImFileData.class || imRequest.getInputData().getClass() == ImMultipartFormData.class) {
                    throw new MethodException("Can't use an inappropriate Method.");
                }
                if (imRequest.getInputData().getClass() == ImFormData.class) {
                    throw new DataTypeException("This data type is not supported.");
                }
            }
            if (imRequest.getContentType() == ImContentType.MULTIPART_FORM_DATA && imRequest.getMethod() != ImMethod.POST && imRequest.getMethod() != ImMethod.PUT) {
                throw new MethodException("Can't use an inappropriate Method.");
            }
        }
        if (imRequest.isForceInUrlSendData()) {
            if (imRequest.getInputData() != null && (imRequest.getInputData().getClass() == ImFileData.class || imRequest.getInputData().getClass() == ImMultipartFormData.class || imRequest.getInputData().getClass() == ImBytesData.class)) {
                throw new DataTypeException("This data type is not supported.");
            }
            if (imRequest.getContentType() != ImContentType.APPLICATION_X_WWW_FORM_URLENCODED) {
                throw new ContentTypeException("Can't use an inappropriate ContentType.");
            }
        }
        String urlStr = imRequest.getUrl();
        if (imRequest.isForceInUrlSendData() && imRequest.getInputData() != null) {
            String urlPars = ImHttpClient.getInputDataStringForm(imRequest, true);
            urlStr = urlStr.contains("?") ? urlStr + "&" + urlPars : urlStr + "?" + urlPars;
        }
        ImResponse imResponse = new ImResponse();
        IgnoreSSLTool.setIsIgnore(imRequest.isIgnoreSSLCertVerify());
        URL url = new URL(urlStr);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setRequestMethod(imRequest.getMethod().toString());
        httpConnection.setUseCaches(imRequest.isUseCache());
        httpConnection.setRequestProperty("Accept-Charset", imRequest.getCharset());
        httpConnection.setRequestProperty("Accept", "*/*");
        httpConnection.setRequestProperty("Content-Type", imRequest.getContentType().toString() + "; charset=" + imRequest.getCharset());
        if (imRequest.isKeepAlive() || imRequest.getContentType() == ImContentType.MULTIPART_FORM_DATA) {
            httpConnection.setRequestProperty("Connection", "keep-alive");
        }
        if (imRequest.getContentType() == ImContentType.MULTIPART_FORM_DATA) {
            httpConnection.setRequestProperty("Content-Type", imRequest.getContentType().toString() + "; charset=" + imRequest.getCharset() + "; boundary=" + boundary);
            httpConnection.setChunkedStreamingMode(0);
        }
        if (imRequest.getContentTypeStr() != null && !"".equals(imRequest.getContentTypeStr())) {
            httpConnection.setRequestProperty("Content-Type", imRequest.getContentTypeStr());
        }
        if (imRequest.getHeaderSize() > 0) {
            Set<String> headerNames = imRequest.getHeaderNames();
            for (String string : headerNames) {
                httpConnection.setRequestProperty(string, imRequest.getHeaderValue(string));
            }
        }
        if (imRequest.getCookieSize() > 0) {
            Set<String> cookieNames = imRequest.getHeaderNames();
            StringBuilder cookieStrs = new StringBuilder();
            for (String cookieName : cookieNames) {
                cookieStrs.append(cookieName + "=" + imRequest.getCookieData(cookieName));
                cookieStrs.append(";");
            }
            String string = cookieStrs.substring(0, cookieStrs.length() - 1);
            httpConnection.setRequestProperty("Cookie", string);
        }
        if (imRequest.getInputData() != null) {
            if (imRequest.getContentType() != ImContentType.MULTIPART_FORM_DATA) {
                OutputStream outputStream;
                String inputData = "";
                if (imRequest.getContentType() != ImContentType.APPLICATION_X_WWW_FORM_URLENCODED) {
                    inputData = ImHttpClient.getInputDataStringForm(imRequest);
                    httpConnection.setDoOutput(true);
                    httpConnection.setDoInput(true);
                    if (!imRequest.isForceInUrlSendData()) {
                        outputStream = httpConnection.getOutputStream();
                        outputStream.write(inputData.getBytes(Charset.forName(imRequest.getCharset())));
                        outputStream.flush();
                        outputStream.close();
                    }
                } else {
                    inputData = ImHttpClient.getInputDataStringForm(imRequest, true);
                    httpConnection.setDoOutput(true);
                    httpConnection.setDoInput(true);
                    if (!imRequest.isForceInUrlSendData()) {
                        outputStream = httpConnection.getOutputStream();
                        outputStream.write(inputData.getBytes(Charset.forName(imRequest.getCharset())));
                        outputStream.flush();
                        outputStream.close();
                    }
                }
            } else {
                httpConnection.setDoOutput(true);
                httpConnection.setDoInput(true);
                DataOutputStream dataOutputStream = new DataOutputStream(httpConnection.getOutputStream());
                String file_header = PREFIX + boundary + WRAP;
                String string = WRAP + PREFIX + boundary + WRAP;
                String file_footer = WRAP + PREFIX + boundary + PREFIX;
                if (imRequest.getInputData().getClass() == ImFileData.class) {
                    ImFileData imFileData = imRequest.getInputData(ImFileData.class);
                    String file_disposition = "Content-Disposition: form-data; name=\"" + imFileData.getName() + "\"; filename=\"" + imFileData.getFileName() + "\"" + WRAP;
                    String file_content_type = "Content-Type: " + imFileData.getFileType() + WRAP + WRAP;
                    dataOutputStream.writeBytes(file_header);
                    dataOutputStream.writeBytes(file_disposition);
                    dataOutputStream.writeBytes(file_content_type);
                    dataOutputStream.write(imFileData.getBytes());
                    dataOutputStream.writeBytes(file_footer);
                }
                if (imRequest.getInputData().getClass() == ImMultipartFormData.class) {
                    ImMultipartFormData imMultipartFormData = imRequest.getInputData(ImMultipartFormData.class);
                    dataOutputStream.writeBytes(file_header);
                    while (imMultipartFormData.hasNext()) {
                        String file_content_type;
                        String file_disposition;
                        Object data = imMultipartFormData.nextData();
                        if (data.getClass() == ImFileData.class) {
                            ImFileData imFileData = (ImFileData)data;
                            file_disposition = "Content-Disposition: form-data; name=\"" + imFileData.getName() + "\"; filename=\"" + imFileData.getFileName() + "\"" + WRAP;
                            file_content_type = "Content-Type: " + imFileData.getFileType() + WRAP + WRAP;
                            dataOutputStream.writeBytes(file_disposition);
                            dataOutputStream.writeBytes(file_content_type);
                            dataOutputStream.write(imFileData.getBytes());
                        }
                        if (data.getClass() == ImFormData.class) {
                            ImFormData imFormData = (ImFormData)data;
                            file_disposition = "Content-Disposition: form-data; name=\"" + imFormData.getName() + "\"" + WRAP;
                            file_content_type = "Content-Type: " + imFormData.getContentType() + WRAP + WRAP;
                            dataOutputStream.writeBytes(file_disposition);
                            dataOutputStream.writeBytes(file_content_type);
                            dataOutputStream.writeBytes(imFormData.getValue());
                        }
                        if (!imMultipartFormData.hasNext()) continue;
                        dataOutputStream.writeBytes(string);
                    }
                    dataOutputStream.writeBytes(file_footer);
                }
                if (imRequest.getInputData().getClass() == ImBytesData.class) {
                    ImBytesData imBytesData = imRequest.getInputData(ImBytesData.class);
                    dataOutputStream.write(imBytesData.getBytes());
                }
                dataOutputStream.flush();
                dataOutputStream.close();
            }
        }
        imResponse.setResponseCode(httpConnection.getResponseCode());
        imResponse.setResponseMessage(httpConnection.getResponseMessage());
        byte[] out_bytes = ImHttpClient.toByteArray(httpConnection.getInputStream(), imRequest.getBytesLength());
        BufferedReader responseBuffer = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out_bytes), imRequest.getCharset()));
        StringBuffer stringBuffer = new StringBuffer();
        while ((output_line = responseBuffer.readLine()) != null) {
            stringBuffer.append(output_line);
            stringBuffer.append(System.getProperty("line.separator"));
        }
        httpConnection.disconnect();
        imResponse.setStringContent(stringBuffer.toString());
        imResponse.setBytesContent(out_bytes);
        String cookieStr = "";
        Map<String, List<String>> headers = httpConnection.getHeaderFields();
        Set<String> headerNames = headers.keySet();
        for (String headerName : headerNames) {
            if (!"Set-Cookie".equals(headerName)) continue;
            List<String> headerData = headers.get(headerName);
            StringBuilder builder = new StringBuilder();
            for (String data : headerData) {
                String[] strs_arry;
                builder.append(data).toString();
                for (String str : strs_arry = data.split("; ")) {
                    String[] str_arry = str.split("=");
                    if (str_arry.length == 2) {
                        imResponse.addCookie(str_arry[0], str_arry[1]);
                        continue;
                    }
                    imResponse.addCookie(str_arry[0], null);
                }
            }
            cookieStr = builder.toString();
        }
        imResponse.setHeaders(headers);
        imResponse.setCookie(cookieStr);
        return imResponse;
    }

    private static String getInputDataStringForm(ImRequest imRequest) {
        return ImHttpClient.getInputDataStringForm(imRequest, false);
    }

    private static String getInputDataStringForm(ImRequest imRequest, boolean forceKeyValueModel) {
        if (imRequest.getInputData() != null) {
            String inputData = "";
            if (imRequest.getInputData() instanceof String) {
                inputData = imRequest.getInputData(String.class);
            }
            if (imRequest.getInputData().getClass() == JSONObject.class) {
                if (imRequest.getContentType() == ImContentType.APPLICATION_JSON && !forceKeyValueModel) {
                    inputData = imRequest.getInputData(JSONObject.class).toJSONString();
                } else {
                    JSONObject json = imRequest.getInputData(JSONObject.class);
                    for (String key : json.keySet()) {
                        inputData = inputData + key + "=" + json.getString(key) + "&";
                    }
                    inputData = inputData.substring(0, inputData.length() - 1);
                }
            }
            if (imRequest.getInputData().getClass() != JSONObject.class && imRequest.getInputData() instanceof Map) {
                if (imRequest.getContentType() == ImContentType.APPLICATION_JSON && !forceKeyValueModel) {
                    inputData = JSON.toJSONString((Object)imRequest.getInputData(Map.class));
                } else {
                    Map map = imRequest.getInputData(Map.class);
                    for (String key : map.keySet()) {
                        inputData = inputData + key + "=" + (String)map.get(key) + "&";
                    }
                    inputData = inputData.substring(0, inputData.length() - 1);
                }
            }
            if (imRequest.getInputData().getClass() == ImFormData.class) {
                ImFormData imFormData = imRequest.getInputData(ImFormData.class);
                if (imRequest.getContentType() == ImContentType.APPLICATION_JSON && !forceKeyValueModel) {
                    JSONObject json = new JSONObject();
                    json.put(imFormData.getName(), (Object)imFormData.getValue());
                    inputData = json.toJSONString();
                } else {
                    inputData = imFormData.getName() + "=" + imFormData.getValue();
                }
            }
            return inputData;
        }
        return null;
    }

    private static ByteArrayOutputStream toByteArrayOutputStream(InputStream input, int bytesLength) throws IOException {
        if (bytesLength == 0) {
            bytesLength = 4096;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytesLength];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        return output;
    }

    private static byte[] toByteArray(InputStream input, int bytesLength) throws IOException {
        if (bytesLength == 0) {
            bytesLength = 4096;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytesLength];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        return output.toByteArray();
    }
}

