/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.http.ImContentType;
import cn.sinlmao.commons.network.http.ImMethod;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImRequest {
    private String url;
    private ImMethod method;
    private String charset = "utf-8";
    private Object inputData;
    private int bytesLength = 4096;
    private ImContentType contentType = ImContentType.APPLICATION_X_WWW_FORM_URLENCODED;
    private String contentTypeStr;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> cookies = new HashMap<String, String>();

    public ImRequest(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public ImRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public ImRequest setMethod(ImMethod method) {
        this.method = method;
        return this;
    }

    public ImRequest setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public ImRequest setInputData(String inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(Map<String, String> inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setInputData(JSONObject inputData) {
        this.inputData = inputData;
        return this;
    }

    public ImRequest setBytesLength(int bytesLength) {
        this.bytesLength = bytesLength;
        return this;
    }

    public ImRequest setContentType(ImContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public ImRequest setContentType(String contentType) {
        this.contentTypeStr = contentType;
        return this;
    }

    public ImMethod getMethod() {
        return this.method;
    }

    public String getCharset() {
        return this.charset;
    }

    public Object getInputData() {
        return this.inputData;
    }

    public <T> T getInputData(Class<T> type) {
        return (T)this.inputData;
    }

    public int getBytesLength() {
        return this.bytesLength;
    }

    public ImContentType getContentType() {
        return this.contentType;
    }

    public String getContentTypeStr() {
        return this.contentTypeStr;
    }

    protected void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public int getHeaderSize() {
        return this.headers.size();
    }

    protected void addCookie(String name, String value) {
        this.cookies.put(name, value);
    }

    public String getCookieData(String name) {
        return this.cookies.get(name);
    }

    public Set<String> getCookieNames() {
        return this.cookies.keySet();
    }

    public int getCookieSize() {
        return this.cookies.size();
    }
}

