/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.http.ImContentType;
import cn.sinlmao.commons.network.http.ImRequest;
import cn.sinlmao.commons.network.http.ImResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImHttpClient {
    public static ImResponse send(ImRequest imRequest) throws Exception {
        String output_line;
        ImResponse imResponse = new ImResponse();
        URL restServiceURL = new URL(imRequest.getUrl());
        HttpURLConnection httpConnection = (HttpURLConnection)restServiceURL.openConnection();
        httpConnection.setRequestMethod(imRequest.getMethod().toString());
        httpConnection.setRequestProperty("Accept", "*/*");
        httpConnection.setRequestProperty("Content-Type", ImHttpClient.getContentType(imRequest.getContentType()) + ";charset=" + imRequest.getCharset());
        if (imRequest.getContentTypeStr() != null && !"".equals(imRequest.getContentTypeStr())) {
            httpConnection.setRequestProperty("Content-Type", imRequest.getContentTypeStr());
        }
        if (imRequest.getHeaderSize() > 0) {
            Set<String> headerNames = imRequest.getHeaderNames();
            for (String string : headerNames) {
                httpConnection.setRequestProperty(string, imRequest.getHeaderValue(string));
            }
        }
        if (imRequest.getCookieSize() > 0) {
            Set<String> cookieNames = imRequest.getHeaderNames();
            StringBuilder cookieStrs = new StringBuilder();
            for (String cookieName : cookieNames) {
                cookieStrs.append(cookieName + "=" + imRequest.getCookieData(cookieName));
                cookieStrs.append(";");
            }
            String string = cookieStrs.substring(0, cookieStrs.length() - 1);
            httpConnection.setRequestProperty("Cookie", string);
        }
        if (imRequest.getInputData() != null) {
            Map map;
            JSONObject json;
            String inputData = "";
            if ("POST".equals(imRequest.getMethod().toString()) || "PUT".equals(imRequest.getMethod().toString())) {
                if (imRequest.getInputData() instanceof String) {
                    inputData = imRequest.getInputData(String.class);
                }
                if (imRequest.getInputData() instanceof JSONObject) {
                    if (imRequest.getContentType() == ImContentType.APPLICATION_JSON) {
                        inputData = imRequest.getInputData(JSONObject.class).toJSONString();
                    } else {
                        json = imRequest.getInputData(JSONObject.class);
                        for (String key : json.keySet()) {
                            inputData = inputData + key + "=" + json.getString(key) + "&";
                        }
                        inputData = inputData.substring(0, inputData.length() - 1);
                    }
                }
                if (imRequest.getInputData() instanceof Map) {
                    if (imRequest.getContentType() == ImContentType.APPLICATION_JSON) {
                        inputData = JSON.toJSONString((Object)imRequest.getInputData(Map.class));
                    } else {
                        map = imRequest.getInputData(Map.class);
                        for (String key : map.keySet()) {
                            inputData = inputData + key + "=" + (String)map.get(key) + "&";
                        }
                        inputData = inputData.substring(0, inputData.length() - 1);
                    }
                }
                httpConnection.setDoOutput(true);
                httpConnection.setDoInput(true);
                httpConnection.setRequestProperty("Accept-Charset", imRequest.getCharset());
                OutputStream outputStream = httpConnection.getOutputStream();
                outputStream.write(inputData.getBytes(Charset.forName(imRequest.getCharset())));
                outputStream.flush();
                outputStream.close();
            } else {
                if (imRequest.getInputData() instanceof String) {
                    inputData = imRequest.getInputData(String.class);
                }
                if (imRequest.getInputData() instanceof JSONObject) {
                    json = imRequest.getInputData(JSONObject.class);
                    for (String key : json.keySet()) {
                        inputData = inputData + key + "=" + json.getString(key) + "&";
                    }
                    inputData = inputData.substring(0, inputData.length() - 1);
                }
                if (imRequest.getInputData() instanceof Map) {
                    map = imRequest.getInputData(Map.class);
                    for (String key : map.keySet()) {
                        inputData = inputData + key + "=" + (String)map.get(key) + "&";
                    }
                    inputData = inputData.substring(0, inputData.length() - 1);
                }
                httpConnection.setDoOutput(true);
                DataOutputStream dataOutputStream = new DataOutputStream(httpConnection.getOutputStream());
                dataOutputStream.writeBytes(inputData);
                dataOutputStream.flush();
                dataOutputStream.close();
            }
        }
        imResponse.setResponseCode(httpConnection.getResponseCode());
        byte[] bytes = ImHttpClient.toByteArray(httpConnection.getInputStream(), imRequest.getBytesLength());
        BufferedReader responseBuffer = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), imRequest.getCharset()));
        StringBuffer stringBuffer = new StringBuffer();
        while ((output_line = responseBuffer.readLine()) != null) {
            stringBuffer.append(output_line);
        }
        httpConnection.disconnect();
        imResponse.setStringContent(stringBuffer.toString());
        imResponse.setBytesContent(bytes);
        String cookieStr = "";
        Map<String, List<String>> headers = httpConnection.getHeaderFields();
        Set<String> headerNames = headers.keySet();
        for (String headerName : headerNames) {
            if (!"Set-Cookie".equals(headerName)) continue;
            List<String> headerData = headers.get(headerName);
            StringBuilder builder = new StringBuilder();
            for (String data : headerData) {
                String[] strs_arry;
                builder.append(data).toString();
                for (String str : strs_arry = data.split("; ")) {
                    String[] str_arry = str.split("=");
                    imResponse.addCookie(str_arry[0], str_arry[1]);
                }
            }
            cookieStr = builder.toString();
        }
        imResponse.setHeaders(headers);
        imResponse.setCookie(cookieStr);
        return imResponse;
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(InputStream input, int bytesLength) throws IOException {
        if (bytesLength == 0) {
            bytesLength = 4096;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytesLength];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        return output;
    }

    public static byte[] toByteArray(InputStream input, int bytesLength) throws IOException {
        if (bytesLength == 0) {
            bytesLength = 4096;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytesLength];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        return output.toByteArray();
    }

    private static String getContentType(ImContentType contentType) {
        switch (contentType) {
            case APPLICATION_JSON: {
                return "application/json";
            }
            case APPLICATION_X_WWW_FORM_URLENCODED: {
                return "application/x-www-form-urlencoded";
            }
        }
        return "";
    }
}

