/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.network.http;

import cn.sinlmao.commons.network.http.HttpUtilContentType;
import cn.sinlmao.commons.network.http.HttpUtilRequest;
import cn.sinlmao.commons.network.http.HttpUtilResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpUtilClient {
    public static HttpUtilResponse send(HttpUtilRequest httpUtilRequest) throws Exception {
        String output_line;
        HttpUtilResponse httpUtilResponse = new HttpUtilResponse();
        URL restServiceURL = new URL(httpUtilRequest.getUrl());
        HttpURLConnection httpConnection = (HttpURLConnection)restServiceURL.openConnection();
        httpConnection.setRequestMethod(httpUtilRequest.getMethod().toString());
        httpConnection.setRequestProperty("Accept", "*/*");
        httpConnection.setRequestProperty("Content-Type", HttpUtilClient.getContentType(httpUtilRequest.getContentType()) + ";charset=" + httpUtilRequest.getCharset());
        if (httpUtilRequest.getContentTypeStr() != null && !"".equals(httpUtilRequest.getContentTypeStr())) {
            httpConnection.setRequestProperty("Content-Type", httpUtilRequest.getContentTypeStr());
        }
        if (httpUtilRequest.getHeaderSize() > 0) {
            Set<String> headerNames = httpUtilRequest.getHeaderNames();
            for (String string : headerNames) {
                httpConnection.setRequestProperty(string, httpUtilRequest.getHeaderValue(string));
            }
        }
        if (httpUtilRequest.getCookieSize() > 0) {
            Set<String> cookieNames = httpUtilRequest.getHeaderNames();
            StringBuilder cookieStrs = new StringBuilder();
            for (String cookieName : cookieNames) {
                cookieStrs.append(cookieName + "=" + httpUtilRequest.getCookieData(cookieName));
                cookieStrs.append(";");
            }
            String string = cookieStrs.substring(0, cookieStrs.length() - 1);
            httpConnection.setRequestProperty("Cookie", string);
        }
        if (httpUtilRequest.getInputData() != null) {
            Map map;
            JSONObject json;
            String inputData = "";
            if ("POST".equals(httpUtilRequest.getMethod().toString()) || "PUT".equals(httpUtilRequest.getMethod().toString())) {
                if (httpUtilRequest.getInputData() instanceof String) {
                    inputData = httpUtilRequest.getInputData(String.class);
                }
                if (httpUtilRequest.getInputData() instanceof JSONObject) {
                    if (httpUtilRequest.getContentType() == HttpUtilContentType.APPLICATION_JSON) {
                        inputData = httpUtilRequest.getInputData(JSONObject.class).toJSONString();
                    } else {
                        json = httpUtilRequest.getInputData(JSONObject.class);
                        for (String key : json.keySet()) {
                            inputData = inputData + key + "=" + json.getString(key) + "&";
                        }
                        inputData = inputData.substring(0, inputData.length() - 1);
                    }
                }
                if (httpUtilRequest.getInputData() instanceof Map) {
                    if (httpUtilRequest.getContentType() == HttpUtilContentType.APPLICATION_JSON) {
                        inputData = JSON.toJSONString((Object)httpUtilRequest.getInputData(Map.class));
                    } else {
                        map = httpUtilRequest.getInputData(Map.class);
                        for (String key : map.keySet()) {
                            inputData = inputData + key + "=" + (String)map.get(key) + "&";
                        }
                        inputData = inputData.substring(0, inputData.length() - 1);
                    }
                }
                httpConnection.setDoOutput(true);
                httpConnection.setDoInput(true);
                httpConnection.setRequestProperty("Accept-Charset", httpUtilRequest.getCharset());
                OutputStream outputStream = httpConnection.getOutputStream();
                outputStream.write(inputData.getBytes(Charset.forName(httpUtilRequest.getCharset())));
                outputStream.flush();
                outputStream.close();
            } else {
                if (httpUtilRequest.getInputData() instanceof String) {
                    inputData = httpUtilRequest.getInputData(String.class);
                }
                if (httpUtilRequest.getInputData() instanceof JSONObject) {
                    json = httpUtilRequest.getInputData(JSONObject.class);
                    for (String key : json.keySet()) {
                        inputData = inputData + key + "=" + json.getString(key) + "&";
                    }
                    inputData = inputData.substring(0, inputData.length() - 1);
                }
                if (httpUtilRequest.getInputData() instanceof Map) {
                    map = httpUtilRequest.getInputData(Map.class);
                    for (String key : map.keySet()) {
                        inputData = inputData + key + "=" + (String)map.get(key) + "&";
                    }
                    inputData = inputData.substring(0, inputData.length() - 1);
                }
                httpConnection.setDoOutput(true);
                DataOutputStream dataOutputStream = new DataOutputStream(httpConnection.getOutputStream());
                dataOutputStream.writeBytes(inputData);
                dataOutputStream.flush();
                dataOutputStream.close();
            }
        }
        httpUtilResponse.setResponseCode(httpConnection.getResponseCode());
        byte[] bytes = HttpUtilClient.toByteArray(httpConnection.getInputStream(), httpUtilRequest.getBytesLength());
        BufferedReader responseBuffer = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), httpUtilRequest.getCharset()));
        StringBuffer stringBuffer = new StringBuffer();
        while ((output_line = responseBuffer.readLine()) != null) {
            stringBuffer.append(output_line);
        }
        httpConnection.disconnect();
        httpUtilResponse.setStringContent(stringBuffer.toString());
        httpUtilResponse.setBytesContent(bytes);
        String cookieStr = "";
        Map<String, List<String>> headers = httpConnection.getHeaderFields();
        Set<String> headerNames = headers.keySet();
        for (String headerName : headerNames) {
            if (!"Set-Cookie".equals(headerName)) continue;
            List<String> headerData = headers.get(headerName);
            StringBuilder builder = new StringBuilder();
            for (String data : headerData) {
                String[] strs_arry;
                builder.append(data).toString();
                for (String str : strs_arry = data.split("; ")) {
                    String[] str_arry = str.split("=");
                    httpUtilResponse.addCookie(str_arry[0], str_arry[1]);
                }
            }
            cookieStr = builder.toString();
        }
        httpUtilResponse.setHeaders(headers);
        httpUtilResponse.setCookie(cookieStr);
        return httpUtilResponse;
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(InputStream input, int bytesLength) throws IOException {
        if (bytesLength == 0) {
            bytesLength = 4096;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytesLength];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        return output;
    }

    public static byte[] toByteArray(InputStream input, int bytesLength) throws IOException {
        if (bytesLength == 0) {
            bytesLength = 4096;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytesLength];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        input.close();
        return output.toByteArray();
    }

    private static String getContentType(HttpUtilContentType contentType) {
        switch (contentType) {
            case APPLICATION_JSON: {
                return "application/json";
            }
            case APPLICATION_X_WWW_FORM_URLENCODED: {
                return "application/x-www-form-urlencoded";
            }
        }
        return "";
    }
}

