/*
 * Decompiled with CFR 0.152.
 */
package cn.sinlmao.commons.helper.dubbo;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.log4j.Logger;

public class DubboHelper {
    private static final Logger log = Logger.getLogger(DubboHelper.class);
    private static DubboHelper instance;
    private Map<String, Object> referenceServices = new HashMap<String, Object>();
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private ProtocolConfig protocolConfig;

    private DubboHelper(String registryUrl, String applicationName, String protocolName, int protocolPort, int qosPort) {
        String registryProtocol = registryUrl.split("://")[0];
        String registryAddress = registryUrl.split("://")[1];
        this.applicationConfig = new ApplicationConfig();
        this.applicationConfig.setName(applicationName);
        this.applicationConfig.setQosPort(Integer.valueOf(qosPort));
        this.registryConfig = new RegistryConfig();
        this.registryConfig.setAddress(registryAddress);
        this.registryConfig.setProtocol(registryProtocol);
        this.protocolConfig = new ProtocolConfig();
        this.protocolConfig.setName(protocolName);
        this.protocolConfig.setPort(Integer.valueOf(protocolPort));
        this.protocolConfig.setThreads(Integer.valueOf(200));
    }

    public static void registerService(Class<?> interfaceClass, Object service, String version) {
        DubboHelper.instance().toRegisterService(interfaceClass, service, version);
    }

    public void toRegisterService(Class<?> interfaceClass, Object service, String version) {
        log.warn((Object)("MingBo DubboPlugin execute registering service [name=" + interfaceClass.getSimpleName() + ", port=" + this.protocolConfig.getPort() + "]..."));
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setApplication(this.applicationConfig);
        serviceConfig.setRegistry(this.registryConfig);
        serviceConfig.setProtocol(this.protocolConfig);
        serviceConfig.setInterface(interfaceClass);
        serviceConfig.setRef(service);
        serviceConfig.setVersion(version);
        serviceConfig.export();
    }

    public static <T> T referenceService(Class<T> interfaceClass, String version) {
        Object object = DubboHelper.instance().getReferenceService(interfaceClass, version);
        return (T)object;
    }

    private Object getReferenceService(Class<?> interfaceClass, String version) {
        if (this.referenceServices.containsKey(interfaceClass.getName())) {
            return this.referenceServices.get(interfaceClass.getName());
        }
        log.warn((Object)("MingBo DubboPlugin execute referenceing service [name=" + interfaceClass.getSimpleName() + "]..."));
        ReferenceConfig reference = new ReferenceConfig();
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setInterface(interfaceClass);
        reference.setVersion(version);
        Object object = reference.get();
        this.referenceServices.put(interfaceClass.getName(), object);
        log.warn((Object)("MingBo DubboPlugin execute reference service [name=" + interfaceClass.getSimpleName() + ", memory address=" + object.toString() + "]..."));
        return object;
    }

    public static DubboHelper init(String registryUrl, String applicationName, String protocolName, int protocolPort, int qosPort) {
        if (instance == null) {
            instance = new DubboHelper(registryUrl, applicationName, protocolName, protocolPort, qosPort);
        }
        return instance;
    }

    private static DubboHelper instance() {
        if (instance == null) {
            throw new NullPointerException("you must call init before call this method.");
        }
        return instance;
    }
}

