package cn.signit.sdk.type;

/**
 * 
 * 图片类型编码枚举.
 *
 * @since 1.0.2
 */
public enum ImageCode {
    //----------------------------------------------------------------------------------------------------------个人
    //国徽面
    ID_CARD_FRONT(1000, "身份证正面"),
    //人像面
    ID_CARD_BACK(1002, "身份证背面"),
    //手持人像面
    PERSON_HANDHELD_ID_CARD_BACK(1001, "手持身份证背面"),

    HMT_CARD_FRONT(1005, "港澳正面"),
    HMT_CARD_BACK(1006, "港澳背面"),
    PERSON_HANDHELD_HMT(1007, "手持港澳台身份证背面"),

    PASSPORT(1003, "护照"),

    PERSON_HANDHELE_PASSPORT(1004, "手持护照"),
    PASSPORT_PORTRAIT_PAGE(1008, "护照人像页"),
    PASSPORT_STAMP_PAGE(1009, "护照盖章页"),

    TAIWAN_COMPATRIOTS_FRONT(1010,"台胞证正面"),
    TAIWAN_COMPATRIOTS_BACK(1011,"台胞证背面"),
    PERSON_HANDHELD_TAIWAN_COMPATRIOTS_FRONT(1012, "手持台胞证正面"),
    //----------------------------------------------------------------------------------------------------------个人

    BUSINESS_LICENCE(2000, "企业营业执照"),
    ORG_CODE(2001, "组织机构代码照"),

    AGENT_TRUST(2006, "委托书图片"),

    //----------------------------------------------------------------------------------------------------------法人
    LEGAL_PERSON_ID_CARD_FRONT(2002, "法人身份证正面"),
    LEGAL_PERSON_ID_CARD_BACK(2003, "法人身份证背面"),
    LEGAL_PERSON_HANDHELD_ID_CARD_BACK(2102, "法人手持身份证背面"),

    LEGAL_PERSON_PASSPORT_FRONT(2007, "法人护照正面"),
    LEGAL_PERSON_PASSPORT_BACK(2008, "法人护照背面"),
    LEGAL_PERSON_HANDHELD_PASSPORT_BACK(2103, "法人手持护照背面"),

    LEGAL_PERSON_TAIWAN_COMPATRIOTS_FRONT(2200, "法人台胞证正面"),
    LEGAL_PERSON_TAIWAN_COMPATRIOTS_BACK(2201, "法人台胞证背面"),
    LEGAL_PERSON_TAIWAN_COMPATRIOTS_HANDHELD(2202,"法人台胞证手持"),

    LEGAL_PERSON_HONG_KONG_AND_MACAO_PASS_FRONT(2206, "法人港澳通行证正面"),
    LEGAL_PERSON_HONG_KONG_AND_MACAO_PASS_BACK(2207, "法人港澳通行证背面"),
    LEGAL_PERSON_HONG_KONG_AND_MACAO_PASS_HANDHELD(2208,"法人港澳通行证手持"),
    //----------------------------------------------------------------------------------------------------------法人

    //----------------------------------------------------------------------------------------------------------经办人
    AGENT_ID_CARD_FRONT(2004, "经办人身份证正面"),
    AGENT_ID_CARD_BACK(2005, "经办人身份证背面"),
    AGENT_PERSON_HANDHELD_ID_CARD_BACK(2104, "经办人手持身份证背面"),

    AGENT_PERSON_PASSPORT_FRONT(2009, "经办人护照正面"),
    AGENT_PERSON_PASSPORT_BACK(2010, "经办人护照背面"),
    AGENT_PERSON_HANDHELD_PASSPORT_BACK(2105, "经办人手持护照背面"),

    AGENT_PERSON_TAIWAN_COMPATRIOTS_FRONT(2203, "经办人台胞证正面"),
    AGENT_PERSON_TAIWAN_COMPATRIOTS_BACK(2204, "经办人台胞证背面"),
    AGENT_PERSON_TAIWAN_COMPATRIOTS_HANDHELD(2205, "经办人台胞证手持"),

    AGENT_PERSON_HONG_KONG_AND_MACAO_PASS_FRONT(2209, "经办人港澳通行证正面"),
    AGENT_PERSON_HONG_KONG_AND_MACAO_PASS_BACK(2210, "经办人港澳通行证背面"),
    AGENT_PERSON_HONG_KONG_AND_MACAO_PASS_HANDHELD(2211, "经办人港澳通行证手持"),

    //----------------------------------------------------------------------------------------------------------经办人
    /**
     * 未确切定义的其他认证所需图片
     */
    EXTRA(2100, "未确切定义的其他认证所需图片"),
    /**
     * 人脸图像
     */
    FACE_ID(2101, "人脸图像"),
    /**
     * 未确切定义的其他认证所需图片
     */
    ;

    Integer code;
    String description;

    private ImageCode(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

}
