/*
 * Copyright © 2017 signit.cn. All rights reserved.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package cn.signit.sdk.type;

/**
 * 认证方式.
 * </p>
 *
 * @author pxy
 * @since 1.0.0
 */
public enum AuthMode {

    UNKNOWN(-1,"未知认证方式"),
    MANUAL(0,"手工认证方式"),
    MANUAL_AUTH(0,"开放平台实名认证-手工认证方式"),
    ZM_AUTH(1,"芝麻认证方式"),
    PHONE_AUTH(4,"三网手机号三元素实名认证方式"),
    WECHAT_AUTH(9,"微信实名认证"),
    ;
    
    private Integer code;
    private String description;
    
    
    private AuthMode(Integer code, String description) {
        this.code = code;
        this.description = description;
    }
    /**
     * 
     * 根据枚举code获取枚举类型.
     *
     * @param code  枚举整型code
     * @return  枚举具体类型
     * @author luliangwei
     * @since 1.0.0
     */
    public static AuthMode getAuthMode(Integer code){
        for(AuthMode level : values()){
            if(level.getCode() == code){
                return level;
            }
        }
        return AuthMode.UNKNOWN;
    }
    
    /**
     * 通过认证方式名获取认证方式枚举.
     *
     * @param name 认证方式名
     * @return 认证方式枚举
     * @author yaowei
     * @since 1.0.0
     */
    public static AuthMode getAuthMode(String name) {
        for (AuthMode level : values()) {
            if (level.name()
                    .equalsIgnoreCase(name)) {
                return level;
            }
        }
        return AuthMode.UNKNOWN;
    }
    
    public Integer getCode() {
        return code;
    }
    public void setCode(Integer code) {
        this.code = code;
    }
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    
    
}
