package cn.signit.sdk.pojo.request;

import cn.signit.sdk.pojo.IdCardImage;
import cn.signit.sdk.pojo.response.VerificationV2Resp;
import cn.signit.sdk.type.AcceptDataType;
import cn.signit.sdk.type.AuthMode;
import cn.signit.sdk.type.IdCardType;
import java.util.List;



public class PersonVerificationV2Request extends AbstractSignitRequest<VerificationV2Resp>{

    //待认证用户名称
    private String name;

    //证件类型
    private IdCardType idCardType;

    //证件照片信息
    private List<IdCardImage> idCardImages;

    //身份证号码
    private String idCardNo;

    //电话号码
    private String phone;

    //调用方自定义标识，易企签会原封不动返回
    private String customTag;

    //个人认证模式
    private List<AuthMode> authModes;

    //调用方自定义要求易企签的WEB平台在流程结束后需要跳转的指定URL地址
    private String returnUrl;


    //调用方接受的响应数据类型，支持：BASE64/URL
    private AcceptDataType acceptDataType = AcceptDataType.BASE64;


    //是否启用 嵌入模式
    private Boolean enableEmbeddedMode = false;


    //是否允许认证用户修改信息
    private Boolean allowModify = true;

    //调用时是否只接受rawData数据
    private Boolean onlyRawData = false;

    //通知地址
    private String notifyUrl;


    @Override
    public Class<VerificationV2Resp> getResponseClass() {
        return VerificationV2Resp.class;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IdCardType getIdCardType() {
        return idCardType;
    }

    public void setIdCardType(IdCardType idCardType) {
        this.idCardType = idCardType;
    }

    public List<IdCardImage> getIdCardImages() {
        return idCardImages;
    }

    public void setIdCardImages(List<IdCardImage> idCardImages) {
        this.idCardImages = idCardImages;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Override
    public String getCustomTag() {
        return customTag;
    }

    @Override
    public void setCustomTag(String customTag) {
        this.customTag = customTag;
    }

    public List<AuthMode> getAuthModes() {
        return authModes;
    }

    public void setAuthModes(List<AuthMode> authModes) {
        this.authModes = authModes;
    }

    @Override
    public String getReturnUrl() {
        return returnUrl;
    }

    @Override
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Override
    public AcceptDataType getAcceptDataType() {
        return acceptDataType;
    }

    @Override
    public void setAcceptDataType(AcceptDataType acceptDataType) {
        this.acceptDataType = acceptDataType;
    }

    public Boolean getEnableEmbeddedMode() {
        return enableEmbeddedMode;
    }

    public void setEnableEmbeddedMode(Boolean enableEmbeddedMode) {
        this.enableEmbeddedMode = enableEmbeddedMode;
    }

    public Boolean getAllowModify() {
        return allowModify;
    }

    public void setAllowModify(Boolean allowModify) {
        this.allowModify = allowModify;
    }

    public Boolean getOnlyRawData() {
        return onlyRawData;
    }

    public void setOnlyRawData(Boolean onlyRawData) {
        this.onlyRawData = onlyRawData;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public PersonVerificationV2Request(Builder builder){
        this.name = builder.name;
        this.idCardType = builder.idCardType;
        this.idCardImages = builder.idCardImages;
        this.idCardNo = builder.idCardNo;
        this.phone = builder.phone;
        this.customTag = builder.customTag;
        this.authModes = builder.authModes;
        this.returnUrl = builder.returnUrl;
        this.acceptDataType = builder.acceptDataType;
        this.enableEmbeddedMode = builder.enableEmbeddedMode;
        this.allowModify = builder.allowModify;
        this.onlyRawData = builder.onlyRawData;
        this.notifyUrl = builder.notifyUrl;
    }

    public Builder newBuilder(PersonVerificationV2Request personVerificationV2Request){
        return new Builder(personVerificationV2Request);
    }

    public static Builder builder(){
        return new Builder();
    }


    public static class Builder implements cn.signit.sdk.pojo.Builder<PersonVerificationV2Request>{

        //待认证用户名称
        private String name;

        //证件类型
        private IdCardType idCardType;

        //证件照片信息
        private List<IdCardImage> idCardImages;

        //身份证号码
        private String idCardNo;

        //电话号码
        private String phone;

        //调用方自定义标识，易企签会原封不动返回
        private String customTag;

        //个人认证模式
        private List<AuthMode> authModes;

        //调用方自定义要求易企签的WEB平台在流程结束后需要跳转的指定URL地址
        private String returnUrl;


        //调用方接受的响应数据类型，支持：BASE64/URL
        private AcceptDataType acceptDataType = AcceptDataType.BASE64;


        //是否启用 嵌入模式
        private Boolean enableEmbeddedMode = false;


        //是否允许认证用户修改信息
        private Boolean allowModify = true;

        //调用时是否只接受rawData数据
        private Boolean onlyRawData = false;

        //通知地址
        private String notifyUrl;

        public Builder(){}

        public Builder(PersonVerificationV2Request personVerificationV2Request){
            this.name = personVerificationV2Request.name;
            this.idCardType = personVerificationV2Request.idCardType;
            this.idCardImages = personVerificationV2Request.idCardImages;
            this.idCardNo = personVerificationV2Request.idCardNo;
            this.phone = personVerificationV2Request.phone;
            this.customTag = personVerificationV2Request.customTag;
            this.authModes = personVerificationV2Request.authModes;
            this.returnUrl = personVerificationV2Request.returnUrl;
            this.acceptDataType = personVerificationV2Request.acceptDataType;
            this.enableEmbeddedMode = personVerificationV2Request.enableEmbeddedMode;
            this.allowModify = personVerificationV2Request.allowModify;
            this.onlyRawData = personVerificationV2Request.onlyRawData;
            this.notifyUrl = personVerificationV2Request.notifyUrl;
        }

        public Builder name (String name){
            this.name = name;
            return this;
        }

        public Builder idCardType (IdCardType idCardType){
            this.idCardType = idCardType;
            return this;
        }

        public Builder idCardImages (List<IdCardImage> idCardImages){
            this.idCardImages = idCardImages;
            return this;
        }

        public Builder idCardNo (String idCardNo){
            this.idCardNo = idCardNo;
            return this;
        }

        public Builder phone (String phone){
            this.phone = phone;
            return this;
        }

        public Builder customTag (String customTag){
            this.customTag = customTag;
            return this;
        }

        public Builder authModes (List<AuthMode> authModes){
            this.authModes = authModes;
            return this;
        }

        public Builder returnUrl (String returnUrl){
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder acceptDataType (AcceptDataType acceptDataType){
            this.acceptDataType = acceptDataType;
            return this;
        }

        public Builder enableEmbeddedMode (Boolean enableEmbeddedMode){
            this.enableEmbeddedMode = enableEmbeddedMode;
            return this;
        }

        public Builder allowModify (Boolean allowModify){
            this.allowModify = allowModify;
            return this;
        }

        public Builder onlyRawData (Boolean onlyRawData){
            this.onlyRawData = onlyRawData;
            return this;
        }

        public Builder notifyUrl (String notifyUrl){
            this.notifyUrl = notifyUrl;
            return this;
        }

        public PersonVerificationV2Request build(){
            return new PersonVerificationV2Request(this);
        }
    }
}
