package cn.signit.sdk.pojo.request;

import cn.signit.sdk.pojo.IdCardImage;
import cn.signit.sdk.pojo.response.VerificationV2Resp;
import cn.signit.sdk.pojo.EnterpriseBankCardInfo;
import cn.signit.sdk.pojo.EnterprisePersonInfo;
import cn.signit.sdk.type.*;

import java.util.List;



public class EnterpriseVerificationV2Request extends AbstractSignitRequest<VerificationV2Resp>{

    //待认证企业名称
    private String name;

    //当前认证成员个人信息
    private EnterprisePersonInfo enterprisePersonInfo;

    //委托书照片信息
    private IdCardImage trustInstrumentImage;

    //统一社会信用代码
    private String unifiedSocialCode;

    //法人姓名
    private String legalPersonName;

    //法人身份证号码
    private String legalPersonIdCardNo;

    //营业执照照片信息
    private IdCardImage businessLicenceImage;

    //企业认证类型
    //LEGAL_PERSON-法人认证，AGENT-经办人认证
    private EnterpriseAuthType authType;

     //个人认证模式
    private List<AuthMode> personAuthModes;

//    //企业认证模式
//    private List<AuthMode> enterpriseAuthModes;

    //企业对公银行信息
    private EnterpriseBankCardInfo bankCardInfo;

    //额外认证所需照片信息数组
    private List<IdCardImage> extraAuthImages;

    //是否变更经变人(加入企业变为子管理员)
    private Boolean changeAgent = false;

    //调用方自定义标识，易企签会原封不动返回
    private String customTag;

    //调用方自定义要求易企签的WEB平台在流程结束后需要跳转的指定URL地址
    private String returnUrl;

    //调用方接受的响应数据类型，支持：BASE64/URL
    private AcceptDataType acceptDataType = AcceptDataType.BASE64;

    //是否启用 嵌入模式
    private Boolean enableEmbeddedMode = false;

    //是否允许认证用户修改信息
    private Boolean allowModify = true;

    //调用时是否只接受rawData数据
    private Boolean onlyRawData = false;


    //通知地址
    private String notifyUrl;

    @Override
    public Class<VerificationV2Resp> getResponseClass() {
        return VerificationV2Resp.class;
    }





    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnterprisePersonInfo getEnterprisePersonInfo() {
        return enterprisePersonInfo;
    }

    public void setEnterprisePersonInfo(EnterprisePersonInfo enterprisePersonInfo) {
        this.enterprisePersonInfo = enterprisePersonInfo;
    }

    public IdCardImage getTrustInstrumentImage() {
        return trustInstrumentImage;
    }

    public void setTrustInstrumentImage(IdCardImage trustInstrumentImage) {
        this.trustInstrumentImage = trustInstrumentImage;
    }

    public String getUnifiedSocialCode() {
        return unifiedSocialCode;
    }

    public void setUnifiedSocialCode(String unifiedSocialCode) {
        this.unifiedSocialCode = unifiedSocialCode;
    }

    public String getLegalPersonName() {
        return legalPersonName;
    }

    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    public String getLegalPersonIdCardNo() {
        return legalPersonIdCardNo;
    }

    public void setLegalPersonIdCardNo(String legalPersonIdCardNo) {
        this.legalPersonIdCardNo = legalPersonIdCardNo;
    }

    public IdCardImage getBusinessLicenceImage() {
        return businessLicenceImage;
    }

    public void setBusinessLicenceImage(IdCardImage businessLicenceImage) {
        this.businessLicenceImage = businessLicenceImage;
    }

    public EnterpriseAuthType getAuthType() {
        return authType;
    }

    public void setAuthType(EnterpriseAuthType authType) {
        this.authType = authType;
    }

    public List<AuthMode> getPersonAuthModes() {
        return personAuthModes;
    }

    public void setPersonAuthModes(List<AuthMode> personAuthModes) {
        this.personAuthModes = personAuthModes;
    }

    public EnterpriseBankCardInfo getBankCardInfo() {
        return bankCardInfo;
    }

    public void setBankCardInfo(EnterpriseBankCardInfo bankCardInfo) {
        this.bankCardInfo = bankCardInfo;
    }

    public List<IdCardImage> getExtraAuthImages() {
        return extraAuthImages;
    }

    public void setExtraAuthImages(List<IdCardImage> extraAuthImages) {
        this.extraAuthImages = extraAuthImages;
    }

    public Boolean getChangeAgent() {
        return changeAgent;
    }

    public void setChangeAgent(Boolean changeAgent) {
        this.changeAgent = changeAgent;
    }

    @Override
    public String getCustomTag() {
        return customTag;
    }

    @Override
    public void setCustomTag(String customTag) {
        this.customTag = customTag;
    }

    @Override
    public String getReturnUrl() {
        return returnUrl;
    }

    @Override
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Override
    public AcceptDataType getAcceptDataType() {
        return acceptDataType;
    }

    @Override
    public void setAcceptDataType(AcceptDataType acceptDataType) {
        this.acceptDataType = acceptDataType;
    }

    public Boolean getEnableEmbeddedMode() {
        return enableEmbeddedMode;
    }

    public void setEnableEmbeddedMode(Boolean enableEmbeddedMode) {
        this.enableEmbeddedMode = enableEmbeddedMode;
    }

    public Boolean getAllowModify() {
        return allowModify;
    }

    public void setAllowModify(Boolean allowModify) {
        this.allowModify = allowModify;
    }

    public Boolean getOnlyRawData() {
        return onlyRawData;
    }

    public void setOnlyRawData(Boolean onlyRawData) {
        this.onlyRawData = onlyRawData;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public EnterpriseVerificationV2Request(Builder builder) {
        this.name = builder.name;
        this.enterprisePersonInfo = builder.enterprisePersonInfo;
        this.trustInstrumentImage = builder.trustInstrumentImage;
        this.unifiedSocialCode = builder.unifiedSocialCode;
        this.legalPersonName = builder.legalPersonName;
        this.legalPersonIdCardNo = builder.legalPersonIdCardNo;
        this.businessLicenceImage = builder.businessLicenceImage;
        this.authType = builder.authType;
        this.personAuthModes = builder.personAuthModes;
        this.bankCardInfo = builder.bankCardInfo;
        this.extraAuthImages = builder.extraAuthImages;
        this.changeAgent = builder.changeAgent;
        this.customTag = builder.customTag;
        this.returnUrl = builder.returnUrl;
        this.acceptDataType = builder.acceptDataType;
        this.enableEmbeddedMode = builder.enableEmbeddedMode;
        this.allowModify = builder.allowModify;
        this.onlyRawData = builder.onlyRawData;
        this.notifyUrl = builder.notifyUrl;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    /**
     * 企业实名认证请求对象建筑器
     *
     * @since 2.0.0
     */
    public static class Builder implements cn.signit.sdk.pojo.Builder<EnterpriseVerificationV2Request> {
        //待认证企业名称
        private String name;

        //当前认证成员个人信息
        private EnterprisePersonInfo enterprisePersonInfo;

        //委托书照片信息
        private IdCardImage trustInstrumentImage;

        //统一社会信用代码
        private String unifiedSocialCode;

        //法人姓名
        private String legalPersonName;

        //法人身份证号码
        private String legalPersonIdCardNo;

        //营业执照照片信息
        private IdCardImage businessLicenceImage;

        //企业认证类型
        //LEGAL_PERSON-法人认证，AGENT-经办人认证
        private EnterpriseAuthType authType;

        //个人认证模式
        private List<AuthMode> personAuthModes;

//    //企业认证模式
//    private List<AuthMode> enterpriseAuthModes;

        //企业对公银行信息
        private EnterpriseBankCardInfo bankCardInfo;

        //额外认证所需照片信息数组
        private List<IdCardImage> extraAuthImages;

        //是否变更经变人(加入企业变为子管理员)
        private Boolean changeAgent = false;

        //调用方自定义标识，易企签会原封不动返回
        private String customTag;

        //调用方自定义要求易企签的WEB平台在流程结束后需要跳转的指定URL地址
        private String returnUrl;

        //调用方接受的响应数据类型，支持：BASE64/URL
        private AcceptDataType acceptDataType = AcceptDataType.BASE64;

        //是否启用 嵌入模式
        private Boolean enableEmbeddedMode = false;

        //是否允许认证用户修改信息
        private Boolean allowModify = true;

        //调用时是否只接受rawData数据
        private Boolean onlyRawData = false;

        //通知地址
        private String notifyUrl;

        public Builder() {

        }

        public Builder(EnterpriseVerificationV2Request enterpriseVerificationV2Request) {
            this.name = enterpriseVerificationV2Request.name;
            this.enterprisePersonInfo = enterpriseVerificationV2Request.enterprisePersonInfo;
            this.trustInstrumentImage = enterpriseVerificationV2Request.trustInstrumentImage;
            this.unifiedSocialCode = enterpriseVerificationV2Request.unifiedSocialCode;
            this.legalPersonName = enterpriseVerificationV2Request.legalPersonName;
            this.legalPersonIdCardNo = enterpriseVerificationV2Request.legalPersonIdCardNo;
            this.businessLicenceImage = enterpriseVerificationV2Request.businessLicenceImage;
            this.authType = enterpriseVerificationV2Request.authType;
            this.personAuthModes = enterpriseVerificationV2Request.personAuthModes;
            this.bankCardInfo = enterpriseVerificationV2Request.bankCardInfo;
            this.extraAuthImages = enterpriseVerificationV2Request.extraAuthImages;
            this.changeAgent = enterpriseVerificationV2Request.changeAgent;
            this.customTag = enterpriseVerificationV2Request.customTag;
            this.returnUrl = enterpriseVerificationV2Request.returnUrl;
            this.acceptDataType = enterpriseVerificationV2Request.acceptDataType;
            this.enableEmbeddedMode = enterpriseVerificationV2Request.enableEmbeddedMode;
            this.allowModify = enterpriseVerificationV2Request.allowModify;
            this.onlyRawData = enterpriseVerificationV2Request.onlyRawData;
            this.notifyUrl = enterpriseVerificationV2Request.notifyUrl;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder enterprisePersonInfo(EnterprisePersonInfo enterprisePersonInfo) {
            this.enterprisePersonInfo = enterprisePersonInfo;
            return this;
        }

        public Builder trustInstrumentImage(IdCardImage trustInstrumentImage) {
            this.trustInstrumentImage = trustInstrumentImage;
            return this;
        }

        public Builder unifiedSocialCode(String unifiedSocialCode) {
            this.unifiedSocialCode = unifiedSocialCode;
            return this;
        }

        public Builder legalPersonName(String legalPersonName) {
            this.legalPersonName = legalPersonName;
            return this;
        }

        public Builder legalPersonIdCardNo(String legalPersonIdCardNo) {
            this.legalPersonIdCardNo = legalPersonIdCardNo;
            return this;
        }

        public Builder businessLicenceImage(IdCardImage businessLicenceImage) {
            this.businessLicenceImage = businessLicenceImage;
            return this;
        }

        public Builder authType(EnterpriseAuthType authType) {
            this.authType = authType;
            return this;
        }

        public Builder personAuthModes(List<AuthMode> personAuthModes) {
            this.personAuthModes = personAuthModes;
            return this;
        }


        public Builder bankCardInfo(EnterpriseBankCardInfo bankCardInfo) {
            this.bankCardInfo = bankCardInfo;
            return this;
        }

        public Builder extraAuthImages(List<IdCardImage> extraAuthImages) {
            this.extraAuthImages = extraAuthImages;
            return this;
        }

        public Builder changeAgent(Boolean changeAgent) {
            this.changeAgent = changeAgent;
            return this;
        }

        public Builder customTag(String customTag) {
            this.customTag = customTag;
            return this;
        }

        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder acceptDataType(AcceptDataType acceptDataType) {
            this.acceptDataType = acceptDataType;
            return this;
        }

        public Builder enableEmbeddedMode(Boolean enableEmbeddedMode) {
            this.enableEmbeddedMode = enableEmbeddedMode;
            return this;
        }

        public Builder allowModify(Boolean allowModify) {
            this.allowModify = allowModify;
            return this;
        }

        public Builder onlyRawData(Boolean onlyRawData) {
            this.onlyRawData = onlyRawData;
            return this;
        }

        public Builder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public EnterpriseVerificationV2Request build() {
            return new EnterpriseVerificationV2Request(this);
        }

    }


}
