package cn.signit.sdk.pojo;

import cn.signit.sdk.type.IdCardType;
import java.util.List;

public class EnterprisePersonInfo {

    //待认证的个人姓名
    private String name;

    //待认证的个人手机号.
    private String phone;

    //待认证的个人证件类型
    private IdCardType idCardType = IdCardType.SECOND_GENERATION_IDCARD;

    //待认证的个人证件号
    private String idCardNo;

    //待认证的个人证件照片数组
    private List<IdCardImage> idCardImages;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public IdCardType getIdCardType() {
        return idCardType;
    }

    public void setIdCardType(IdCardType idCardType) {
        this.idCardType = idCardType;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public List<IdCardImage> getIdCardImages() {
        return idCardImages;
    }

    public void setIdCardImages(List<IdCardImage> idCardImages) {
        this.idCardImages = idCardImages;
    }

    public EnterprisePersonInfo(Builder builder) {
        this.name = builder.name;
        this.phone = builder.phone;
        this.idCardType = builder.idCardType;
        this.idCardNo = builder.idCardNo;
        this.idCardImages = builder.idCardImages;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder implements cn.signit.sdk.pojo.Builder<EnterprisePersonInfo>{

        //待认证的个人姓名
        private String name;

        //待认证的个人手机号.
        private String phone;

        //待认证的个人证件类型
        private IdCardType idCardType = IdCardType.SECOND_GENERATION_IDCARD;

        //待认证的个人证件号
        private String idCardNo;

        //待认证的个人证件照片数组
        private List<IdCardImage> idCardImages;
        public  Builder(){}

        public Builder(EnterprisePersonInfo enterprisePersonInfo){
            this.name = enterprisePersonInfo.name;
            this.phone = enterprisePersonInfo.phone;
            this.idCardType = enterprisePersonInfo.idCardType;
            this.idCardNo = enterprisePersonInfo.idCardNo;
            this.idCardImages = enterprisePersonInfo.idCardImages;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public Builder idCardType(IdCardType idCardType) {
            this.idCardType = idCardType;
            return this;
        }

        public Builder idCardNo(String idCardNo) {
            this.idCardNo = idCardNo;
            return this;
        }

        public Builder idCardImages(List<IdCardImage> idCardImages) {
            this.idCardImages = idCardImages;
            return this;
        }

        public EnterprisePersonInfo build(){
            return new EnterprisePersonInfo(this);
        }
    }
}
