/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.type;

public enum WebhookEventType {
    UNKNOWN("unSupportEvent", "\u4e0d\u652f\u6301\u7684\u4e8b\u4ef6"),
    QUICK_SIGN_COMPLETED("quickSignCompleted", "\u5feb\u6377\u7b7e\u7f72\u5b8c\u6210"),
    COUNTERSIGNATURE_SIGN_COMPLETED("countersignatureSignCompleted", "\u4f1a\u7b7e\u7b7e\u7f72\u5b8c\u6210"),
    PERSON_VERIFICATION_SUBMITTED("personVerificationSubmitted", "\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u63d0\u4ea4"),
    PERSON_VERIFICATION_COMPLETED("personVerificationCompleted", "\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u5b8c\u6210"),
    ENTERPRISE_VERIFICATION_SUBMITTED("enterpriseVerificationSubmitted", "\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u63d0\u4ea4"),
    ENTERPRISE_VERIFICATION_PRIMARY_COMPLETED("enterpriseVerificationPrimaryCompleted", " \u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u521d\u7ea7\u5b8c\u6210"),
    ENTERPRISE_VERIFICATION_PAID("enterpriseVerificationPaid", "\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5df2\u6253\u6b3e"),
    ENTERPRISE_VERIFICATION_COMPLETED("enterpriseVerificationCompleted", "\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5b8c\u6210"),
    ENVELOPE_STARTED("envelopeStarted", "\u4fe1\u5c01\u6d41\u7a0b\u542f\u52a8"),
    ENVELOPE_STARTED_SUCCEED("envelopeStartedSucceed", "\u4fe1\u5c01\u542f\u52a8\u6210\u529f\u4e8b\u4ef6"),
    ENVELOPE_STARTED_FAILED("envelopeStartedFailed", "\u4fe1\u5c01\u542f\u52a8\u5931\u8d25\u4e8b\u4ef6"),
    PARTICIPANT_REJECTED("participantRejected", "\u53c2\u4e0e\u8005\u62d2\u7edd"),
    PARTICIPANT_REVOKED("participantRevoked", "\u53c2\u4e0e\u8005\u64a4\u9500"),
    PARTICIPANT_CONFIRMED("participantConfirmed", "\u53c2\u4e0e\u8005\u786e\u8ba4"),
    PARTICIPANT_INVALIDATED("participantInvalidated", "\u53c2\u4e0e\u8005\u4f5c\u5e9f"),
    PARTICIPANT_NOT_PASS_CHECKED("participantNotPassChecked", "\u53c2\u4e0e\u8005\u5ba1\u6838\u4e0d\u901a\u8fc7"),
    PARTICIPANT_HANDLING("participantHandling", "\u53c2\u4e0e\u8005\u5904\u7406\u4fe1\u5c01"),
    PARTICIPANT_EXPIRED("participantExpired", "\u53c2\u4e0e\u8005\u903e\u671f\u672a\u7b7e\u7f72\u4fe1\u5c01"),
    ENVELOPE_COMPLETED("envelopeCompleted", "\u4fe1\u5c01\u6d41\u7a0b\u5b8c\u6210"),
    ENVELOPE_COMPLETED_SUCCEED("envelopeCompletedSucceed", "\u4fe1\u5c01\u6210\u529f\u6d41\u7a0b\u7ed3\u675f"),
    ENVELOPE_COMPLETED_INVALIDATED("envelopeCompletedInvalidated", "\u4fe1\u5c01\u4f5c\u5e9f\u6d41\u7a0b\u7ed3\u675f"),
    ENVELOPE_COMPLETED_REJECTED("envelopeCompletedRejected", "\u4fe1\u5c01\u62d2\u7b7e\u6d41\u7a0b\u7ed3\u675f"),
    ENVELOPE_COMPLETED_NOT_PASS_CHECKED("envelopeCompletedNotPassChecked", "\u4fe1\u5c01\u5ba1\u6838\u672a\u901a\u8fc7\u6d41\u7a0b\u7ed3\u675f"),
    ENVELOPE_COMPLETED_REVOKED("envelopeCompletedRevoked", "\u4fe1\u5c01\u64a4\u9500\u6d41\u7a0b\u7ed3\u675f"),
    ENVELOPE_COMPLETED_EXPIRED("envelopeCompletedExpired", "\u4fe1\u5c01\u903e\u671f\u6d41\u7a0b\u7ed3\u675f"),
    FACE_INPUT_VERIFICATION_COMPLETED("faceInputVerificationCompleted", "\u8eab\u4efd\u9a8c\u8bc1-\u4eba\u8138\u9a8c\u8bc1-\u5f55\u5165\u6d41\u7a0b\u5b8c\u6210"),
    FACE_VERIFY_VERIFICATION_COMPLETED("faceVerifyVerificationCompleted", "\u8eab\u4efd\u9a8c\u8bc1-\u4eba\u8138\u9a8c\u8bc1-\u9a8c\u8bc1\u6d41\u7a0b\u5b8c\u6210"),
    USBKEY_INPUT_VERIFICATION_COMPLETED("usbkeyInputVerificationCompleted", "\u8eab\u4efd\u9a8c\u8bc1-USBKEY\u9a8c\u8bc1-\u5f55\u5165\u6d41\u7a0b\u5b8c\u6210"),
    USBKEY_VERIFY_VERIFICATION_COMPLETED("usbkeyVerifyVerificationCompleted", "\u8eab\u4efd\u9a8c\u8bc1-USBKEY\u9a8c\u8bc1-\u9a8c\u8bc1\u6d41\u7a0b\u5b8c\u6210"),
    ENTERPRISE_ACCOUNT_ACTIVATE_STARTED("enterpriseAccountActivateStarted", "\u4f01\u4e1a\u8d26\u6237\u540c\u6b65-\u6fc0\u6d3b\u542f\u52a8"),
    ENTERPRISE_ACCOUNT_ACTIVATE_COMPLETED("enterpriseAccountActivateCompleted", "\u4f01\u4e1a\u8d26\u6237\u540c\u6b65-\u6fc0\u6d3b\u5b8c\u6210"),
    ENTERPRISE_ACCOUNT_AUTHENTICATION_WAITING("enterpriseAccountAuthenticationWaiting", "\u4f01\u4e1a\u8d26\u6237\u540c\u6b65-\u8ba4\u8bc1\u7b49\u5f85\u5ba1\u6838"),
    ENTERPRISE_ACCOUNT_AUTHENTICATION_COMPLETED("enterpriseAccountAuthenticationCompleted", "\u4f01\u4e1a\u8d26\u6237\u540c\u6b65-\u8ba4\u8bc1\u5b8c\u6210"),
    PERSON_ACCOUNT_ACTIVATE_COMPLETED("personAccountActivateCompleted", "\u4e2a\u4eba\u8d26\u6237\u540c\u6b65-\u6fc0\u6d3b\u5b8c\u6210"),
    PERSON_ACCOUNT_ACTIVATE_STARTED("personAccountActivateStarted", "\u4e2a\u4eba\u8d26\u6237\u540c\u6b65-\u6fc0\u6d3b\u5f00\u59cb"),
    PERSON_ACCOUNT_AUTHENTICATION_COMPLETED("personAccountAuthenticationCompleted", "\u4e2a\u4eba\u8d26\u6237\u540c\u6b65-\u8ba4\u8bc1\u5b8c\u6210"),
    PERSON_AUTHENTICATION_COMPLETED("personAuthenticationCompleted", "\u4e2a\u4eba\u8d26\u6237\u540c\u6b65-\u8ba4\u8bc1\u5b8c\u6210"),
    OPEN_ENTERPRISE_AUTHENTICATION_SUCCESS("openEnterpriseAuthenticationSuccess", "\u5f00\u653e\u5e73\u53f0\u72ec\u7acb\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u6d41\u7a0b\u8ba4\u8bc1\u6210\u529f"),
    OPEN_ENTERPRISE_AUTHENTICATION_DENY("openEnterpriseAuthenticationDeny", "\u5f00\u653e\u5e73\u53f0\u72ec\u7acb\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u6d41\u7a0b\u8ba4\u8bc1\u5931\u8d25"),
    OPEN_ENTERPRISE_AUTHENTICATION_CHANGE("openEnterpriseAuthenticationChange", "\u5f00\u653e\u5e73\u53f0\u72ec\u7acb\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u6d41\u7a0b\u8ba4\u8bc1\u6539\u53d8");

    private String event;
    private String description;

    private WebhookEventType(String event, String description) {
        this.event = event;
        this.description = description;
    }

    public static WebhookEventType parse(String event) {
        for (WebhookEventType val : WebhookEventType.values()) {
            if (!val.name().equalsIgnoreCase(event) && !val.getEvent().equalsIgnoreCase(event)) continue;
            return val;
        }
        return UNKNOWN;
    }

    public static boolean support(String[] events) {
        if (events == null || events.length == 0) {
            return false;
        }
        for (String val : events) {
            if (WebhookEventType.support(val)) continue;
            return false;
        }
        return true;
    }

    public static boolean support(String event) {
        return WebhookEventType.parse(event) != UNKNOWN;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

