/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.http;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.http.AbstractHttpRequest;
import cn.signit.sdk.http.Authentication;
import cn.signit.sdk.util.FastjsonEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpPutRequest
extends AbstractHttpRequest {
    private Map<String, String> parameters = null;
    private static SSLContext ctx = null;
    private static HostnameVerifier verifier = null;
    private static SSLSocketFactory socketFactory = null;
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    protected String method = "PUT";
    private HttpURLConnection httpConn;
    private OutputStream outputStream;
    private PrintWriter writer;
    private Map<String, Serializable> fields = null;
    private Object object = null;

    public HttpPutRequest(String url) throws SignitException {
        this(url, null, null, null);
    }

    public HttpPutRequest(String url, Authentication auth) throws SignitException {
        this(url, null, auth, null);
    }

    public HttpPutRequest(String url, Map<String, Serializable> fields) throws SignitException {
        this(url, fields, null, null);
    }

    public HttpPutRequest(String url, Map<String, Serializable> fields, Map<String, String> parameters) throws SignitException {
        this(url, fields, null, parameters);
    }

    public HttpPutRequest(String url, Map<String, Serializable> fields, Authentication auth, Map<String, String> parameters) throws SignitException {
        if (url == null || "".equals(url)) {
            throw new SignitException("URL cannot be null or empty");
        }
        this.url = url;
        if (fields != null) {
            this.fields = fields;
        }
        if (auth != null) {
            this.auth = new Authentication(auth);
        }
        if (parameters != null) {
            this.parameters = parameters;
        }
        this.boundary = "===" + Long.toHexString(System.currentTimeMillis()) + "===";
    }

    public HttpPutRequest(String url, Object object, Authentication auth, Map<String, String> parameters) throws SignitException {
        if (url == null || "".equals(url)) {
            throw new SignitException("URL cannot be null or empty");
        }
        this.url = url;
        if (object != null) {
            this.object = object;
        }
        if (auth != null) {
            this.auth = new Authentication(auth);
        }
        if (parameters != null) {
            this.parameters = parameters;
        }
        this.boundary = "===" + Long.toHexString(System.currentTimeMillis()) + "===";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpURLConnection getConnection() throws SignitException, IOException {
        if (this.parameters != null) {
            this.url = this.url.contains("?") ? this.url + "&" : this.url + "?";
            Iterator<String> keys = this.parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                try {
                    this.url = this.url + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(this.parameters.get(key), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new SignitException(ex);
                }
                if (!keys.hasNext()) continue;
                this.url = this.url + "&";
            }
        }
        HttpURLConnection conn = null;
        URL url = new URL(this.url);
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(socketFactory);
            connHttps.setHostnameVerifier(verifier);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod("PUT");
        conn.setDoOutput(true);
        conn.setRequestProperty("user-agent", "Signit HTTP");
        conn.setRequestProperty("accept-encoding", "UTF-8");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("X-Signit-App-Id", this.auth.getAppId());
        try {
            OutputStream output = conn.getOutputStream();
            try {
                output.write(FastjsonEncoder.encodeAsString(this.object).getBytes("UTF-8"));
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SignitException(ex.getMessage());
        }
        return conn;
    }

    private HttpURLConnection postWithFile() throws SignitException {
        try {
            this.openMultipartPostConnection();
            if (this.fields != null) {
                for (String key : this.fields.keySet()) {
                    Serializable val = this.fields.get(key);
                    if (val instanceof File) {
                        this.addFilePart(key, (File)val);
                        continue;
                    }
                    this.addFormField(key, val.toString());
                }
            }
            return this.finish();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SignitException(ex.getMessage());
        }
    }

    private void openMultipartPostConnection() throws IOException {
        this.httpConn = null;
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setRequestProperty("User-Agent", "Signit HTTP");
        if (this.auth != null) {
            // empty if block
        }
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, "UTF-8"), true);
    }

    private void addFormField(String name, String value) {
        this.write("--" + this.boundary).write(LINE_FEED);
        this.write("Content-Disposition: form-data; name=\"" + name + "\"").write(LINE_FEED);
        this.write("Content-Type: text/plain; charset=UTF-8").write(LINE_FEED);
        this.write(LINE_FEED);
        this.write(value).append(LINE_FEED);
        this.writer.flush();
    }

    private void addFilePart(String fieldName, File uploadFile) throws IOException {
        String fileName = uploadFile.getName();
        this.write("--" + this.boundary).write(LINE_FEED);
        this.write("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").write(LINE_FEED);
        this.write("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).write(LINE_FEED);
        this.write("Content-Transfer-Encoding: binary").write(LINE_FEED);
        this.write(LINE_FEED);
        this.writer.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        inputStream.close();
        this.write(LINE_FEED);
        this.writer.flush();
    }

    private HttpURLConnection finish() throws IOException {
        this.writer.flush();
        this.write("--" + this.boundary + "--").write(LINE_FEED);
        this.writer.close();
        return this.httpConn;
    }

    private PrintWriter write(String str) {
        return this.writer.append(str);
    }

    static {
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            ctx.getClientSessionContext().setSessionTimeout(15);
            ctx.getClientSessionContext().setSessionCacheSize(1000);
            socketFactory = ctx.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

