/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.http;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.http.Authentication;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractHttpRequest {
    protected String url;
    protected static int READ_TIMEOUT = 20000;
    protected static int CONNECT_TIMEOUT = 10000;
    public static final String USER_AGENT = "Signit HTTP";
    protected Integer lastHttpStatusCode;
    protected InputStream lastResponseStream;
    protected Authentication auth;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final TrustManager[] TRUST_ALL_CERTS = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public void doRequest() throws SignitException {
        HttpURLConnection connection;
        try {
            connection = this.getConnection();
            connection.setConnectTimeout(CONNECT_TIMEOUT);
            connection.setReadTimeout(READ_TIMEOUT);
            if (this.url.startsWith("https")) {
                HttpsURLConnection https = (HttpsURLConnection)connection;
                AbstractHttpRequest.trustAllHosts(https);
                https.setHostnameVerifier(DO_NOT_VERIFY);
            }
        }
        catch (MalformedURLException e) {
            throw new SignitException(e);
        }
        catch (IOException e) {
            throw new SignitException(e);
        }
        try {
            this.lastHttpStatusCode = connection.getResponseCode();
            this.lastResponseStream = this.lastHttpStatusCode >= 200 && this.lastHttpStatusCode < 300 ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (Exception ex) {
            throw new SignitException(ex);
        }
    }

    public Integer getResponseCode() {
        return this.lastHttpStatusCode;
    }

    public String getResponseBody() {
        String responseStr = "";
        if (this.lastResponseStream != null) {
            Scanner s = new Scanner(this.lastResponseStream);
            s.useDelimiter("\\A");
            responseStr = s.hasNext() ? s.next() : "";
            s.close();
        }
        return responseStr;
    }

    abstract HttpURLConnection getConnection() throws SignitException, IOException;

    private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, TRUST_ALL_CERTS, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oldFactory;
    }
}

