/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.util;

import cn.signit.sdk.type.NamingStyle;
import java.util.regex.Pattern;

public final class Case {
    private static final char SEPARATOR_UNDER_LINE = '_';
    private static final char SEPARATOR_HYPHEN_LINE = '-';

    private Case() {
    }

    public static String toUnderline(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return str;
        }
        if (str.indexOf(95) >= 0) {
            return str.toLowerCase();
        }
        if (str.indexOf(45) >= 0) {
            return str.replace('-', '_').toLowerCase();
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean nextUpperCase = true;
            if (i < str.length() - 1) {
                nextUpperCase = Character.isUpperCase(str.charAt(i + 1));
            }
            if (i >= 0 && Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toUnix(String str) {
        return Case.toUnderline(str);
    }

    public static String toSnake(String str) {
        return Case.toUnderline(str);
    }

    public static String toLowerCamel(String str) {
        String s = str;
        if (s == null) {
            return null;
        }
        if (str.isEmpty()) {
            return str;
        }
        if (s.indexOf(95) < 0 && s.indexOf(45) < 0) {
            if (Character.isLowerCase(s.charAt(0))) {
                return s;
            }
            if (Pattern.matches("^[A-Z]{2,}", s)) {
                s = s.toLowerCase();
            }
            return s.substring(0, 1).toLowerCase() + s.substring(1);
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' || c == '-') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamel(String str) {
        String s = str;
        if (s == null) {
            return null;
        }
        if (str.isEmpty()) {
            return str;
        }
        if (s.indexOf(95) < 0 && s.indexOf(45) < 0) {
            if (Character.isUpperCase(s.charAt(0))) {
                return s;
            }
            return s.substring(0, 1).toUpperCase() + s.substring(1);
        }
        s = Case.toLowerCamel(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String toUpperCamel(String str) {
        return Case.toCapitalizeCamel(str);
    }

    public static String toPascal(String str) {
        return Case.toCapitalizeCamel(str);
    }

    public static String toKebab(String str) {
        return Case.toHyphenLine(str);
    }

    public static String toHyphenLine(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return str;
        }
        if (str.indexOf(45) >= 0) {
            return str.toLowerCase();
        }
        if (str.indexOf(95) >= 0) {
            return str.replace('_', '-').toLowerCase();
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean nextUpperCase = true;
            if (i < str.length() - 1) {
                nextUpperCase = Character.isUpperCase(str.charAt(i + 1));
            }
            if (i >= 0 && Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append('-');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String to(String str, NamingStyle namingStyle) {
        String formatStr;
        NamingStyle ns = namingStyle;
        if (str == null) {
            return null;
        }
        if (ns == null) {
            ns = NamingStyle.CAMEL;
        }
        switch (ns) {
            case CAMEL: {
                formatStr = Case.toLowerCamel(str);
                break;
            }
            case SNAKE: {
                formatStr = Case.toSnake(str);
                break;
            }
            case PASCAL: {
                formatStr = Case.toPascal(str);
                break;
            }
            case KEBAB: {
                formatStr = Case.toKebab(str);
                break;
            }
            default: {
                formatStr = Case.toLowerCamel(str);
            }
        }
        return formatStr;
    }
}

