/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.util;

import cn.signit.sdk.util.Validator;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class HmacSignatureBuilder {
    public static final String DEFAULT_ALGORITHM = "HmacSHA512";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final byte DEFAULT_DELIMITER = 10;
    private byte delimiter = (byte)10;
    private String charset = "UTF-8";
    private String algorithm = "HmacSHA512";
    private String scheme;
    private String host;
    private String method;
    private String resource;
    private String nonce;
    private String apiKey;
    private byte[] apiSecret;
    private byte[] payload;
    private String date;
    private String contentType;

    public HmacSignatureBuilder() {
    }

    public HmacSignatureBuilder(String algorithm, String charset, byte delimiter) {
        this(algorithm, charset, delimiter, null, null);
    }

    public HmacSignatureBuilder(String algorithm, String charset, byte delimiter, String apiKey, byte[] apiSecret) {
        this.algorithm = algorithm;
        this.charset = charset;
        this.delimiter = delimiter;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public String getDefaultAlgorithm() {
        return DEFAULT_ALGORITHM;
    }

    public String getDefaultCharset() {
        return DEFAULT_CHARSET;
    }

    public byte getDefaultDelimiter() {
        return 10;
    }

    public HmacSignatureBuilder charset(String charset) {
        this.charset = charset;
        return this;
    }

    public HmacSignatureBuilder delimiter(byte delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public HmacSignatureBuilder algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public HmacSignatureBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HmacSignatureBuilder host(String host) {
        this.host = host;
        return this;
    }

    public HmacSignatureBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public HmacSignatureBuilder method(String method) {
        this.method = method;
        return this;
    }

    public HmacSignatureBuilder resource(String resource) {
        this.resource = resource;
        return this;
    }

    public HmacSignatureBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public HmacSignatureBuilder date(String date) {
        this.date = date;
        return this;
    }

    public HmacSignatureBuilder nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public HmacSignatureBuilder apiSecret(byte[] apiSecret) {
        this.apiSecret = apiSecret;
        return this;
    }

    public HmacSignatureBuilder payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public byte[] build() {
        return this.build(BuilderMode.FULL);
    }

    public byte[] build(BuilderMode builderMode) {
        try {
            Mac digest = Mac.getInstance(Validator.notNull(this.algorithm, "algorithm not null"));
            SecretKeySpec secretKey = new SecretKeySpec(this.apiSecret, this.algorithm);
            digest.init(secretKey);
            switch (builderMode) {
                case FULL: {
                    this.updateFullBuildDigest(digest);
                    break;
                }
                case ONLY_HEADER: {
                    this.updateOnlyHeaderBuildDigest(digest);
                    break;
                }
                default: {
                    System.err.println(String.format("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b: {}", new Object[]{builderMode}));
                    return null;
                }
            }
            byte[] signatureBytes = digest.doFinal();
            digest.reset();
            return signatureBytes;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    private void updateFullBuildDigest(Mac digest) throws IllegalStateException, UnsupportedEncodingException {
        digest.update(Validator.notNull(this.apiKey, "apiKey not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.contentType, "contentType not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.date, "date not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.host, "host not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.method, "method not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.nonce, "nonce not null").getBytes(this.charset));
        if (!Validator.isEmpty(this.payload)) {
            digest.update(this.delimiter);
            digest.update(Validator.notEmpty(this.payload, (Object)"payload not empty"));
        }
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.resource, "resource not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.scheme, "scheme not null").getBytes(this.charset));
        digest.update(this.delimiter);
    }

    private void updateOnlyHeaderBuildDigest(Mac digest) throws IllegalStateException, UnsupportedEncodingException {
        digest.update(Validator.notNull(this.apiKey, "apiKey not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.contentType, "contentType not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.date, "date not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.host, "host not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.method, "method not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.nonce, "nonce not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.resource, "resource not null").getBytes(this.charset));
        digest.update(this.delimiter);
        digest.update(Validator.notNull(this.scheme, "scheme not null").getBytes(this.charset));
        digest.update(this.delimiter);
    }

    public String buildAsHex() {
        return this.buildAsHex(BuilderMode.FULL);
    }

    public String buildAsHex(BuilderMode builderMode) {
        byte[] ret = this.build(builderMode);
        if (Validator.isEmpty(ret)) {
            return null;
        }
        return DatatypeConverter.printHexBinary((byte[])ret);
    }

    public String buildAsBase64() {
        return this.buildAsBase64(BuilderMode.FULL);
    }

    public String buildAsBase64(BuilderMode builderMode) {
        byte[] ret = this.build(builderMode);
        if (Validator.isEmpty(ret)) {
            return null;
        }
        return DatatypeConverter.printBase64Binary((byte[])ret);
    }

    public void assertAuthSuccess(byte[] expectedSignature) {
        this.assertAuthSuccess(expectedSignature, BuilderMode.FULL, null);
    }

    public void assertAuthSuccess(byte[] expectedSignature, String errorMessage) {
        this.assertAuthSuccess(expectedSignature, BuilderMode.FULL, errorMessage);
    }

    public void assertAuthSuccess(byte[] expectedSignature, BuilderMode builderMode) {
        this.assertAuthSuccess(expectedSignature, BuilderMode.FULL, null);
    }

    public void assertAuthSuccess(byte[] expectedSignature, BuilderMode builderMode, String errorMessage) {
        if (!this.isHashEquals(expectedSignature, builderMode)) {
            if (Validator.isEmpty(errorMessage)) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public void assertAuthFail(byte[] expectedSignature) {
        this.assertAuthFail(expectedSignature, BuilderMode.FULL, null);
    }

    public void assertAuthFail(byte[] expectedSignature, String errorMessage) {
        this.assertAuthFail(expectedSignature, BuilderMode.FULL, errorMessage);
    }

    public void assertAuthFail(byte[] expectedSignature, BuilderMode builderMode) {
        this.assertAuthFail(expectedSignature, BuilderMode.FULL, null);
    }

    public void assertAuthFail(byte[] expectedSignature, BuilderMode builderMode, String errorMessage) {
        if (this.isHashEquals(expectedSignature, builderMode)) {
            if (Validator.isEmpty(errorMessage)) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public boolean isHashEquals(byte[] expectedSignature) {
        return this.isHashEquals(expectedSignature, BuilderMode.FULL);
    }

    public boolean isHashEquals(byte[] expectedSignature, BuilderMode builderMode) {
        byte[] signature = this.build(builderMode);
        return MessageDigest.isEqual(signature, expectedSignature);
    }

    public boolean isHashEqualsWithHex(String expectedSignatureHex) {
        return this.isHashEqualsWithHex(expectedSignatureHex, BuilderMode.FULL);
    }

    public boolean isHashEqualsWithHex(String expectedSignatureHex, BuilderMode builderMode) {
        try {
            byte[] signature = this.build(builderMode);
            return MessageDigest.isEqual(signature, DatatypeConverter.parseHexBinary((String)expectedSignatureHex));
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    public boolean isHashEqualsWithBase64(String expectedSignatureBase64) {
        return this.isHashEqualsWithBase64(expectedSignatureBase64, BuilderMode.FULL);
    }

    public boolean isHashEqualsWithBase64(String expectedSignatureBase64, BuilderMode builderMode) {
        try {
            byte[] signature = this.build(builderMode);
            return MessageDigest.isEqual(signature, DatatypeConverter.parseBase64Binary((String)expectedSignatureBase64));
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    public static enum BuilderMode {
        FULL,
        ONLY_HEADER;

    }
}

