/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.pojo;

import cn.signit.sdk.pojo.SealData;
import cn.signit.sdk.type.Direction;

public class Signer {
    private int sequence = 1;
    private Position position;
    private Data data;
    private SignerInfo signerInfo;

    public static SignerBuilder builder() {
        return new SignerBuilder();
    }

    public Signer() {
    }

    public Signer(int sequence, Position position, Data data, SignerInfo signerInfo) {
        this.sequence = sequence;
        this.position = position;
        this.data = data;
        this.signerInfo = signerInfo;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public SignerInfo getSignerInfo() {
        return this.signerInfo;
    }

    public void setSignerInfo(SignerInfo signerInfo) {
        this.signerInfo = signerInfo;
    }

    public static class SignerInfo {
        private String name;
        private String orgnizationName;
        private String idCardNo;
        private String location;
        private String contact;
        private String reason;

        public static SignerInfoBuilder builder() {
            return new SignerInfoBuilder();
        }

        public SignerInfo() {
        }

        public SignerInfo(String name, String orgnizationName, String idCardNo, String location, String contact, String reason) {
            this.name = name;
            this.orgnizationName = orgnizationName;
            this.idCardNo = idCardNo;
            this.location = location;
            this.contact = contact;
            this.reason = reason;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getOrgnizationName() {
            return this.orgnizationName;
        }

        public void setOrgnizationName(String orgnizationName) {
            this.orgnizationName = orgnizationName;
        }

        public String getIdCardNo() {
            return this.idCardNo;
        }

        public void setIdCardNo(String idCardNo) {
            this.idCardNo = idCardNo;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String getContact() {
            return this.contact;
        }

        public void setContact(String contact) {
            this.contact = contact;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public static class SignerInfoBuilder {
            private String name;
            private String orgnizationName;
            private String idCardNo;
            private String location;
            private String contact;
            private String reason;

            public SignerInfoBuilder withName(String name) {
                this.name = name;
                return this;
            }

            public SignerInfoBuilder withOrgnizationName(String orgnizationName) {
                this.orgnizationName = orgnizationName;
                return this;
            }

            public SignerInfoBuilder withIdCardNo(String idCardNo) {
                this.idCardNo = idCardNo;
                return this;
            }

            public SignerInfoBuilder withLocation(String location) {
                this.location = location;
                return this;
            }

            public SignerInfoBuilder withContact(String contact) {
                this.contact = contact;
                return this;
            }

            public SignerInfoBuilder withReason(String reason) {
                this.reason = reason;
                return this;
            }

            public SignerInfo build() {
                return new SignerInfo(this.name, this.orgnizationName, this.idCardNo, this.location, this.contact, this.reason);
            }
        }
    }

    public static class Data {
        private SealData sealData;
        private SealData writeData;

        public static DataBuilder build() {
            return new DataBuilder();
        }

        public Data() {
        }

        public Data(SealData sealData, SealData writeData) {
            this.sealData = sealData;
            this.writeData = writeData;
        }

        public SealData getSealData() {
            return this.sealData;
        }

        public void setSealData(SealData sealData) {
            this.sealData = sealData;
        }

        public SealData getWriteData() {
            return this.writeData;
        }

        public void setWriteData(SealData writeData) {
            this.writeData = writeData;
        }

        public static class DataBuilder {
            private SealData sealData;
            private SealData writeData;

            public DataBuilder withSealData(SealData sealData) {
                this.sealData = sealData;
                return this;
            }

            public DataBuilder withWriteData(SealData writeData) {
                this.sealData = writeData;
                return this;
            }

            public Data build() {
                return new Data(this.sealData, this.writeData);
            }
        }
    }

    public static class Position {
        private KeywordPosition keywordPosition;
        private RectanglePosition rectanglePosition;
        private String fieldName;

        public static PositionBuilder builder() {
            return new PositionBuilder();
        }

        public Position() {
        }

        public Position(KeywordPosition keywordPosition, RectanglePosition rectanglePosition, String fieldName) {
            this.keywordPosition = keywordPosition;
            this.rectanglePosition = rectanglePosition;
            this.fieldName = fieldName;
        }

        public KeywordPosition getKeywordPosition() {
            return this.keywordPosition;
        }

        public void setKeywordPosition(KeywordPosition keywordPosition) {
            this.keywordPosition = keywordPosition;
        }

        public RectanglePosition getRectanglePosition() {
            return this.rectanglePosition;
        }

        public void setRectanglePosition(RectanglePosition rectanglePosition) {
            this.rectanglePosition = rectanglePosition;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldsName) {
            this.fieldName = fieldsName;
        }

        public static class RectanglePosition {
            private Float lrx;
            private Float lry;
            private Float ulx;
            private Float uly;
            private Float scale;
            private Integer page;

            public static RectanglePositionBuilder builder() {
                return new RectanglePositionBuilder();
            }

            public RectanglePosition() {
            }

            public RectanglePosition(Float lrx, Float lry, Float ulx, Float uly, Float scale, Integer page) {
                this.lrx = lrx;
                this.lry = lry;
                this.ulx = ulx;
                this.uly = uly;
                this.scale = scale;
                this.page = page;
            }

            public Float getLrx() {
                return this.lrx;
            }

            public void setLrx(Float lrx) {
                this.lrx = lrx;
            }

            public Float getLry() {
                return this.lry;
            }

            public void setLry(Float lry) {
                this.lry = lry;
            }

            public Float getUlx() {
                return this.ulx;
            }

            public void setUlx(Float ulx) {
                this.ulx = ulx;
            }

            public Float getUly() {
                return this.uly;
            }

            public void setUly(Float uly) {
                this.uly = uly;
            }

            public Float getScale() {
                return this.scale;
            }

            public void setScale(Float scale) {
                this.scale = scale;
            }

            public Integer getPage() {
                return this.page;
            }

            public void setPage(Integer page) {
                this.page = page;
            }

            public static class RectanglePositionBuilder {
                private Float lrx;
                private Float lry;
                private Float ulx;
                private Float uly;
                private Float scale;
                private Integer page;

                public RectanglePositionBuilder withLrx(Float lrx) {
                    this.lrx = lrx;
                    return this;
                }

                @Deprecated
                public RectanglePositionBuilder withLyx(Float lry) {
                    this.lry = lry;
                    return this;
                }

                public RectanglePositionBuilder withLry(Float lry) {
                    this.lry = lry;
                    return this;
                }

                public RectanglePositionBuilder withUlx(Float ulx) {
                    this.ulx = ulx;
                    return this;
                }

                public RectanglePositionBuilder withUly(Float uly) {
                    this.uly = uly;
                    return this;
                }

                public RectanglePositionBuilder withScale(Float scale) {
                    this.scale = scale;
                    return this;
                }

                @Deprecated
                public RectanglePositionBuilder withLrx(Integer page) {
                    this.page = page;
                    return this;
                }

                public RectanglePositionBuilder withPage(Integer page) {
                    this.page = page;
                    return this;
                }

                public RectanglePosition build() {
                    return new RectanglePosition(this.lrx, this.lry, this.ulx, this.uly, this.scale, this.page);
                }
            }
        }

        public static class KeywordPosition {
            private Float width;
            private Float relativeWidthRatio;
            private Float height;
            private Float relativeHeightRatio;
            private Direction direction;
            private Float offset;
            private Float relativeOffsetRatio;
            private String keyword;
            private Float scale;
            private String pages;
            private String replaceTextAfterLocate;
            private Boolean deleteTextAfterLocate;
            private Float xOffset;
            private Float yOffset;
            private Integer index;
            private Boolean reverseIndex;

            public String getReplaceTextAfterLocate() {
                return this.replaceTextAfterLocate;
            }

            public void setReplaceTextAfterLocate(String replaceTextAfterLocate) {
                this.replaceTextAfterLocate = replaceTextAfterLocate;
            }

            public Boolean getDeleteTextAfterLocate() {
                return this.deleteTextAfterLocate;
            }

            public void setDeleteTextAfterLocate(Boolean deleteTextAfterLocate) {
                this.deleteTextAfterLocate = deleteTextAfterLocate;
            }

            public Integer getIndex() {
                return this.index;
            }

            public void setIndex(Integer index) {
                this.index = index;
            }

            public Boolean getReverseIndex() {
                return this.reverseIndex;
            }

            public void setReverseIndex(Boolean reverseIndex) {
                this.reverseIndex = reverseIndex;
            }

            public KeywordPosition() {
            }

            public KeywordPosition(Float width, Float relativeWidthRatio, Float height, Float relativeHeightRatio, Direction direction, Float offset, Float relativeOffsetRatio, String keyword, Float scale, String pages) {
                this.width = width;
                this.relativeWidthRatio = relativeWidthRatio;
                this.height = height;
                this.relativeHeightRatio = relativeHeightRatio;
                this.direction = direction;
                this.offset = offset;
                this.relativeOffsetRatio = relativeOffsetRatio;
                this.keyword = keyword;
                this.scale = scale;
                this.pages = pages;
            }

            public KeywordPosition(Float width, Float relativeWidthRatio, Float height, Float relativeHeightRatio, Direction direction, Float offset, Float relativeOffsetRatio, String keyword, Float scale, String pages, Float xOffset, Float yOffset) {
                this.width = width;
                this.relativeWidthRatio = relativeWidthRatio;
                this.height = height;
                this.relativeHeightRatio = relativeHeightRatio;
                this.direction = direction;
                this.offset = offset;
                this.relativeOffsetRatio = relativeOffsetRatio;
                this.keyword = keyword;
                this.scale = scale;
                this.pages = pages;
                this.xOffset = xOffset;
                this.yOffset = yOffset;
            }

            public KeywordPosition(Float width, Float relativeWidthRatio, Float height, Float relativeHeightRatio, Direction direction, Float offset, Float relativeOffsetRatio, String keyword, Float scale, String pages, Float xOffset, Float yOffset, Integer index) {
                this.width = width;
                this.relativeWidthRatio = relativeWidthRatio;
                this.height = height;
                this.relativeHeightRatio = relativeHeightRatio;
                this.direction = direction;
                this.offset = offset;
                this.relativeOffsetRatio = relativeOffsetRatio;
                this.keyword = keyword;
                this.scale = scale;
                this.pages = pages;
                this.xOffset = xOffset;
                this.yOffset = yOffset;
                this.index = index;
            }

            public KeywordPosition(Float width, Float relativeWidthRatio, Float height, Float relativeHeightRatio, Direction direction, Float offset, Float relativeOffsetRatio, String keyword, Float scale, String pages, Float xOffset, Float yOffset, Integer index, String replaceTextAfterLocate, Boolean deleteTextAfterLocate) {
                this.width = width;
                this.relativeWidthRatio = relativeWidthRatio;
                this.height = height;
                this.relativeHeightRatio = relativeHeightRatio;
                this.direction = direction;
                this.offset = offset;
                this.relativeOffsetRatio = relativeOffsetRatio;
                this.keyword = keyword;
                this.scale = scale;
                this.pages = pages;
                this.xOffset = xOffset;
                this.yOffset = yOffset;
                this.index = index;
                this.replaceTextAfterLocate = replaceTextAfterLocate;
                this.deleteTextAfterLocate = deleteTextAfterLocate;
            }

            public KeywordPosition(Float width, Float relativeWidthRatio, Float height, Float relativeHeightRatio, Direction direction, Float offset, Float relativeOffsetRatio, String keyword, Float scale, String pages, Float xOffset, Float yOffset, Integer index, Boolean reverseIndex, String replaceTextAfterLocate, Boolean deleteTextAfterLocate) {
                this.width = width;
                this.relativeWidthRatio = relativeWidthRatio;
                this.height = height;
                this.relativeHeightRatio = relativeHeightRatio;
                this.direction = direction;
                this.offset = offset;
                this.relativeOffsetRatio = relativeOffsetRatio;
                this.keyword = keyword;
                this.scale = scale;
                this.pages = pages;
                this.xOffset = xOffset;
                this.yOffset = yOffset;
                this.index = index;
                this.reverseIndex = reverseIndex;
                this.replaceTextAfterLocate = replaceTextAfterLocate;
                this.deleteTextAfterLocate = deleteTextAfterLocate;
            }

            public static KeywordPositionBuilder builder() {
                return new KeywordPositionBuilder();
            }

            public Float getWidth() {
                return this.width;
            }

            public void setWidth(Float width) {
                this.width = width;
            }

            public Float getRelativeWidthRatio() {
                return this.relativeWidthRatio;
            }

            public void setRelativeWidthRatio(Float relativeWidthRatio) {
                this.relativeWidthRatio = relativeWidthRatio;
            }

            public Float getHeight() {
                return this.height;
            }

            public void setHeight(Float height) {
                this.height = height;
            }

            public Float getRelativeHeightRatio() {
                return this.relativeHeightRatio;
            }

            public void setRelativeHeightRatio(Float relativeHeightRatio) {
                this.relativeHeightRatio = relativeHeightRatio;
            }

            public Direction getDirection() {
                return this.direction;
            }

            public void setDirection(Direction direction) {
                this.direction = direction;
            }

            public Float getOffset() {
                return this.offset;
            }

            public void setOffset(Float offset) {
                this.offset = offset;
            }

            public Float getRelativeOffsetRatio() {
                return this.relativeOffsetRatio;
            }

            public void setRelativeOffsetRatio(Float relativeOffsetRatio) {
                this.relativeOffsetRatio = relativeOffsetRatio;
            }

            public String getKeyword() {
                return this.keyword;
            }

            public void setKeyword(String keyword) {
                this.keyword = keyword;
            }

            public Float getScale() {
                return this.scale;
            }

            public void setScale(Float scale) {
                this.scale = scale;
            }

            public String getPages() {
                return this.pages;
            }

            public void setPages(String pages) {
                this.pages = pages;
            }

            public Float getxOffset() {
                return this.xOffset;
            }

            public void setxOffset(Float xOffset) {
                this.xOffset = xOffset;
            }

            public Float getyOffset() {
                return this.yOffset;
            }

            public void setyOffset(Float yOffset) {
                this.yOffset = yOffset;
            }

            public static class KeywordPositionBuilder {
                private Float width;
                private Float relativeWidthRatio;
                private Float height;
                private Float relativeHeightRatio;
                private Direction direction;
                private Float offset;
                private Float relativeOffsetRatio;
                private String keyword;
                private Float scale;
                private String pages;
                private Float xOffset;
                private Float yOffset;
                private Integer index;
                private Boolean reverseIndex;
                private String replaceTextAfterLocate;
                private Boolean deleteTextAfterLocate;

                public KeywordPositionBuilder withWidth(Float width) {
                    this.width = width;
                    return this;
                }

                public KeywordPositionBuilder withRelativeWidthRatio(Float relativeWidthRatio) {
                    this.relativeWidthRatio = relativeWidthRatio;
                    return this;
                }

                public KeywordPositionBuilder withHeight(Float height) {
                    this.height = height;
                    return this;
                }

                public KeywordPositionBuilder withRelativeHeightRatio(Float relativeHeightRatio) {
                    this.relativeHeightRatio = relativeHeightRatio;
                    return this;
                }

                public KeywordPositionBuilder withDirection(Direction direction) {
                    this.direction = direction;
                    return this;
                }

                public KeywordPositionBuilder withOffset(Float offset) {
                    this.offset = offset;
                    return this;
                }

                public KeywordPositionBuilder withRelativeOffsetRatio(Float relativeOffsetRatio) {
                    this.relativeOffsetRatio = relativeOffsetRatio;
                    return this;
                }

                public KeywordPositionBuilder withKeyword(String keyword) {
                    this.keyword = keyword;
                    return this;
                }

                public KeywordPositionBuilder withScale(Float scale) {
                    this.scale = scale;
                    return this;
                }

                public KeywordPositionBuilder withPages(String pages) {
                    this.pages = pages;
                    return this;
                }

                public KeywordPositionBuilder withXOffset(Float xOffset) {
                    this.xOffset = xOffset;
                    return this;
                }

                public KeywordPositionBuilder withYOffset(Float yOffset) {
                    this.yOffset = yOffset;
                    return this;
                }

                public KeywordPositionBuilder withIndex(Integer index) {
                    this.index = index;
                    return this;
                }

                public KeywordPositionBuilder withReverseIndex(Boolean reverseIndex) {
                    this.reverseIndex = reverseIndex;
                    return this;
                }

                public KeywordPositionBuilder withReplaceTextAfterLocate(String replaceTextAfterLocate) {
                    this.replaceTextAfterLocate = replaceTextAfterLocate;
                    return this;
                }

                public KeywordPositionBuilder withDeleteTextAfterLocate(Boolean deleteTextAfterLocate) {
                    this.deleteTextAfterLocate = deleteTextAfterLocate;
                    return this;
                }

                public KeywordPosition build() {
                    return new KeywordPosition(this.width, this.relativeWidthRatio, this.height, this.relativeHeightRatio, this.direction, this.offset, this.relativeOffsetRatio, this.keyword, this.scale, this.pages, this.xOffset, this.yOffset, this.index, this.reverseIndex, this.replaceTextAfterLocate, this.deleteTextAfterLocate);
                }
            }
        }

        public static class PositionBuilder {
            private KeywordPosition keywordPosition;
            private RectanglePosition rectanglePosition;
            private String fieldName;

            public PositionBuilder withKeywordPosition(KeywordPosition keywordPosition) {
                this.keywordPosition = keywordPosition;
                return this;
            }

            public PositionBuilder withKeywordPosition(KeywordPosition.KeywordPositionBuilder keywordPositionBuilder) {
                if (keywordPositionBuilder != null) {
                    this.keywordPosition = keywordPositionBuilder.build();
                }
                return this;
            }

            public PositionBuilder withRectanglePosition(RectanglePosition rectanglePosition) {
                this.rectanglePosition = rectanglePosition;
                return this;
            }

            public PositionBuilder withRectanglePosition(RectanglePosition.RectanglePositionBuilder rectanglePositionBuilder) {
                if (rectanglePositionBuilder != null) {
                    this.rectanglePosition = rectanglePositionBuilder.build();
                }
                return this;
            }

            public PositionBuilder withFieldName(String fieldsName) {
                this.fieldName = fieldsName;
                return this;
            }

            public Position build() {
                return new Position(this.keywordPosition, this.rectanglePosition, this.fieldName);
            }
        }
    }

    public static class SignerBuilder {
        private int sequence;
        private Position position;
        private Data data;
        private SignerInfo signerInfo;

        public SignerBuilder withSequence(int sequence) {
            this.sequence = sequence;
            return this;
        }

        public SignerBuilder withPosition(Position position) {
            this.position = position;
            return this;
        }

        public SignerBuilder withData(Data data) {
            this.data = data;
            return this;
        }

        public SignerBuilder withSignerInfo(SignerInfo signerInfo) {
            this.signerInfo = signerInfo;
            return this;
        }

        public Signer build() {
            return new Signer(this.sequence, this.position, this.data, this.signerInfo);
        }
    }
}

