package cn.signit.sdk.type;

/**
 * 
 * 信封流程类型
 * 正常签署流程和作废流程
 * 
 * @author zhangke
 * @since 1.3.21
 */
public enum EnvelopeFlowType {

    UNKNOWN(-1, "未知流程"),
    SIGN_PROCESS(0, "正常签署流程（默认）"), 
    CANCEL_PROCESS(1, "作废流程");

    private int code;
    private String description;

    EnvelopeFlowType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    
    /**
     * 根据名称方式获取对应枚举
     * 
     * @param name 枚举名称
     * @return 名称方式获取对应枚举，若失败，则返回<CODE>EnvelopeFlowType.UNKNOWN</CODE>
     * @since 1.3.21
     * @author zhangke
     */
    public static EnvelopeFlowType get(String name) {
        for (EnvelopeFlowType val : values()) {
            if (val.name().equals(name)) {
                return val;
            }
        }
        return EnvelopeFlowType.UNKNOWN;
    }
    
    /**
     * code码方式获取对应枚举
     * 
     * @param code code码
     * @return code码方式获取对应枚举，若失败，则返回<CODE>EnvelopeFlowType.UNKNOWN</CODE>
     * @since 1.3.21
     * @author zhangke
     */
    public static EnvelopeFlowType get(int code) {
        for (EnvelopeFlowType val : values()) {
            if (val.getCode() == code) {
                return val;
            }
        }
        return EnvelopeFlowType.UNKNOWN;
    }



    public int getCode() {
        return code;
    }


    public void setCode(int code) {
        this.code = code;
    }


    public String getDescription() {
        return description;
    }


    public void setDescription(String description) {
        this.description = description;
    }
}
