package cn.signit.sdk.pojo.response;

import java.util.List;

/**
 * 查询模板变量响应
 * </p>
 *
 * @since 2.7.0
 */
public class QueryTemplateParamDataResponse extends AbstractSignitResponse {
    /**
     * 模板变量数据
     * </p>
     * 
     * @since 2.7.0
     */
    private TemplateParamData templateEnvelopeParamData;

    /**
     * 模板变量数据
     * </p>
     * 
     * @since 2.7.0
     */
    public static class TemplateParamData {
        /**
         * 模板id
         * </p>
         * 
         * @since 2.7.0
         */
        private String templateWsid;
        /**
         * 模板名字
         * </p>
         * 
         * @since 2.7.0
         */
        private String templateName;
        /**
         * 版本
         * </p>
         * 
         * @since 2.7.0
         */
        private Long version;
        /**
         * 签署人变量数据
         * </p>
         * 
         * @since 2.7.0
         */
        private List<ParamParticipant> paramParticipants;
        /**
         * 签署人表单变量数据
         * </p>
         * 
         * @since 2.7.0
         */
        private List<ParamParticipantForm> paramParticipantForms;

        public String getTemplateWsid() {
            return templateWsid;
        }

        public void setTemplateWsid(String templateWsid) {
            this.templateWsid = templateWsid;
        }

        public String getTemplateName() {
            return templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public Long getVersion() {
            return version;
        }

        public void setVersion(Long version) {
            this.version = version;
        }

        public List<ParamParticipant> getParamParticipants() {
            return paramParticipants;
        }

        public void setParamParticipants(List<ParamParticipant> paramParticipants) {
            this.paramParticipants = paramParticipants;
        }

        public List<ParamParticipantForm> getParamParticipantForms() {
            return paramParticipantForms;
        }

        public void setParamParticipantForms(List<ParamParticipantForm> paramParticipantForms) {
            this.paramParticipantForms = paramParticipantForms;
        }

    }

    /**
     * 签署人变量数据
     * 
     * @since 2.7.0
     */
    public static class ParamParticipant {
        /**
         * id
         * 
         * @since 2.7.0
         */
        private String id;
        /**
         * 姓名
         * 
         * @since 2.7.0
         */
        private String name;
        /**
         * 手机号
         * 
         * @since 2.7.0
         */
        private String phone;
        /**
         * 身份证
         * 
         * @since 2.7.0
         */
        private String idCard;
        /**
         * 企业名称
         * 
         * @since 2.7.0
         */
        private String enterpriseName;
        /**
         * 类型 PERSON个人 ENTERPRISE_MEMBER企业
         * 
         * @since 2.7.0
         */
        private String type;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhone() {
            return phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getIdCard() {
            return idCard;
        }

        public void setIdCard(String idCard) {
            this.idCard = idCard;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getEnterpriseName() {
            return enterpriseName;
        }

        public void setEnterpriseName(String enterpriseName) {
            this.enterpriseName = enterpriseName;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

    }

    /**
     * 签署人表单数据
     * 
     * @since 2.7.0
     */
    public static class ParamParticipantForm {
        /**
         * id
         * 
         * @since 2.7.0
         */
        private String id;
        /**
         * 表单名称
         * 
         * @since 2.7.0
         */
        private String name;
        /**
         * 表单类型
         * 
         * @since 2.7.0
         */
        private String type;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

    }

    public TemplateParamData getTemplateEnvelopeParamData() {
        return templateEnvelopeParamData;
    }

    public void setTemplateEnvelopeParamData(TemplateParamData templateEnvelopeParamData) {
        this.templateEnvelopeParamData = templateEnvelopeParamData;
    }
}
