package cn.signit.sdk.pojo.response;

import java.util.Date;
import java.util.List;

import cn.signit.sdk.type.BstStatus;

/**
 * 查询开发者企业启用模板响应
 * </p>
 *
 * @since 2.7.0
 */
public class QueryEnterpriseTemplatesResponse extends AbstractSignitResponse {
    /**
     * 模板列表
     *
     * @since 2.7.0
     */
    private List<Template> templates;

    /**
     * 模板数据结构
     * 
     * @since 2.7.0
     */
    public static class Template {
        /**
         * 业务场景模板.
         *
         * @since 2.7.0
         */
        private Bst bst;

        public Bst getBst() {
            return bst;
        }

        public void setBst(Bst bst) {
            this.bst = bst;
        }

    }

    /**
     * 业务场景模板.
     *
     * @since 2.7.0
     */
    public static class Bst {
        /**
         * 业务场景模板全局唯一ID.
         *
         * @since 2.7.0
         */
        private String wsid;
        /**
         * 业务场景模板名称.
         *
         * @since 2.7.0
         */
        private String name;

        /**
         * 业务场景模板拥有者全局唯一ID，<br>
         * 如：<br>
         * 个人：WSID_PUSR_xxx<br>
         * 企业用户:WSID_EUSR_xxx,<br>
         * 企业：WSID_ENTE_xxx， <br>
         * 公共：WSID_COMM_xxx<br>
         * ....
         *
         * @since 2.7.0
         */
        private String authorWsid;

        /**
         * 业务场景模板描述.
         *
         * @since 2.7.0
         */
        private String description;

        /**
         * 业务场景模板头像文件全局唯一ID.
         *
         * @since 2.7.0
         */
        private String avatarFileWsid;

        /**
         * 业务场景模板状态枚举.<br>
         * DRAFT - 草稿；<br>
         * ENABLE - 启用；<br>
         * DISABLE - 停用；<br>
         * RECYCLED_FROM_DRAFT - 草稿时删除到回收站；<br>
         * RECYCLED_FROM_ENABLE - 启用时删除到回收站；<br>
         * RECYCLED_FROM_DISABLE - 停用时删除到回收站 <br>
         *
         * @since 2.7.0
         */
        private BstStatus status = BstStatus.DRAFT;

        /**
         * 业务场景模板具体配置内容（一般用JSON表示）
         * 
         * @since 2.7.0
         */
        private String configContent;

        /**
         * 业务场景模板当前配置版本号，从0开始
         * 
         * @since 2.7.0
         */
        private int configVersion;

        /**
         * 业务场景模板创建时间
         * 
         * @since 2.7.0
         */
        private Date createdDatetime;

        public String getWsid() {
            return wsid;
        }

        public void setWsid(String wsid) {
            this.wsid = wsid;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAuthorWsid() {
            return authorWsid;
        }

        public void setAuthorWsid(String authorWsid) {
            this.authorWsid = authorWsid;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getAvatarFileWsid() {
            return avatarFileWsid;
        }

        public void setAvatarFileWsid(String avatarFileWsid) {
            this.avatarFileWsid = avatarFileWsid;
        }

        public BstStatus getStatus() {
            return status;
        }

        public void setStatus(BstStatus status) {
            this.status = status;
        }

        public String getConfigContent() {
            return configContent;
        }

        public void setConfigContent(String configContent) {
            this.configContent = configContent;
        }

        public int getConfigVersion() {
            return configVersion;
        }

        public void setConfigVersion(int configVersion) {
            this.configVersion = configVersion;
        }

        public Date getCreatedDatetime() {
            return createdDatetime;
        }

        public void setCreatedDatetime(Date createdDatetime) {
            this.createdDatetime = createdDatetime;
        }

    }

    public List<Template> getTemplates() {
        return templates;
    }

    public void setTemplates(List<Template> templates) {
        this.templates = templates;
    }
}
