package cn.signit.sdk.pojo.response;

import cn.signit.sdk.pojo.FileData;

/**
 * 获取完成签署的流程的文件
 *
 * @author dengwen
 * @since 2.7.0
 */
public class ObtainPackEnvelopesContentResponse extends AbstractSignitResponse {

    // 流程允许在易企签WEB执行的动作对应的URL地址
    private String actionUrl;
    // 创建成功后生用时携带请求头X-Requested-Token
    private String tokenWsid;
    // 文件数据
    private FileData fileData;

    public String getActionUrl() {
        return actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public String getTokenWsid() {
        return tokenWsid;
    }

    public void setTokenWsid(String tokenWsid) {
        this.tokenWsid = tokenWsid;
    }

    public FileData getFileData() {
        return fileData;
    }

    public void setFileData(FileData fileData) {
        this.fileData = fileData;
    }

    /**
     * 
     * 构造方法.
     *
     * @param actionUrl
     *            流程允许在易企签WEB执行的动作对应的URL地址
     * @param tokenWsid
     *            创建成功后生用时携带请求头X-Requested-Token
     * @param fileData
     *            文件数据
     */
    public ObtainPackEnvelopesContentResponse(String actionUrl, String tokenWsid, FileData fileData) {
        super();
        this.actionUrl = actionUrl;
        this.tokenWsid = tokenWsid;
        this.fileData = fileData;
    }

    public ObtainPackEnvelopesContentResponse() {
        super();
    }

    public ObtainPackEnvelopesContentResponse(Builder buildr) {
        this.actionUrl = buildr.actionUrl;
        this.tokenWsid = buildr.tokenWsid;
        this.fileData = buildr.fileData;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder implements cn.signit.sdk.pojo.Builder<ObtainPackEnvelopesContentResponse> {
        private String actionUrl;
        private String tokenWsid;
        private FileData fileData;

        public Builder() {
        }

        /**
         * 
         * 构造方法.
         *
         * @param obtainPackEnvelopesContentResponse
         *            获取完成签署的流程的文件响应
         */
        public Builder(ObtainPackEnvelopesContentResponse obtainPackEnvelopesContentResponse) {
            this.actionUrl = obtainPackEnvelopesContentResponse.actionUrl;
            this.tokenWsid = obtainPackEnvelopesContentResponse.tokenWsid;
            this.fileData = obtainPackEnvelopesContentResponse.fileData;
        }

        /**
         * @param actionUrl
         *            流程允许在易企签WEB执行的动作对应的URL地址
         * @return 获取签署完成文件响应对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder actionUrl(String actionUrl) {
            this.actionUrl = actionUrl;
            return this;
        }

        /**
         * @param tokenWsid
         *            创建成功后生用时携带请求头X-Requested-Token
         * @return 获取签署完成文件响应对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder tokenWsid(String tokenWsid) {
            this.tokenWsid = tokenWsid;
            return this;
        }

        /**
         * @param fileData
         *            文件数据
         * @return 获取签署完成文件响应对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder fileData(FileData fileData) {
            this.fileData = fileData;
            return this;
        }

        @Override
        public ObtainPackEnvelopesContentResponse build() {
            return new ObtainPackEnvelopesContentResponse(this);
        }
    }
}
