package cn.signit.sdk.pojo.request;

import java.util.List;

import cn.signit.sdk.pojo.response.TemplateParamsSendEnvelopeResponse;

/**
 * 模板变了发起信封请求
 * </p>
 *
 * @since 2.7.0
 */
public class TemplateParamsSendEnvelopeRequest extends AbstractSignitRequest<TemplateParamsSendEnvelopeResponse> {
    /**
     * 模板id
     *
     * @since 2.7.0
     */
    private String templateWsid;
    /**
     * 信封标题
     *
     * @since 2.7.0
     */
    private String title;
    /**
     * 信封变量列表
     *
     * @since 2.7.0
     */
    private List<TemplateEnvelopeParamData> paramDatas;

    public String getTemplateWsid() {
        return templateWsid;
    }

    public void setTemplateWsid(String templateWsid) {
        this.templateWsid = templateWsid;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<TemplateEnvelopeParamData> getParamDatas() {
        return paramDatas;
    }

    public void setParamDatas(List<TemplateEnvelopeParamData> paramDatas) {
        this.paramDatas = paramDatas;
    }

    /**
     * 信封变量列表
     *
     * @since 2.7.0
     */
    public static class TemplateEnvelopeParamData {
        /**
         * 签署人数据
         *
         * @since 2.7.0
         */
        private List<ExcelParticipant> paramParticipants;
        /**
         * 签署人表单数据
         *
         * @since 2.7.0
         */
        private List<ExcelParticipantForm> paramParticipantForms;

        public List<ExcelParticipant> getParamParticipants() {
            return paramParticipants;
        }

        public void setParamParticipants(List<ExcelParticipant> paramParticipants) {
            this.paramParticipants = paramParticipants;
        }

        public List<ExcelParticipantForm> getParamParticipantForms() {
            return paramParticipantForms;
        }

        public void setParamParticipantForms(List<ExcelParticipantForm> paramParticipantForms) {
            this.paramParticipantForms = paramParticipantForms;
        }
    }

    /**
     * 签署人数据
     *
     * @since 2.7.0
     */
    public static class ExcelParticipant {
        /**
         * 参与方id
         *
         * @since 2.7.0
         */
        private String id;
        /**
         * 参与方姓名
         *
         * @since 2.7.0
         */
        private String name;
        /**
         * 参与方联系方式
         *
         * @since 2.7.0
         */
        private String phone;
        /**
         * 身份证信息，需要身份验证时，必填
         *
         * @since 2.7.0
         */
        private String idCard;
        /**
         * 企业名称 type为ENTERPRISE_MEMBER 必填
         *
         * @since 2.7.0
         */
        private String enterpriseName;
        /**
         * PERSON-个人 ENTERPRISE_MEMBER-企业
         *
         * @since 2.7.0
         */
        private String type;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhone() {
            return phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getIdCard() {
            return idCard;
        }

        public void setIdCard(String idCard) {
            this.idCard = idCard;
        }

        public String getEnterpriseName() {
            return enterpriseName;
        }

        public void setEnterpriseName(String enterpriseName) {
            this.enterpriseName = enterpriseName;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

    }

    /**
     * 签署人表单数据
     *
     * @since 2.7.0
     */
    public static class ExcelParticipantForm {
        /**
         * 表单id
         *
         * @since 2.7.0
         */
        private String id;
        /**
         * 表单值，日期类型表单，格式为 yyyy-mm-dd
         *
         * @since 2.7.0
         */
        private String value;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    /**
     * 获取响应信息类
     * 
     * @return TemplateParamsSendEnvelopeResponse.class
     * @since 2.7.0
     */
    @Override
    public Class<TemplateParamsSendEnvelopeResponse> getResponseClass() {
        return TemplateParamsSendEnvelopeResponse.class;
    }

}
