package cn.signit.sdk.pojo.request;

import cn.signit.sdk.pojo.response.StartEnvelopeCancelProcessResponse;
import cn.signit.sdk.type.EnvelopeFlowType;

/**
 * 
 * 作废流程请求数据结构.
 * </p>
 *
 * @author DW
 * @since 2.7.0
 */
public class StartEnvelopeCancelProcessRequest extends AbstractSignitRequest<StartEnvelopeCancelProcessResponse> {
    // 发送者的userWsid，非必填，默认会从session中获取
    private String senderWsid;
    // 信封的标题
    private String title;
    // 信封流程类型--签署流程，作废流程。,默认为签署流程 SIGN_PROCESS(0, "正常签署流程（默认）"),
    // CANCEL_PROCESS(1, "作废流程");
    private EnvelopeFlowType envelopeFlowType = EnvelopeFlowType.CANCEL_PROCESS;
    // 已经签署完成的信封的Wsid
    private String completedEnvelopeWsid;
    // 调用方自定义标记，易企签将原封不动返回，非必填
    private String tagId;
    // 普通/批量信封标志位(NORMAL：普通；MULTIPLE：批量)，默认为NORMAL
    private String envelopeFlag;
    // 上次的作废声明文件的文件wsid
    private String[] cancelAnnounceFile;
    // 是否使用默认的作废声明文件，默认为true。并进行预设表单
    private boolean usePresetCancelAnnounceFile;

    public String getSenderWsid() {
        return senderWsid;
    }

    public void setSenderWsid(String senderWsid) {
        this.senderWsid = senderWsid;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public EnvelopeFlowType getEnvelopeFlowType() {
        return envelopeFlowType;
    }

    public void setEnvelopeFlowType(EnvelopeFlowType envelopeFlowType) {
        this.envelopeFlowType = envelopeFlowType;
    }

    public String getCompletedEnvelopeWsid() {
        return completedEnvelopeWsid;
    }

    public void setCompletedEnvelopeWsid(String completedEnvelopeWsid) {
        this.completedEnvelopeWsid = completedEnvelopeWsid;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getEnvelopeFlag() {
        return envelopeFlag;
    }

    public void setEnvelopeFlag(String envelopeFlag) {
        this.envelopeFlag = envelopeFlag;
    }

    public String[] getCancelAnnounceFile() {
        return cancelAnnounceFile;
    }

    public void setCancelAnnounceFile(String[] cancelAnnounceFile) {
        this.cancelAnnounceFile = cancelAnnounceFile;
    }

    public boolean isUsePresetCancelAnnounceFile() {
        return usePresetCancelAnnounceFile;
    }

    public void setUsePresetCancelAnnounceFile(boolean usePresetCancelAnnounceFile) {
        this.usePresetCancelAnnounceFile = usePresetCancelAnnounceFile;
    }

    public StartEnvelopeCancelProcessRequest() {
        super();
    }

    /**
     * 
     * 构造方法.
     *
     * @param senderWsid
     *            发送者的userWsid，非必填，默认会从session中获取
     * @param title
     *            信封的标题
     * @param envelopeFlowType
     *            信封流程类型--签署流程，作废流程。,默认为签署流程 SIGN_PROCESS(0, "正常签署流程（默认）"),
     *            CANCEL_PROCESS(1, "作废流程");
     * @param completedEnvelopeWsid
     *            已经签署完成的信封的Wsid
     * @param tagId
     *            调用方自定义标记，易企签将原封不动返回，非必填
     * @param envelopeFlag
     *            普通/批量信封标志位(NORMAL：普通；MULTIPLE：批量)，默认为NORMAL
     * @param cancelAnnounceFile
     *            上次的作废声明文件的文件wsid
     * @param usePresetCancelAnnounceFile
     *            是否使用默认的作废声明文件，默认为true。并进行预设表单
     */
    public StartEnvelopeCancelProcessRequest(String senderWsid, String title, EnvelopeFlowType envelopeFlowType,
            String completedEnvelopeWsid, String tagId, String envelopeFlag, String[] cancelAnnounceFile,
            boolean usePresetCancelAnnounceFile) {
        super();
        this.senderWsid = senderWsid;
        this.title = title;
        this.envelopeFlowType = envelopeFlowType;
        this.completedEnvelopeWsid = completedEnvelopeWsid;
        this.tagId = tagId;
        this.envelopeFlag = envelopeFlag;
        this.cancelAnnounceFile = cancelAnnounceFile;
        this.usePresetCancelAnnounceFile = usePresetCancelAnnounceFile;
    }

    public StartEnvelopeCancelProcessRequest(Builder builder) {
        this.senderWsid = builder.senderWsid;
        this.title = builder.title;
        this.envelopeFlowType = builder.envelopeFlowType;
        this.completedEnvelopeWsid = builder.completedEnvelopeWsid;
        this.tagId = builder.tagId;
        this.envelopeFlag = builder.envelopeFlag;
        this.cancelAnnounceFile = builder.cancelAnnounceFile;
        this.usePresetCancelAnnounceFile = builder.usePresetCancelAnnounceFile;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder implements cn.signit.sdk.pojo.Builder<StartEnvelopeCancelProcessRequest> {
        private String senderWsid;
        private String title;
        private EnvelopeFlowType envelopeFlowType;
        private String completedEnvelopeWsid;
        private String tagId;
        private String envelopeFlag;
        private String[] cancelAnnounceFile;
        private boolean usePresetCancelAnnounceFile;

        public Builder() {
        }

        public Builder(StartEnvelopeCancelProcessRequest startEnvelopeCancelProcessRequest) {
            this.senderWsid = startEnvelopeCancelProcessRequest.senderWsid;
            this.title = startEnvelopeCancelProcessRequest.title;
            this.envelopeFlowType = startEnvelopeCancelProcessRequest.envelopeFlowType;
            this.completedEnvelopeWsid = startEnvelopeCancelProcessRequest.completedEnvelopeWsid;
            this.tagId = startEnvelopeCancelProcessRequest.tagId;
            this.envelopeFlag = startEnvelopeCancelProcessRequest.envelopeFlag;
            this.cancelAnnounceFile = startEnvelopeCancelProcessRequest.cancelAnnounceFile;
            this.usePresetCancelAnnounceFile = startEnvelopeCancelProcessRequest.usePresetCancelAnnounceFile;
        }

        /**
         * 
         * @param senderWsid
         *            发送者的userWsid，非必填，默认会从session中获取
         * @return 创建合同作废流程请求对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder senderWsid(String senderWsid) {
            this.senderWsid = senderWsid;
            return this;
        }

        /**
         * 
         * @param title
         *            信封的标题
         * @return 创建合同作废流程请求对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder title(String title) {
            this.title = title;
            return this;
        }

        /**
         * 
         * @param envelopeFlowType
         *            信封流程类型--签署流程，作废流程。,默认为签署流程 SIGN_PROCESS(0, "正常签署流程（默认）"),
         *            CANCEL_PROCESS(1, "作废流程");
         * @return 创建合同作废流程请求对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder envelopeFlowType(EnvelopeFlowType envelopeFlowType) {
            this.envelopeFlowType = envelopeFlowType;
            return this;
        }

        /**
         * 
         * @param completedEnvelopeWsid
         *            已经签署完成的信封的Wsid
         * @return 创建合同作废流程请求对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder completedEnvelopeWsid(String completedEnvelopeWsid) {
            this.completedEnvelopeWsid = completedEnvelopeWsid;
            return this;
        }

        /**
         * 
         * @param tagId
         *            调用方自定义标记，易企签将原封不动返回，非必填
         * @return 创建合同作废流程请求对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder tagId(String tagId) {
            this.tagId = tagId;
            return this;
        }

        /**
         * 
         * @param envelopeFlag
         *            普通/批量信封标志位(NORMAL：普通；MULTIPLE：批量)，默认为NORMAL
         * @return 创建合同作废流程请求对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder envelopeFlag(String envelopeFlag) {
            this.envelopeFlag = envelopeFlag;
            return this;
        }

        /**
         * 
         * @param cancelAnnounceFile
         *            上次的作废声明文件的文件wsid
         * @return 创建合同作废流程请求对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder cancelAnnounceFile(String[] cancelAnnounceFile) {
            this.cancelAnnounceFile = cancelAnnounceFile;
            return this;
        }

        /**
         * 
         * @param usePresetCancelAnnounceFile
         *            是否使用默认的作废声明文件，默认为true。并进行预设表单
         * @return 创建合同作废流程请求对象建造器
         * @author DW
         * @since 2.7.0
         */
        public Builder usePresetCancelAnnounceFile(boolean usePresetCancelAnnounceFile) {
            this.usePresetCancelAnnounceFile = usePresetCancelAnnounceFile;
            return this;
        }

        @Override
        public StartEnvelopeCancelProcessRequest build() {
            return new StartEnvelopeCancelProcessRequest(this);
        }

    }

    @Override
    public Class<StartEnvelopeCancelProcessResponse> getResponseClass() {
        return StartEnvelopeCancelProcessResponse.class;
    }
}
