package cn.signit.sdk.pojo.request;

import cn.signit.sdk.pojo.response.AbstractSignitResponse;
import cn.signit.sdk.type.AcceptDataType;

public abstract class AbstractSignitRequest<T extends AbstractSignitResponse> {
    /**
     * 调用方自定义标识，易企签会原封不动返回.
     *
     * @since 1.0.2
     */
    protected String customTag;

    /**
     * 调用方自定义要求易企签的WEB平台在流程结束后需要跳转的指定URL地址.
     *
     * @since 1.0.2
     */
    protected String returnUrl;

    /**
     * 调用方接受的响应数据类型，支持：BASE64/URL.
     *
     * @since 1.0.2
     */
    protected AcceptDataType acceptDataType;
    /**
     * 开放平台通过URL地址返回的信封完成事件中的信封链接有效期设置
     * 只有保证acceptDataType = url的时候，该信封链接有效期才起效
     * 分钟为单位
     * 默认为15天(21600分钟)
     * @since 2.7.0
     */
    protected Integer acceptDataByUrlAliveMinutes;
    /**
     * 开放平台是否允许开启信封预览链接功能，并设置有效期
     * 只有保证开启enablePreview=true，该有效期设置才起作用
     * 分钟为单位
     * 默认为15天(21600分钟)
     * @since 2.7.0
     */
    protected Integer previewAliveMinutes;
    /**
     * 是否允许开启信封签署完成预览功能
     * 默认为不开启(false)
     * @since 2.7.0
     */
    protected Boolean enablePreview;

    public String getCustomTag() {
        return customTag;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public AcceptDataType getAcceptDataType() {
        return acceptDataType;
    }

    public void setCustomTag(String customTag) {
        this.customTag = customTag;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public void setAcceptDataType(AcceptDataType acceptDataType) {
        this.acceptDataType = acceptDataType;
    }

    public Integer getAcceptDataByUrlAliveMinutes() {
        return acceptDataByUrlAliveMinutes;
    }

    public void setAcceptDataByUrlAliveMinutes(Integer acceptDataByUrlAliveMinutes) {
        this.acceptDataByUrlAliveMinutes = acceptDataByUrlAliveMinutes;
    }

    public Integer getPreviewAliveMinutes() {
        return previewAliveMinutes;
    }

    public void setPreviewAliveMinutes(Integer previewAliveMinutes) {
        this.previewAliveMinutes = previewAliveMinutes;
    }

    public Boolean getEnablePreview() {
        return enablePreview;
    }

    public void setEnablePreview(Boolean enablePreview) {
        this.enablePreview = enablePreview;
    }

    public abstract Class<T> getResponseClass();

}
