/*
 * Copyright © 2020 signit.cn. All rights reserved.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package cn.signit.sdk.pojo;

/**
 * 参与方预填身份信息元数据.<br/>
 * 
 * 此对象将支持设置到@{@link cn.signit.wesign.mss.developer.pojo.bo.open.BoSender.SenderMetaData}
 * 或
 * {@link cn.signit.wesign.mss.envelope.pojo.bo.metadata.BoParticipantMetadata}中的“presetIdentities”属性字段中；<br/>
 * 
 * <pre>
 * senderMetadata：
 * 
 * {
 *   "groups": [{
 *       "id": 78258376,
 *       "groupId": null,
 *       "position": 0,
 *       "groupName": "企业内部流程:西南科技大学教务处",
 *       "type": "ENTERPRISE_INSIDE",
 *       "enterpriseName": "西南科技大学教务处",
 *       "enterpriseWsid": "WSID_ENTE_00000163aed6db150242ac1300020001"
 *   }],
 *   "order": true,
 *   "presetIdentities": [{
 *       "identityType": "SECOND_GENERATION_IDCARD",
 *       "identityName": "*洪东",
 *       "identityCode": "510xxxxxx7311",
 *       "modifiable": true,
 *       "usage": "SIGN_IDENTITY_VERIFICATION"
 *   }]
 * }
 * 
 * 
 * receiverMetadata:
 * 
 * {
 *  
 *   "id": 78258376,
 *   "groupId": null,
 *   "position": 0,
 *   "groupName": "企业内部流程:西南科技大学教务处",
 *   "type": "ENTERPRISE_INSIDE",
 *   "enterpriseName": "西南科技大学教务处",
 *   "enterpriseWsid": "WSID_ENTE_00000163aed6db150242ac1300020001",
 *   "presetIdentities": [{
 *       "identityType": "SECOND_GENERATION_IDCARD",
 *       "identityName": "*洪东",
 *       "identityCode": "510xxxxxx7311",
 *       "modifiable": true,
 *       "usage": "SIGN_IDENTITY_VERIFICATION"
 *   }]
 * }
 * 
 * 表示以上json字符串中‘presetIdentities’部分
 * </pre>
 * 
 * @author RyanChang
 * @since sogal-1.3.20
 */
public class ParticipantPresetIdentity {
    /**
     * 预填身份类型.<br/>
     * 
     * 支持： SECOND_GENERATION_IDCARD - 二代居民身份证
     * 
     * @since sogal-1.3.15
     * 
     */
    // @NotBlank
    private String identityType;

    /**
     * 预填身份信息上的名称.
     * 
     * 
     * @since sogal-1.3.15
     * 
     */
    // @NotBlank
    private String identityName;

    /**
     * 预填身份信息上的编码.
     * 
     * 
     * @since sogal-1.3.15
     * 
     */
    // @NotBlank
    private String identityCode;

    /**
     * 当前预填身份信息是否可修改.<br/>
     * 默认：false
     * 
     * 
     * @since sogal-1.3.15
     * 
     */
    private boolean modifiable;

    /**
     * 当前预填身份信息用途.<br/>
     * 支持： SIGN_IDENTITY_VERIFICATION - 签署身份校验
     * 
     * 
     * @since sogal-1.3.15
     * 
     */
    // @NotBlank
    private String usage;

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public String getIdentityName() {
        return identityName;
    }

    public void setIdentityName(String identityName) {
        this.identityName = identityName;
    }

    public String getIdentityCode() {
        return identityCode;
    }

    public void setIdentityCode(String identityCode) {
        this.identityCode = identityCode;
    }

    public boolean isModifiable() {
        return modifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public String getUsage() {
        return usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public ParticipantPresetIdentity() {
    }

    public ParticipantPresetIdentity(Builder builder) {
        this.identityType = builder.identityType;
        this.identityName = builder.identityName;
        this.identityCode = builder.identityCode;
        this.modifiable = builder.modifiable;
        this.usage = builder.usage;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder implements cn.signit.sdk.pojo.Builder<ParticipantPresetIdentity> {

        private String identityType;
        private String identityName;
        private String identityCode;
        private boolean modifiable;
        private String usage;

        public Builder(ParticipantPresetIdentity participantPresetIdentity) {
            this.identityType = participantPresetIdentity.identityType;
            this.identityName = participantPresetIdentity.identityName;
            this.identityCode = participantPresetIdentity.identityCode;
            this.modifiable = participantPresetIdentity.modifiable;
            this.usage = participantPresetIdentity.usage;
        }

        public Builder() {
        }

        /**
         * 
         * @param identityType
         *            预填身份类型
         * @return 预设身份信息列表对象建造器{@link ParticipantPresetIdentity.Builder}
         * @since 2.7.0
         */
        public Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        /**
         * 
         * @param identityName
         *            预填身份信息上的名称
         * @return 预设身份信息列表对象建造器{@link ParticipantPresetIdentity.Builder}
         * @since 2.7.0
         */
        public Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        /**
         * 
         * @param identityCode
         *            预填身份信息上的编码
         * @return 预设身份信息列表对象建造器{@link ParticipantPresetIdentity.Builder}
         * @since 2.7.0
         */
        public Builder identityCode(String identityCode) {
            this.identityCode = identityCode;
            return this;
        }

        /**
         * 
         * @param modifiable
         *            当前预填身份信息是否可修改
         * @return 预设身份信息列表对象建造器{@link ParticipantPresetIdentity.Builder}
         * @since 2.7.0
         */
        public Builder modifiable(boolean modifiable) {
            this.modifiable = modifiable;
            return this;
        }

        /**
         * 
         * @param usage
         *            当前预填身份信息用途
         * @return 预设身份信息列表对象建造器{@link ParticipantPresetIdentity.Builder}
         * @since 2.7.0
         */
        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public ParticipantPresetIdentity build() {
            return new ParticipantPresetIdentity(this);
        }
    }
}
