/*
 * Copyright © 2018 signit.cn. All rights reserved.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package cn.signit.sdk.pojo;

import cn.signit.sdk.type.TransferType;

/**
 * 
 * 快捷签署文件数据.
 *
 * @since 1.0.0
 */
public class FileData {
    private String url;
    private String base64;
    private Boolean enableSinglePage;
    private String name;
    private Long byteSize;
    private TransferType transferType;
    private byte[] fileBytes;
    private String fileWsid;
    private String contentType;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getByteSize() {
        return byteSize;
    }

    public void setByteSize(Long byteSize) {
        this.byteSize = byteSize;
    }

    public TransferType getTransferType() {
        return transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public byte[] getFileBytes() {
        return fileBytes;
    }

    public void setFileBytes(byte[] fileBytes) {
        this.fileBytes = fileBytes;
    }

    public String getFileWsid() {
        return fileWsid;
    }

    public void setFileWsid(String fileWsid) {
        this.fileWsid = fileWsid;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Boolean getEnableSinglePage() {
        return enableSinglePage;
    }

    public void setEnableSinglePage(Boolean enableSinglePage) {
        this.enableSinglePage = enableSinglePage;
    }

    public FileData() {
    }

    public FileData(String url) {
        this.url = url;
    }

    public String getUrl() {
        return url;
    }

    public FileData setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getBase64() {
        return base64;
    }

    public FileData setBase64(String base64) {
        this.base64 = base64;
        return this;
    }

    /**
     * 
     * url和base64同时存在时，优先base64.
     *
     * @param url
     *            待签名文件（html/pdf/doc/docx/xls/xlsx/ppt/pptx）的URL地址
     * @param base64
     *            待签名文件（html/pdf/doc/docx/xls/xlsx/ppt/pptx）的base64表示形式的字符串，支持最大约10MB的文件数据
     * @param enableSinglePage
     *            待签名的文件是否转换成单页的形式，否则，默认使用A4尺寸自动进行分页，注：待签名文件为html时该值有效，且此单页最大支持的高度为5000mm
     * @param name
     *            文件名字
     * @param byteSize
     *            文件字节大小
     * @param transferType
     *            文件传输类型：UNKNOWN-未知状态、BASE64-BASE64传输类型、URL-URL传输类型、FILE_WSID-FILE_WSID传输类型
     * @param fileBytes
     *            文件字节数组
     * @param fileWsid
     *            WSID表示的文件在易企签的唯一标识
     * @param contentType
     *            文件内容类型
     */
    public FileData(String url, String base64, Boolean enableSinglePage, String name, Long byteSize,
            TransferType transferType, byte[] fileBytes, String fileWsid, String contentType) {
        super();
        this.url = url;
        this.base64 = base64;
        this.enableSinglePage = enableSinglePage;
        this.name = name;
        this.byteSize = byteSize;
        this.transferType = transferType;
        this.fileBytes = fileBytes;
        this.fileWsid = fileWsid;
        this.contentType = contentType;
    }

    /**
     * 
     * url和base64同时存在时，优先base64.
     *
     * @param url
     *            待签名文件（html/pdf/doc/docx/xls/xlsx/ppt/pptx）的URL地址
     * @param base64
     *            待签名文件（html/pdf/doc/docx/xls/xlsx/ppt/pptx）的base64表示形式的字符串，支持最大约10MB的文件数据
     * @param enableSinglePage
     *            待签名的文件是否转换成单页的形式，否则，默认使用A4尺寸自动进行分页，注：待签名文件为html时该值有效，且此单页最大支持的高度为5000mm
     */
    public FileData(String url, String base64, Boolean enableSinglePage) {
        super();
        this.url = url;
        this.base64 = base64;
        this.enableSinglePage = enableSinglePage;
    }

    /**
     * @since 2.5.0
     * @return 返回一个新的{@link Builder}对象
     */
    public static Builder builder() {
        return new Builder();
    }

    /**
     * 文件数据建造器
     * 
     * @since 2.5.0
     */
    public static class Builder implements cn.signit.sdk.pojo.Builder<FileData> {
        private String url;
        private String base64;
        private Boolean enableSinglePage;
        private String name;
        private Long byteSize;
        private TransferType transferType;
        private byte[] fileBytes;
        private String fileWsid;
        private String contentType;

        /**
         * @param url
         *            待签名文件（html/pdf/doc/docx/xls/xlsx/ppt/pptx）的URL地址
         * @since 2.5.0
         * @return 文件数据建造器
         */
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        /**
         * @param base64
         *            待签名文件（html/pdf/doc/docx/xls/xlsx/ppt/pptx）的base64表示形式的字符串，支持最大约10MB的文件数据
         * @since 2.5.0
         * @return 文件数据建造器
         */
        public Builder base64(String base64) {
            this.base64 = base64;
            return this;
        }

        /**
         * @param enableSinglePage
         *            待签名的文件是否转换成单页的形式，否则，默认使用A4尺寸自动进行分页，注：待签名文件为html时该值有效，且此单页最大支持的高度为5000mm
         * @since 2.5.0
         * @return 文件数据建造器
         */
        public Builder enableSinglePage(Boolean enableSinglePage) {
            this.enableSinglePage = enableSinglePage;
            return this;
        }

        /**
         * @param name
         *            文件名字
         * 
         * @since 2.7.0
         * @return 文件数据建造器
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * @param byteSize
         *            文件字节数组
         * 
         * @since 2.7.0
         * @return 文件数据建造器
         */
        public Builder byteSize(Long byteSize) {
            this.byteSize = byteSize;
            return this;
        }

        /**
         * @param transferType
         *            转换类型
         * 
         * @since 2.7.0
         * @return 文件数据建造器
         */
        public Builder transferType(TransferType transferType) {
            this.transferType = transferType;
            return this;
        }

        /**
         * @param fileBytes
         *            文件内容字节数组
         * 
         * @since 2.7.0
         * @return 文件数据建造器
         */
        public Builder fileBytes(byte[] fileBytes) {
            this.fileBytes = fileBytes;
            return this;
        }

        /**
         * @param fileWsid
         *            文件wsid
         * 
         * @since 2.7.0
         * @return 文件数据建造器
         */
        public Builder fileWsid(String fileWsid) {
            this.fileWsid = fileWsid;
            return this;
        }

        /**
         * @param contentType
         *            文件内容类型
         * 
         * @since 2.7.0
         * @return 文件数据建造器
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * @since 2.5.0
         * @return 返回一个新的{@link FileData}对象
         */
        @Override
        public FileData build() {
            // return new FileData(url, base64, enableSinglePage);
            return new FileData(url, base64, enableSinglePage, name, byteSize, transferType, fileBytes, fileWsid,
                    contentType);
        }
    }

}
