/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.pojo.request;

import cn.signit.sdk.pojo.IdCardImage;
import cn.signit.sdk.pojo.request.AbstractSignitRequest;
import cn.signit.sdk.pojo.response.PersonVerifyResponse;
import cn.signit.sdk.type.AcceptDataType;
import cn.signit.sdk.type.IdCardType;
import cn.signit.sdk.type.PersonAuthType;
import cn.signit.sdk.util.ListBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PersonVerifyRequest
extends AbstractSignitRequest<PersonVerifyResponse> {
    private String name;
    private String phone;
    private IdCardType idCardType;
    private String idCardNo;
    private List<IdCardImage> idCardImages;
    private String customTag;
    private String returnUrl;
    private AcceptDataType acceptDataType;
    private List<PersonAuthType> authModes;
    private Boolean enableEmbeddedMode;

    public List<PersonAuthType> getAuthModes() {
        return this.authModes;
    }

    public String getName() {
        return this.name;
    }

    public String getPhone() {
        return this.phone;
    }

    public IdCardType getIdCardType() {
        return this.idCardType;
    }

    public String getIdCardNo() {
        return this.idCardNo;
    }

    public List<IdCardImage> getIdCardImages() {
        return this.idCardImages;
    }

    @Override
    public String getCustomTag() {
        return this.customTag;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public AcceptDataType getAcceptDataType() {
        return this.acceptDataType;
    }

    public Boolean getEnableEmbeddedMode() {
        return this.enableEmbeddedMode;
    }

    public PersonVerifyRequest(Builder builder) {
        this.name = builder.name;
        this.phone = builder.phone;
        this.idCardType = builder.idCardType;
        this.idCardNo = builder.idCardNo;
        this.idCardImages = builder.idCardImages;
        this.customTag = builder.customTag;
        this.returnUrl = builder.returnUrl;
        this.acceptDataType = builder.acceptDataType;
        this.authModes = builder.authModes;
        this.enableEmbeddedMode = builder.enableEmbeddedMode;
    }

    public PersonVerifyRequest() {
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Class<PersonVerifyResponse> getResponseClass() {
        return PersonVerifyResponse.class;
    }

    public static class Builder
    implements cn.signit.sdk.pojo.Builder<PersonVerifyRequest> {
        private String name;
        private String phone;
        private IdCardType idCardType;
        private String idCardNo;
        private List<IdCardImage> idCardImages;
        private String customTag;
        private String returnUrl;
        private AcceptDataType acceptDataType;
        private List<PersonAuthType> authModes;
        private Boolean enableEmbeddedMode;

        public Builder() {
        }

        public Builder(PersonVerifyRequest personVerifyRequest) {
            this.name = personVerifyRequest.name;
            this.phone = personVerifyRequest.phone;
            this.idCardType = personVerifyRequest.idCardType;
            this.idCardNo = personVerifyRequest.idCardNo;
            this.idCardImages = personVerifyRequest.idCardImages;
            this.customTag = personVerifyRequest.customTag;
            this.returnUrl = personVerifyRequest.returnUrl;
            this.acceptDataType = personVerifyRequest.acceptDataType;
            this.authModes = personVerifyRequest.authModes;
            this.enableEmbeddedMode = personVerifyRequest.enableEmbeddedMode;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public Builder idCardType(IdCardType idCardType) {
            this.idCardType = idCardType;
            return this;
        }

        public Builder idCardNo(String idCardNo) {
            this.idCardNo = idCardNo;
            return this;
        }

        public Builder idCardImages(List<IdCardImage> idCardImages) {
            this.idCardImages = idCardImages;
            return this;
        }

        public Builder customTag(String customTag) {
            this.customTag = customTag;
            return this;
        }

        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder acceptDataType(AcceptDataType acceptDataType) {
            this.acceptDataType = acceptDataType;
            return this;
        }

        public Builder idCardImages(IdCardImage.Builder ... idCardImageBuilders) {
            this.idCardImages = ListBuilder.buildList(Arrays.asList(idCardImageBuilders));
            return this;
        }

        public Builder authModes(PersonAuthType ... authModes) {
            if (authModes != null && authModes.length != 0) {
                ArrayList<PersonAuthType> list = new ArrayList<PersonAuthType>();
                for (PersonAuthType authMode : authModes) {
                    list.add(authMode);
                }
                this.authModes = list;
            }
            return this;
        }

        public Builder authModes(List<PersonAuthType> authModes) {
            this.authModes = authModes;
            return this;
        }

        public Builder enableEmbeddedMode(boolean enableEmbeddedMode) {
            this.enableEmbeddedMode = enableEmbeddedMode;
            return this;
        }

        @Override
        public PersonVerifyRequest build() {
            return new PersonVerifyRequest(this);
        }
    }
}

