/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.http;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.http.AbstractHttpRequest;
import cn.signit.sdk.http.Authentication;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;

public class HttpGetRequest
extends AbstractHttpRequest {
    private Map<String, String> parameters = null;

    public HttpGetRequest(String url) throws SignitException {
        this(url, null, null);
    }

    public HttpGetRequest(String url, Authentication auth) throws SignitException {
        this(url, null, auth);
    }

    public HttpGetRequest(String url, Map<String, String> parameters) throws SignitException {
        this(url, parameters, null);
    }

    public HttpGetRequest(String url, Map<String, String> parameters, Authentication auth) throws SignitException {
        if (url == null || "".equals(url)) {
            throw new SignitException("URL cannot be null or empty");
        }
        this.url = url;
        if (parameters != null) {
            this.parameters = parameters;
        }
        if (auth != null) {
            this.auth = new Authentication(auth);
        }
    }

    @Override
    protected HttpURLConnection getConnection() throws SignitException, IOException {
        HttpURLConnection connection;
        if (this.parameters != null) {
            this.url = this.url + "?";
            Iterator<String> keys = this.parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                try {
                    this.url = this.url + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(this.parameters.get(key), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new SignitException(ex);
                }
                if (!keys.hasNext()) continue;
                this.url = this.url + "&";
            }
        }
        try {
            connection = (HttpURLConnection)new URL(this.url).openConnection();
        }
        catch (Exception e) {
            throw new SignitException(e);
        }
        connection.setRequestProperty("user-agent", "Signit HTTP");
        connection.setRequestProperty("Accept-Charset", "UTF-8");
        connection.setRequestProperty("X-Signit-App-Id", this.auth.getAppId());
        if (this.auth != null) {
            this.auth.authenticate(connection, this.url);
        }
        return connection;
    }
}

