/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.http.Authentication;
import cn.signit.sdk.http.HttpClient;
import cn.signit.sdk.pojo.OauthData;
import cn.signit.sdk.pojo.SignatureRequest;
import cn.signit.sdk.pojo.SignatureResponse;
import cn.signit.sdk.pojo.WebhookData;
import cn.signit.sdk.pojo.request.AbstractSignitRequest;
import cn.signit.sdk.pojo.response.AbstractSignitResponse;
import cn.signit.sdk.pojo.webhook.response.WebhookResponse;
import cn.signit.sdk.type.TokenType;
import cn.signit.sdk.util.FastjsonDecoder;
import cn.signit.sdk.util.HmacSignatureBuilder;
import cn.signit.sdk.util.Validator;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class SignitClient {
    private static ThreadLocal<Authentication> AUTH = new ThreadLocal<Authentication>(){

        @Override
        protected Authentication initialValue() {
            return new Authentication();
        }
    };
    private static ThreadLocal<HttpClient> HTTP_CLIENT = new ThreadLocal<HttpClient>(){

        @Override
        protected HttpClient initialValue() {
            return new HttpClient();
        }
    };
    private static ThreadLocal<String> BASE_URL = new ThreadLocal();
    private static ThreadLocal<String> OAUTH_TOKEN_URL = new ThreadLocal();
    private static final int MAX_COUNT = 3;
    private static final Pattern LEFT_QUOTATION = Pattern.compile("\"\\{");
    private static final Pattern RIGHT_QUOTATION = Pattern.compile("\\}\"");
    private static final Pattern BACKLASH_QUOTATION = Pattern.compile("\\\\\"");

    public SignitClient(Authentication auth) {
        this(auth, new HttpClient(), "https://open.signit.cn");
    }

    @Deprecated
    public SignitClient(Authentication auth, String envUrl) {
        this(auth, new HttpClient(), envUrl);
    }

    private SignitClient(Authentication auth, HttpClient httpClient, String url) {
        this.setUrl(url);
        AUTH.set(auth);
        HTTP_CLIENT.set(httpClient);
    }

    public SignitClient(String appId, String secretKey, String appUrl) {
        AUTH.set(new Authentication(appId, secretKey));
        BASE_URL.set(appUrl);
        OAUTH_TOKEN_URL.set("https://open.signit.cn/v1/oauth/oauth/token");
        HTTP_CLIENT.set(new HttpClient());
    }

    private void setUrl(String environmentUrl) {
        String tempUrl = environmentUrl == null || environmentUrl.trim().equals("") ? "https://open.signit.cn" : environmentUrl;
        BASE_URL.set(tempUrl + "/v1/open/signatures/quick-sign");
        OAUTH_TOKEN_URL.set(tempUrl + "/v1/oauth/oauth/token");
    }

    @Deprecated
    public SignitClient setEnvironmentUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public SignitClient setOauthUrl(String url) {
        OAUTH_TOKEN_URL.set(url);
        return this;
    }

    @Deprecated
    public SignitClient setSignUrl(String url) {
        BASE_URL.set(url);
        return this;
    }

    public SignatureResponse sendSignatureRequest(SignatureRequest request) throws SignitException, IOException {
        if (request == null) {
            return null;
        }
        if (!(AUTH.get().hasAccessTokenType() && AUTH.get().hasAppId() && AUTH.get().hasSecretKey())) {
            throw new SignitException("\u8bf7\u5b8c\u5584\u5f00\u53d1\u8005\u4fe1\u606f");
        }
        HTTP_CLIENT.get().withAuth(AUTH.get()).withPostObject(request);
        if (!AUTH.get().hasAccessToken()) {
            this.getOauthData(AUTH.get().getAppId(), AUTH.get().getSecretKey(), AUTH.get().getAccessTokenType(), true);
        }
        return this.retrySendRequest(1);
    }

    private SignatureResponse retrySendRequest(int tryStartCount) throws SignitException {
        if (tryStartCount > 3) {
            throw new SignitException("\u8bf7\u6838\u5b9e\u5f00\u53d1\u8005\u8d26\u6237\u6570\u636e\u662f\u5426\u65e0\u8bef");
        }
        try {
            return HTTP_CLIENT.get().withAuth(AUTH.get()).post(BASE_URL.get()).AsObject(SignatureResponse.class);
        }
        catch (SignitException e) {
            if ("invalid_token".equals(e.getMessage())) {
                this.getOauthData(AUTH.get().getAppId(), AUTH.get().getSecretKey(), AUTH.get().getAccessTokenType(), true);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    return this.retrySendRequest(++tryStartCount);
                }
                return this.retrySendRequest(++tryStartCount);
            }
            throw e;
        }
        catch (Exception e) {
            throw new SignitException(e);
        }
    }

    public OauthData getOauthData(String apiKey, String secretKey, TokenType grantType, boolean autoSetRequestToken) throws SignitException {
        if (apiKey == null || secretKey == null) {
            throw new SignitException("\u8bf7\u5b8c\u5584\u5f00\u53d1\u8005\u8d26\u6237\u6570\u636e");
        }
        TokenType tmpGrantType = grantType != null ? grantType : TokenType.CLIENT_CREDENTIALS;
        String response = HTTP_CLIENT.get().withAuth(AUTH.get()).withGetParam("client_id", apiKey).withGetParam("client_secret", secretKey).withGetParam("grant_type", tmpGrantType.name().toLowerCase()).get(OAUTH_TOKEN_URL.get()).getLastResponse();
        JSONObject data = JSON.parseObject(Validator.notNull(response, "\u8bf7\u6c42token\u6570\u636e\u5931\u8d25"));
        if (data != null && autoSetRequestToken) {
            AUTH.get().setAccessToken(Validator.notNull(data.getString("access_token"), "token\u83b7\u53d6\u5931\u8d25"));
        }
        return (OauthData)FastjsonDecoder.decodeAsBean(response, OauthData.class);
    }

    public WebhookData parseWebhookData(String webhook) {
        if (webhook == null || webhook.trim().length() <= 0) {
            return null;
        }
        webhook = LEFT_QUOTATION.matcher(webhook).replaceAll("{");
        webhook = RIGHT_QUOTATION.matcher(webhook).replaceAll("}");
        webhook = BACKLASH_QUOTATION.matcher(webhook).replaceAll("\"");
        return (WebhookData)FastjsonDecoder.decodeAsBean(webhook, WebhookData.class);
    }

    public static WebhookResponse parseWebhookResponse(String webhook) {
        return (WebhookResponse)FastjsonDecoder.decodeAsBean(webhook, WebhookResponse.class);
    }

    public <T> T executeFree(Map<String, Serializable> query, Class<T> responseClass) throws SignitException {
        if (!(AUTH.get().hasAccessTokenType() && AUTH.get().hasAppId() && AUTH.get().hasSecretKey())) {
            throw new SignitException("\u8bf7\u5b8c\u5584\u5f00\u53d1\u8005\u4fe1\u606f");
        }
        HTTP_CLIENT.get().withAuth(AUTH.get()).withPostFields(query);
        if (!AUTH.get().hasAccessToken()) {
            this.getOauthData(AUTH.get().getAppId(), AUTH.get().getSecretKey(), AUTH.get().getAccessTokenType(), true);
        }
        return this.retrySendRequest(responseClass, 1);
    }

    public <T extends AbstractSignitResponse> T execute(Map<String, Serializable> query, Class<T> responseClass) throws SignitException {
        if (!(AUTH.get().hasAccessTokenType() && AUTH.get().hasAppId() && AUTH.get().hasSecretKey())) {
            throw new SignitException("\u8bf7\u5b8c\u5584\u5f00\u53d1\u8005\u4fe1\u606f");
        }
        HTTP_CLIENT.get().withAuth(AUTH.get()).withPostFields(query);
        if (!AUTH.get().hasAccessToken()) {
            this.getOauthData(AUTH.get().getAppId(), AUTH.get().getSecretKey(), AUTH.get().getAccessTokenType(), true);
        }
        return (T)((AbstractSignitResponse)this.retrySendRequest(responseClass, 1));
    }

    public <T extends AbstractSignitResponse> T execute(AbstractSignitRequest<T> request) throws SignitException {
        if (request == null) {
            return null;
        }
        if (!(AUTH.get().hasAccessTokenType() && AUTH.get().hasAppId() && AUTH.get().hasSecretKey())) {
            throw new SignitException("\u8bf7\u5b8c\u5584\u5f00\u53d1\u8005\u4fe1\u606f");
        }
        HTTP_CLIENT.get().withAuth(AUTH.get()).withPostObject(request);
        if (!AUTH.get().hasAccessToken()) {
            this.getOauthData(AUTH.get().getAppId(), AUTH.get().getSecretKey(), AUTH.get().getAccessTokenType(), true);
        }
        return (T)((AbstractSignitResponse)this.retrySendRequest(request.getResponseClass(), 1));
    }

    private <T> T retrySendRequest(Class<T> responseClass, int tryStartCount) throws SignitException {
        if (tryStartCount > 3) {
            throw new SignitException("\u8bf7\u6838\u5b9e\u5f00\u53d1\u8005\u8d26\u6237\u6570\u636e\u662f\u5426\u65e0\u8bef");
        }
        try {
            if (responseClass.getName().equals(InputStream.class.getName())) {
                return HTTP_CLIENT.get().withAuth(AUTH.get()).postAndGetInputStream(BASE_URL.get()).AsObject(responseClass);
            }
            return HTTP_CLIENT.get().withAuth(AUTH.get()).post(BASE_URL.get()).AsObject(responseClass);
        }
        catch (SignitException e) {
            if ("invalid_token".equals(e.getMessage())) {
                this.getOauthData(AUTH.get().getAppId(), AUTH.get().getSecretKey(), AUTH.get().getAccessTokenType(), true);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    return this.retrySendRequest(responseClass, ++tryStartCount);
                }
                return this.retrySendRequest(responseClass, ++tryStartCount);
            }
            throw e;
        }
        catch (Exception e) {
            throw new SignitException(e);
        }
    }

    public <T extends AbstractSignitResponse> T execute(Class<T> response) throws SignitException {
        if (response == null) {
            return null;
        }
        if (!(AUTH.get().hasAccessTokenType() && AUTH.get().hasAppId() && AUTH.get().hasSecretKey())) {
            throw new SignitException("\u8bf7\u5b8c\u5584\u5f00\u53d1\u8005\u4fe1\u606f");
        }
        HTTP_CLIENT.get().withAuth(AUTH.get());
        if (!AUTH.get().hasAccessToken()) {
            this.getOauthData(AUTH.get().getAppId(), AUTH.get().getSecretKey(), AUTH.get().getAccessTokenType(), true);
        }
        return (T)((AbstractSignitResponse)this.retrySendGetRequest(response, 1));
    }

    private <T> T retrySendGetRequest(Class<T> responseClass, int tryStartCount) throws SignitException {
        if (tryStartCount > 3) {
            throw new SignitException("\u8bf7\u6838\u5b9e\u5f00\u53d1\u8005\u8d26\u6237\u6570\u636e\u662f\u5426\u65e0\u8bef");
        }
        try {
            return HTTP_CLIENT.get().withAuth(AUTH.get()).withGetParam("access_token", AUTH.get().getAccessToken()).get(BASE_URL.get()).AsObject(responseClass);
        }
        catch (SignitException e) {
            if ("invalid_token".equals(e.getMessage())) {
                this.getOauthData(AUTH.get().getAppId(), AUTH.get().getSecretKey(), AUTH.get().getAccessTokenType(), true);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    return this.retrySendGetRequest(responseClass, ++tryStartCount);
                }
                return this.retrySendGetRequest(responseClass, ++tryStartCount);
            }
            throw e;
        }
        catch (Exception e) {
            throw new SignitException(e);
        }
    }

    public static boolean verify(String signitSignature, String appId, HmacSignatureBuilder builder) {
        if (builder == null || appId == null || signitSignature == null) {
            return false;
        }
        String selfBuiltHmac = builder.getDefaultAlgorithm() + " " + appId + ":" + builder.buildAsBase64();
        return selfBuiltHmac.equals(signitSignature);
    }

    public static boolean verify(String appId, String appSecretKey, byte[] body, HttpServletRequest request) throws IOException {
        HmacSignatureBuilder builder = new HmacSignatureBuilder();
        String signitSignature = request.getHeader("X-Signit-Signature");
        builder.scheme(request.getHeader("X-Signit-Scheme")).apiKey(appId).apiSecret(appSecretKey.getBytes()).method(request.getMethod().toUpperCase()).payload(body).contentType(request.getContentType()).host(Validator.isEmpty(request.getHeader("X-Signit-Host")) ? "" : request.getHeader("X-Signit-Host")).resource(Validator.isEmpty(request.getHeader("X-Signit-Resource")) ? "" : request.getHeader("X-Signit-Resource")).nonce(Validator.isEmpty(request.getHeader("X-Signit-Nonce")) ? "" : request.getHeader("X-Signit-Nonce")).date(Validator.isEmpty(request.getHeader("X-Signit-Date")) ? "" : request.getHeader("X-Signit-Date"));
        String selfBuiltHmac = builder.getDefaultAlgorithm() + " " + appId + ":" + builder.buildAsBase64();
        return selfBuiltHmac.equals(signitSignature);
    }
}

