/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.http;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.http.AbstractHttpRequest;
import cn.signit.sdk.http.Authentication;
import cn.signit.sdk.http.HttpGetRequest;
import cn.signit.sdk.http.HttpPostRequest;
import cn.signit.sdk.util.FastjsonDecoder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HttpClient {
    private Authentication auth;
    private Map<String, String> getParams;
    private Map<String, Serializable> postFields;
    private AbstractHttpRequest request;
    private Object object;

    public HttpClient withAuth(Authentication auth) {
        this.auth = auth;
        return this;
    }

    public HttpClient withGetParam(String key, String value) {
        if (this.getParams == null) {
            this.getParams = new HashMap<String, String>();
        }
        this.getParams.put(key, value);
        return this;
    }

    public HttpClient withGetParams(Map<String, String> params) {
        this.getParams = params;
        return this;
    }

    public HttpClient withPostField(String key, Serializable value) {
        if (this.postFields == null) {
            this.postFields = new HashMap<String, Serializable>();
        }
        this.postFields.put(key, value);
        return this;
    }

    public HttpClient withPostFields(Map<String, Serializable> fields) {
        this.postFields = fields;
        return this;
    }

    public HttpClient withPostObject(Object object) {
        this.object = object;
        return this;
    }

    public String getLastResponse() {
        if (this.request == null) {
            return null;
        }
        return this.request.getResponseBody();
    }

    public Integer getLastResponseCode() {
        if (this.request == null) {
            return null;
        }
        return this.request.getResponseCode();
    }

    private void validate(JSONObject json) throws SignitException {
        if (json.containsKey((Object)"error")) {
            try {
                String error = json.getString("error");
                throw new SignitException(error, this.getLastResponseCode(), null);
            }
            catch (JSONException ex) {
                throw new SignitException((Exception)((Object)ex));
            }
        }
    }

    private void reset() {
        this.auth = null;
        this.getParams = null;
        this.postFields = null;
        this.request = null;
    }

    public JSONObject asJson() throws SignitException {
        JSONObject json = null;
        String response = this.getLastResponse();
        try {
            json = JSON.parseObject((String)response);
        }
        catch (JSONException e) {
            throw new SignitException((Exception)((Object)e));
        }
        finally {
            this.reset();
        }
        return json;
    }

    public <T> T AsObject(Class<T> clazz) throws SignitException {
        String response = this.getLastResponse();
        T o = null;
        try {
            JSONObject json = JSON.parseObject((String)response);
            if (json.containsKey((Object)"error")) {
                throw new SignitException(json.getString("error"));
            }
            if (json.containsKey((Object)"errorWsid")) {
                throw new SignitException(response);
            }
            o = FastjsonDecoder.decodeAsBean(response, clazz);
        }
        catch (JSONException e) {
            throw new SignitException((Exception)((Object)e));
        }
        finally {
            this.reset();
        }
        if (o == null) {
            return null;
        }
        return o;
    }

    public int asHttpCode() throws SignitException {
        Integer code = this.getLastResponseCode();
        if (code == null) {
            throw new SignitException("No request performed");
        }
        if (code >= 200 && code < 300) {
            this.reset();
            return code;
        }
        throw new SignitException("HTTP Code " + code);
    }

    public HttpClient get(String url) throws SignitException {
        this.request = new HttpGetRequest(url, this.getParams, this.auth);
        this.request.doRequest();
        return this;
    }

    public HttpClient post(String url) throws SignitException {
        url = url + "?access_token=" + this.auth.getAccessToken();
        this.request = new HttpPostRequest(url, this.object, this.auth);
        this.request.doRequest();
        return this;
    }
}

