package cn.signit.sdk.type;

/**
 * 基于文件头描述源文件真实类型.
 *
 * @since 2.0.0
 */
public enum FileType {
    /**
     * JPEG.
     */
    JPEG,

    /**
     * JPG.
     */
    JPG,

    /**
     * JPE.
     */
    JPE,

    /**
     * PNG.
     */
    PNG,

    /**
     * GIF.
     */
    GIF,

    /**
     * TIFF.
     */
    TIFF,

    /**
     * Windows Bitmap.
     */
    BMP,

    /**
     * CAD.
     */
    DWG,

    /**
     * Adobe Photoshop.
     */
    PSD,

    /**
     * Rich Text Format.
     */
    RTF,

    /**
     * XML.
     */
    XML,

    /**
     * HTML.
     */
    HTML,

    /**
     * Email [thorough only].
     */
    EML,

    /**
     * Outlook Express.
     */
    DBX,

    /**
     * Outlook (pst).
     */
    PST,

    /**
     * MS 2003 Word/Excel/PointPower.
     */
    MS_2003,

    /**
     * MS 2007 and later Archive.MS Word/Excel/PointPower. （docx,pptx,xlsx）
     */
    MS_2007,

    /**
     * MS Access.
     */
    MDB,

    /**
     * WordPerfect.
     */
    WPD,

    /**
     * Postscript.
     */
    EPS,

    /**
     * Adobe Acrobat.
     */
    PDF,

    /**
     * Quicken.
     */
    QDF,

    /**
     * Windows Password.
     */
    PWL,

    /**
     * ZIP Archive. （docx,pptx,xlsx）
     */
    ZIP,

    /**
     * RAR Archive.
     */
    RAR,

    /**
     * Wave.
     */
    WAV,
    /**
     * AVI.
     */
    AVI,

    /**
     * Real Audio.
     */
    RAM,

    /**
     * Real Media.
     */
    RM,

    /**
     * MPEG (mpg).
     */
    MPG,

    /**
     * Quicktime.
     */
    MOV,

    /**
     * Windows Media.
     */
    ASF,

    /**
     * MIDI.
     */
    MID;

}
