/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.util;

import cn.signit.sdk.pojo.Builder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListBuilder {
    public static <O> List<O> buildList(List<? extends Builder<O>> builders) {
        ArrayList<O> result = new ArrayList<O>();
        for (Builder<O> builder : builders) {
            if (builder == null) continue;
            result.add(builder.build());
        }
        return result;
    }

    public static <O> List<O> buildList(Builder<O> ... builders) {
        if (builders != null) {
            return ListBuilder.buildList(Arrays.asList(builders));
        }
        return Collections.emptyList();
    }
}

