/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.util;

import cn.signit.sdk.type.NamingStyle;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

public final class FastjsonEncoder {
    private FastjsonEncoder() {
    }

    private static SerializeConfig initConfig(NamingStyle namingStyle) {
        SerializeConfig config = SerializeConfig.getGlobalInstance();
        String classNotFoundWarn = "[WARN] \u60a8\u5f53\u524d\u4f7f\u7528\u7684fastjson\u7248\u672c\u8f83\u4f4e\uff0c\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u5b57\u6bb5\u547d\u540d\u98ce\u683c\uff08\u5373\uff1acom.alibaba.fastjson.PropertyNamingStrategy \u4e0d\u5b58\u5728\uff09\u6765\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c\uff0c\u5982\u679c\u60a8\u8bbe\u7f6e\u4e86[" + NamingStyle.class.getName() + "]\uff0c\u5219\u8be5\u8bbe\u7f6e\u5c06\u4e0d\u4f1a\u8d77\u6548\uff0cfastjson\u5c06\u4f7f\u7528\u9ed8\u8ba4\u547d\u540d\u98ce\u683c\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c\uff0c\u5982\u9700\u81ea\u5b9a\u4e49\u5e8f\u5217\u5316\u5b57\u6bb5\u547d\u540d\u98ce\u683c\uff0c" + "\u8bf7\u4f7f\u7528fastjson 1.2.15+\u7248\u672c";
        try {
            if (null != Class.forName("com.alibaba.fastjson.PropertyNamingStrategy")) {
                config = FastjsonEncoder.configNamingStrategy(config, namingStyle);
            } else {
                System.err.println(classNotFoundWarn);
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println(classNotFoundWarn);
        }
        return config;
    }

    public static String encodeAsString(Object obj, NamingStyle namingStyle, boolean useUnicode) {
        SerializeConfig config = FastjsonEncoder.initConfig(namingStyle);
        if (useUnicode) {
            return JSON.toJSONString(obj, config, SerializerFeature.BrowserCompatible, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.NotWriteDefaultValue);
        }
        return JSON.toJSONString(obj, config, new SerializerFeature[0]);
    }

    public static String encodeAsString(Object obj, NamingStyle namingStyle) {
        return FastjsonEncoder.encodeAsString(obj, namingStyle, true);
    }

    public static String encodeAsString(Object obj, boolean useUnicode) {
        return FastjsonEncoder.encodeAsString(obj, NamingStyle.CAMEL, useUnicode);
    }

    public static String encodeAsString(Object obj) {
        return FastjsonEncoder.encodeAsString(obj, NamingStyle.CAMEL, true);
    }

    private static SerializeConfig configNamingStrategy(SerializeConfig config, NamingStyle namingStyle) {
        switch (namingStyle) {
            case CAMEL: {
                config.propertyNamingStrategy = PropertyNamingStrategy.CamelCase;
                return config;
            }
            case SNAKE: {
                config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
                return config;
            }
            case PASCAL: {
                config.propertyNamingStrategy = PropertyNamingStrategy.PascalCase;
                return config;
            }
            case KEBAB: {
                config.propertyNamingStrategy = PropertyNamingStrategy.KebabCase;
                return config;
            }
        }
        config.propertyNamingStrategy = PropertyNamingStrategy.CamelCase;
        return config;
    }
}

