/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.type;

public enum WebhookEventType {
    UNKNOWN("unSupportEvent", "\u4e0d\u652f\u6301\u7684\u4e8b\u4ef6"),
    QUICK_SIGN_COMPLETED("quickSignCompleted", "\u5feb\u6377\u7b7e\u7f72\u5b8c\u6210"),
    PERSON_VERIFICATION_SUBMITTED("personVerificationSubmitted", "\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u63d0\u4ea4"),
    PERSON_VERIFICATION_COMPLETED("personVerificationCompleted", "\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u5b8c\u6210"),
    ENTERPRISE_VERIFICATION_SUBMITTED("enterpriseVerificationSubmitted", "\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u63d0\u4ea4"),
    ENTERPRISE_VERIFICATION_PRIMARY_COMPLETED("enterpriseVerificationPrimaryCompleted", " \u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u521d\u7ea7\u5b8c\u6210"),
    ENTERPRISE_VERIFICATION_PAID("enterpriseVerificationPaid", "\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5df2\u6253\u6b3e"),
    ENTERPRISE_VERIFICATION_COMPLETED("enterpriseVerificationCompleted", "\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5b8c\u6210"),
    ENVELOPE_STARTED("envelopeStarted", "\u4fe1\u5c01\u6d41\u7a0b\u542f\u52a8"),
    PARTICIPANT_REJECTED("participantRejected", "\u53c2\u4e0e\u8005\u62d2\u7edd"),
    PARTICIPANT_CONFIRMED("participantConfirmed", "\u53c2\u4e0e\u8005\u786e\u8ba4"),
    ENVELOPE_COMPLETED("envelopeCompleted", "\u4fe1\u5c01\u6d41\u7a0b\u5b8c\u6210"),
    PARTICIPANT_HANDLING("ParticipantHandling", "\u53c2\u4e0e\u8005\u6b63\u5728\u5904\u7406\u4fe1\u5c01");

    private String event;
    private String description;

    private WebhookEventType(String event, String description) {
        this.event = event;
        this.description = description;
    }

    public static WebhookEventType parse(String event) {
        for (WebhookEventType val : WebhookEventType.values()) {
            if (!val.name().equalsIgnoreCase(event) && !val.getEvent().equalsIgnoreCase(event)) continue;
            return val;
        }
        return UNKNOWN;
    }

    public static boolean support(String[] events) {
        if (events == null || events.length == 0) {
            return false;
        }
        for (String val : events) {
            if (WebhookEventType.support(val)) continue;
            return false;
        }
        return true;
    }

    public static boolean support(String event) {
        return WebhookEventType.parse(event) != UNKNOWN;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

