/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.util;

import cn.signit.sdk.type.NamingStyle;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

public final class FastjsonEncoder {
    public static String encodeAsString(Object obj, NamingStyle namingStyle, boolean useUnicode) {
        SerializeConfig config = SerializeConfig.getGlobalInstance();
        config.propertyNamingStrategy = FastjsonEncoder.getNamingStrategy(namingStyle);
        if (useUnicode) {
            return JSON.toJSONString((Object)obj, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.NotWriteDefaultValue});
        }
        return JSON.toJSONString((Object)obj, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String encodeAsString(Object obj, NamingStyle namingStyle) {
        return FastjsonEncoder.encodeAsString(obj, namingStyle, true);
    }

    public static String encodeAsString(Object obj, boolean useUnicode) {
        return FastjsonEncoder.encodeAsString(obj, NamingStyle.CAMEL, useUnicode);
    }

    public static String encodeAsString(Object obj) {
        return FastjsonEncoder.encodeAsString(obj, NamingStyle.CAMEL, true);
    }

    private static PropertyNamingStrategy getNamingStrategy(NamingStyle namingStyle) {
        switch (namingStyle) {
            case CAMEL: {
                return PropertyNamingStrategy.CamelCase;
            }
            case SNAKE: {
                return PropertyNamingStrategy.SnakeCase;
            }
            case PASCAL: {
                return PropertyNamingStrategy.PascalCase;
            }
            case KEBAB: {
                return PropertyNamingStrategy.KebabCase;
            }
        }
        return PropertyNamingStrategy.CamelCase;
    }
}

