/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.http;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.type.TokenType;
import cn.signit.sdk.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;

public class Authentication {
    private String appId = new String();
    private String secretKey = new String();
    private String accessToken = new String();
    private TokenType accessTokenType;
    private String cacheTokenDir = System.getProperty("java.io.tmpdir");

    public Authentication() {
    }

    public Authentication(String apiKey, String secretKey) {
        this(apiKey, secretKey, TokenType.CLIENT_CREDENTIALS);
    }

    public Authentication(String apiKey, String secretKey, TokenType authenticationType) {
        this.appId = Validator.notNull(apiKey, "appId\u4e0d\u53ef\u4e3a\u7a7a");
        this.secretKey = Validator.notNull(secretKey, "secretKey\u4e0d\u53ef\u4e3a\u7a7a");
        this.accessTokenType = Validator.notNull(authenticationType, "tokentype\u4e0d\u53ef\u4e3a\u7a7a");
        this.initFromLocal();
    }

    private void initFromLocal() {
        String filename;
        if ((this.accessToken == null || this.accessToken.trim().equals("")) && (filename = this.generateCachedTokenFilename()) != null) {
            try {
                File file = new File(filename);
                FileInputStream fis = new FileInputStream(file);
                byte[] datas = new byte[fis.available()];
                fis.read(datas);
                String keyBase64 = "9ijhWI+0fNf0RSRJxgPt7q2zciyGVxmcco95I+gKids=";
                SecretKeySpec key = new SecretKeySpec(Base64.decodeBase64((String)keyBase64), "AES");
                Cipher cipher = null;
                cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, key);
                byte[] decodeResult = cipher.doFinal(datas);
                this.accessToken = new String(decodeResult);
                fis.close();
            }
            catch (NoSuchAlgorithmException e) {
                return;
            }
            catch (NoSuchPaddingException e) {
                return;
            }
            catch (IllegalBlockSizeException e) {
                return;
            }
            catch (BadPaddingException e) {
                return;
            }
            catch (InvalidKeyException e) {
                return;
            }
            catch (IOException e) {
                return;
            }
        }
    }

    private String generateCachedTokenFilename() {
        if (this.appId != null && this.secretKey != null && this.accessTokenType != null) {
            StringBuffer sb = new StringBuffer();
            sb = sb.append(this.appId).append(",").append(this.secretKey).append(",").append((Object)this.accessTokenType);
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(sb.toString().getBytes());
                return this.cacheTokenDir.concat(Base64.encodeBase64String((byte[])md5.digest()));
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }
        return null;
    }

    private void cacheToLocal() {
        String filename;
        if (this.accessToken != null && !this.accessToken.trim().equals("") && (filename = this.generateCachedTokenFilename()) != null) {
            try {
                File file = new File(filename);
                FileOutputStream fos = new FileOutputStream(file);
                byte[] datas = this.accessToken.getBytes();
                String keyBase64 = "9ijhWI+0fNf0RSRJxgPt7q2zciyGVxmcco95I+gKids=";
                SecretKeySpec key = new SecretKeySpec(Base64.decodeBase64((String)keyBase64), "AES");
                Cipher cipher = null;
                cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, key);
                byte[] decodeResult = cipher.doFinal(datas);
                fos.write(decodeResult);
                fos.flush();
                fos.close();
            }
            catch (NoSuchAlgorithmException e) {
                return;
            }
            catch (NoSuchPaddingException e) {
                return;
            }
            catch (IllegalBlockSizeException e) {
                return;
            }
            catch (BadPaddingException e) {
                return;
            }
            catch (InvalidKeyException e) {
                return;
            }
            catch (IOException e) {
                return;
            }
        }
    }

    public Authentication(Authentication clone) throws SignitException {
        if (clone.hasAppId()) {
            this.setAppId(clone.getAppId());
        }
        if (clone.hasAccessToken()) {
            this.setAccessToken(clone.getAccessToken());
        }
        if (clone.hasSecretKey()) {
            this.setSecretKey(clone.getSecretKey());
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public Authentication setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public boolean hasAppId() {
        return !"".equals(this.appId);
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public Authentication setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public boolean hasSecretKey() {
        return !"".equals(this.secretKey);
    }

    public String getAccessToken() {
        this.initFromLocal();
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        this.cacheToLocal();
    }

    public TokenType getAccessTokenType() {
        return this.accessTokenType;
    }

    public void setAccessTokenType(TokenType accessTokenType) {
        this.accessTokenType = accessTokenType;
    }

    public boolean hasAccessTokenType() {
        return !"".equals((Object)this.accessTokenType) && !"".equals((Object)this.accessTokenType);
    }

    public boolean hasAccessToken() {
        this.initFromLocal();
        return !"".equals(this.accessToken) && !"".equals(this.accessToken);
    }

    public void authenticate(HttpURLConnection httpConn, String url) {
        String authorization = null;
        if (this.hasAppId()) {
            String appid = this.getAppId() + ":";
            authorization = "Basic " + DatatypeConverter.printBase64Binary((byte[])appid.getBytes()).trim();
        }
        if (authorization != null) {
            httpConn.setRequestProperty("authorization", authorization);
        }
    }
}

