/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.util;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Validator {
    private Validator() {
    }

    public static void notFalse(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void notFalse(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void notFalse(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void isFalse(boolean expression, Object errorMessage) {
        if (expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void isFalse(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void isTrue(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void isTrue(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void notTrue(boolean expression) {
        if (expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void notTrue(boolean expression, Object errorMessage) {
        if (expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void notTrue(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> void isNull(T reference) {
        if (reference != null) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> void isNull(T reference, Object errorMessage) {
        if (reference != null) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static <T> void isNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference != null) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T notNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T notNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T notNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static Collection<?> notEmpty(Collection<?> collection) {
        if (Validator.isEmpty(collection)) {
            throw new IllegalArgumentException();
        }
        return collection;
    }

    public static Collection<?> notEmpty(Collection<?> collection, Object errorMessage) {
        if (Validator.isEmpty(collection)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return collection;
    }

    public static Collection<?> notEmpty(Collection<?> collection, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Validator.isEmpty(collection)) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return collection;
    }

    public static Map<?, ?> notEmpty(Map<?, ?> map) {
        if (Validator.isEmpty(map)) {
            throw new IllegalArgumentException();
        }
        return map;
    }

    public static Map<?, ?> notEmpty(Map<?, ?> map, Object errorMessage) {
        if (Validator.isEmpty(map)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return map;
    }

    public static Map<?, ?> notEmpty(Map<?, ?> map, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Validator.isEmpty(map)) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return map;
    }

    public static <T> T[] notEmpty(T[] arr) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException();
        }
        return arr;
    }

    public static <T> T[] notEmpty(T[] arr, Object errorMessage) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return arr;
    }

    public static <T> T[] notEmpty(T[] arr, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return arr;
    }

    public static byte[] notEmpty(byte[] arr) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException();
        }
        return arr;
    }

    public static byte[] notEmpty(byte[] arr, Object errorMessage) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return arr;
    }

    public static byte[] notEmpty(byte[] arr, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return arr;
    }

    public static int[] notEmpty(int[] arr) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException();
        }
        return arr;
    }

    public static int[] notEmpty(int[] arr, Object errorMessage) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return arr;
    }

    public static int[] notEmpty(int[] arr, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Validator.isEmpty(arr)) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return arr;
    }

    public static <T> boolean isEmail(T reference) {
        return Validator.isEmail(reference, "^[a-zA-Z0-9_\\.\\-\\+]+@[a-zA-Z0-9_\\.\\-\\+]+\\.[a-zA-Z]{2,5}$");
    }

    public static <T> boolean isEmail(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isEmail(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isChinaCellphone(T reference) {
        return Validator.isChinaCellphone(reference, "^[1][3-8]\\d{9}$|^([6|9])\\d{7}$|^[0][9]\\d{8}$|^[6]([8|6])\\d{5}$");
    }

    public static <T> boolean isChinaCellphone(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isChinaCellphone(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isIntegerNumber(T reference) {
        return Validator.isIntegerNumber(reference, "^(-|\\+)?\\d+$");
    }

    public static <T> boolean isIntegerNumber(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isIntegerNumber(reference);
        }
        return Validator.match(regex, reference);
    }

    public static boolean isEmpty(CharSequence string) {
        return string == null || string.length() <= 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static boolean isEmpty(int[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static boolean isEmpty(long[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static boolean isEmpty(float[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static boolean isEmpty(double[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static boolean isEmpty(short[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static boolean isEmpty(boolean[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static boolean isEmpty(byte[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static boolean isEmpty(char[] arr) {
        return arr == null || arr.length <= 0;
    }

    public static <T> boolean isIP(T reference) {
        return Validator.isIPv4(reference) || Validator.isIPv6(reference);
    }

    public static <T> boolean isIP(T reference, String regex) {
        return Validator.isIPv4(reference, regex) || Validator.isIPv6(reference, regex);
    }

    public static <T> boolean isIPv4(T reference) {
        return Validator.isIPv4(reference, "^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    }

    public static <T> boolean isIPv4(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isIPv4(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isIPv6(T reference) {
        return Validator.isIPv6(reference, "^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$") || Validator.isIPv6(reference, "^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    }

    public static <T> boolean isIPv6(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isIPv6(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isCommonIDcard(T reference) {
        return Validator.isCommonIDcard(reference, "^[0-9a-zA-Z]{6,}$");
    }

    public static <T> boolean isCommonIDcard(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isCommonIDcard(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isChinaIDcard(T reference) {
        return Validator.isChinaIDcard(reference, "^[1-9]\\d{5}[1-9]\\d{3}((0[1-9])||(1[0-2]))((0[1-9])||(1\\d)||(2\\d)||(3[0-1]))\\d{3}([0-9]||X)$") || Validator.isChinaIDcard(reference, "^[1-9]\\d{7}((0[1-9])||(1[0-2]))((0[1-9])||(1\\d)||(2\\d)||(3[0-1]))\\d{3}$") || Validator.isChinaIDcard(reference, "^[A-Z]{1,2}[0-9]{6}([0-9A])$") || Validator.isChinaIDcard(reference, "^[157][0-9]{6}([0-9])$") || Validator.isChinaIDcard(reference, "^[A-Z][0-9]{9}$");
    }

    public static <T> boolean isChinaIDcard(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isChinaIDcard(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isPassword(T reference) {
        return Validator.isPassword(reference, "^(?![0-9]*$)(?![a-zA-Z]*$)(?![!\\[\\]\"#$%&'()*+,\\-./:;<=>?@^_`{|}~]*$).{6,50}$");
    }

    public static <T> boolean isPassword(T reference, int minLen) {
        return Validator.isPassword(reference, "^(?![0-9]*$)(?![a-zA-Z]*$)(?![!\\[\\]\"#$%&'()*+,\\-./:;<=>?@^_`{|}~]*$)." + String.format("{%d,%d}$", minLen, 50));
    }

    public static <T> boolean isPassword(T reference, int minLen, int maxLen) {
        return Validator.isPassword(reference, "^(?![0-9]*$)(?![a-zA-Z]*$)(?![!\\[\\]\"#$%&'()*+,\\-./:;<=>?@^_`{|}~]*$)." + String.format("{%d,%d}$", minLen, maxLen));
    }

    public static <T> boolean isPassword(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isPassword(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isUrl(T reference) {
        return Validator.isUrl(reference, "^(?:https?|ftp?|sftp|file|gopher|news|nntp|telnet):///?[^\\s/$.?#].[^\\s]*$");
    }

    public static <T> boolean isUrl(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isUrl(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isMd5(T reference) {
        return Validator.isMd5(reference, "^[a-fA-F0-9]{32}$");
    }

    public static <T> boolean isMd5(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isMd5(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isSha1(T reference) {
        return Validator.isSha1(reference, "^[a-fA-F0-9]{40}$");
    }

    public static <T> boolean isSha1(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isSha1(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isWsid(T reference) {
        return Validator.isWsid(reference, "^WSID_[A-Z]{4}_[a-fA-F0-9]{32}$");
    }

    public static <T> boolean isWsid(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isWsid(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isBase64(T reference) {
        return Validator.isBase64(reference, "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
    }

    public static <T> boolean isBase64(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isBase64(reference);
        }
        return Validator.match(regex, reference);
    }

    public static <T> boolean isHex(T reference) {
        return Validator.isHex(reference, "[a-fA-F0-9]+");
    }

    public static <T> boolean isHex(T reference, String regex) {
        if (reference == null) {
            return false;
        }
        if (regex == null) {
            return Validator.isHex(reference);
        }
        return Validator.match(regex, reference);
    }

    private static <T> boolean match(String regex, T reference) {
        String input = null;
        if (regex == null || reference == null) {
            return false;
        }
        input = reference instanceof String ? (String)reference : (reference instanceof byte[] ? new String((byte[])reference) : String.valueOf(reference));
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        return matcher.lookingAt();
    }

    public static final class RegexType {
        public static final String EMAIL = "^[a-zA-Z0-9_\\.\\-\\+]+@[a-zA-Z0-9_\\.\\-\\+]+\\.[a-zA-Z]{2,5}$";
        public static final String CHINA_CELLPHONE = "^[1][3-8]\\d{9}$|^([6|9])\\d{7}$|^[0][9]\\d{8}$|^[6]([8|6])\\d{5}$";
        public static final String INTEGER_NUMBER = "^(-|\\+)?\\d+$";
        public static final String IPV4 = "^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$";
        public static final String IPV6_STD = "^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$";
        public static final String IPV6_HEX_COMPRESSED = "^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$";
        public static final String COMMON_ID_CARD = "^[0-9a-zA-Z]{6,}$";
        public static final String CHINA_MAINLAND_ID_CARD_15 = "^[1-9]\\d{7}((0[1-9])||(1[0-2]))((0[1-9])||(1\\d)||(2\\d)||(3[0-1]))\\d{3}$";
        public static final String CHINA_MAINLAND_ID_CARD_18 = "^[1-9]\\d{5}[1-9]\\d{3}((0[1-9])||(1[0-2]))((0[1-9])||(1\\d)||(2\\d)||(3[0-1]))\\d{3}([0-9]||X)$";
        public static final String CHINA_HK_ID_CARD = "^[A-Z]{1,2}[0-9]{6}([0-9A])$";
        public static final String CHINA_MO_ID_CARD = "^[157][0-9]{6}([0-9])$";
        public static final String CHINA_TW_ID_CARD = "^[A-Z][0-9]{9}$";
        private static final String PASSWORD_BASE = "^(?![0-9]*$)(?![a-zA-Z]*$)(?![!\\[\\]\"#$%&'()*+,\\-./:;<=>?@^_`{|}~]*$).";
        private static final String PASSWORD_LEN_TEMP = "{%d,%d}$";
        public static final String PASSWORD = "^(?![0-9]*$)(?![a-zA-Z]*$)(?![!\\[\\]\"#$%&'()*+,\\-./:;<=>?@^_`{|}~]*$).{6,50}$";
        public static final String URL = "^(?:https?|ftp?|sftp|file|gopher|news|nntp|telnet):///?[^\\s/$.?#].[^\\s]*$";
        public static final String MD5 = "^[a-fA-F0-9]{32}$";
        public static final String SHA1 = "^[a-fA-F0-9]{40}$";
        public static final String WSID = "^WSID_[A-Z]{4}_[a-fA-F0-9]{32}$";
        public static final String BASE64 = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        public static final String HEX = "[a-fA-F0-9]+";

        private RegexType() {
        }
    }
}

