/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.pojo;

import cn.signit.sdk.pojo.FileData;
import cn.signit.sdk.pojo.Signer;
import cn.signit.sdk.type.AcceptDataType;
import java.util.List;

public class SignatureRequest {
    private FileData fileData;
    private AcceptDataType acceptDataType;
    private String returnUrl;
    private String customTag;
    private List<Signer> signDetails;

    public SignatureRequest() {
    }

    public SignatureRequest(FileData fileData, AcceptDataType acceptDataType, String returnUrl, String customTag, List<Signer> signDetails) {
        this.fileData = fileData;
        this.acceptDataType = acceptDataType;
        this.returnUrl = returnUrl;
        this.customTag = customTag;
        this.signDetails = signDetails;
    }

    public static SignatureRequestBuilder builder() {
        return new SignatureRequestBuilder();
    }

    public FileData getFileData() {
        return this.fileData;
    }

    public void setFileData(FileData fileData) {
        this.fileData = fileData;
    }

    public AcceptDataType getAcceptDataType() {
        return this.acceptDataType;
    }

    public void setAcceptDataType(AcceptDataType acceptDataType) {
        this.acceptDataType = acceptDataType;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getCustomTag() {
        return this.customTag;
    }

    public void setCustomTag(String customTag) {
        this.customTag = customTag;
    }

    public List<Signer> getSignDetails() {
        return this.signDetails;
    }

    public void setSignDetails(List<Signer> signDetails) {
        this.signDetails = signDetails;
    }

    public static class SignatureRequestBuilder {
        private FileData fileData;
        private AcceptDataType acceptDataType;
        private String returnUrl;
        private String customTag;
        private List<Signer> signDetails;

        public SignatureRequestBuilder withFileData(FileData fileData) {
            this.fileData = fileData;
            return this;
        }

        public SignatureRequestBuilder withAcceptDataType(AcceptDataType acceptDataType) {
            this.acceptDataType = acceptDataType;
            return this;
        }

        public SignatureRequestBuilder withFileData(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public SignatureRequestBuilder withCustomTag(String customTag) {
            this.customTag = customTag;
            return this;
        }

        public SignatureRequestBuilder withSignDetails(List<Signer> signDetails) {
            this.signDetails = signDetails;
            return this;
        }

        public SignatureRequest build() {
            return new SignatureRequest(this.fileData, this.acceptDataType, this.returnUrl, this.customTag, this.signDetails);
        }
    }
}

