/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.http;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.type.TokenType;
import cn.signit.sdk.util.Validator;
import java.net.HttpURLConnection;
import javax.xml.bind.DatatypeConverter;

public class Authentication {
    private String appId = new String();
    private String secretKey = new String();
    private String accessToken = new String();
    private TokenType accessTokenType;

    public Authentication() {
    }

    public Authentication(String apiKey, String secretKey) {
        this(apiKey, secretKey, TokenType.CLIENT_CREDENTIALS);
    }

    public Authentication(String apiKey, String secretKey, TokenType authenticationType) {
        this.appId = Validator.notNull(apiKey, "appId\u4e0d\u53ef\u4e3a\u7a7a");
        this.secretKey = Validator.notNull(secretKey, "secretKey\u4e0d\u53ef\u4e3a\u7a7a");
        this.accessTokenType = Validator.notNull(authenticationType, "tokentype\u4e0d\u53ef\u4e3a\u7a7a");
    }

    public Authentication(Authentication clone) throws SignitException {
        if (clone.hasAppId()) {
            this.setAppId(clone.getAppId());
        }
        if (clone.hasAccessToken()) {
            this.setAccessToken(clone.getAccessToken());
        }
        if (clone.hasSecretKey()) {
            this.setSecretKey(clone.getSecretKey());
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public Authentication setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public boolean hasAppId() {
        return !"".equals(this.appId);
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public Authentication setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public boolean hasSecretKey() {
        return !"".equals(this.secretKey);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TokenType getAccessTokenType() {
        return this.accessTokenType;
    }

    public void setAccessTokenType(TokenType accessTokenType) {
        this.accessTokenType = accessTokenType;
    }

    public boolean hasAccessTokenType() {
        return !"".equals((Object)this.accessTokenType) && !"".equals((Object)this.accessTokenType);
    }

    public boolean hasAccessToken() {
        return !"".equals(this.accessToken) && !"".equals(this.accessToken);
    }

    public void authenticate(HttpURLConnection httpConn, String url) {
        String authorization = null;
        if (this.hasAppId()) {
            String appid = this.getAppId() + ":";
            authorization = "Basic " + DatatypeConverter.printBase64Binary((byte[])appid.getBytes()).trim();
        }
        if (authorization != null) {
            httpConn.setRequestProperty("authorization", authorization);
        }
    }
}

