/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk.http;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.http.Authentication;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.Scanner;

public abstract class AbstractHttpRequest {
    protected String url;
    protected static int READ_TIMEOUT = 20000;
    protected static int CONNECT_TIMEOUT = 10000;
    public static final String USER_AGENT = "Signit HTTP";
    protected Integer lastHttpStatusCode;
    protected InputStream lastResponseStream;
    protected Authentication auth;
    public static final String DEFAULT_ENCODING = "UTF-8";

    public void doRequest() throws SignitException {
        HttpURLConnection connection;
        try {
            connection = this.getConnection();
            connection.setConnectTimeout(CONNECT_TIMEOUT);
            connection.setReadTimeout(READ_TIMEOUT);
        }
        catch (MalformedURLException e) {
            throw new SignitException(e);
        }
        catch (IOException e) {
            throw new SignitException(e);
        }
        try {
            this.lastHttpStatusCode = connection.getResponseCode();
            this.lastResponseStream = this.lastHttpStatusCode >= 200 && this.lastHttpStatusCode < 300 ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (Exception ex) {
            throw new SignitException(ex);
        }
    }

    public Integer getResponseCode() {
        return this.lastHttpStatusCode;
    }

    public String getResponseBody() {
        String responseStr = "";
        if (this.lastResponseStream != null) {
            Scanner s = new Scanner(this.lastResponseStream);
            s.useDelimiter("\\A");
            responseStr = s.hasNext() ? s.next() : "";
            s.close();
        }
        return responseStr;
    }

    abstract HttpURLConnection getConnection() throws SignitException, IOException;
}

