/*
 * Decompiled with CFR 0.152.
 */
package cn.signit.sdk;

import cn.signit.sdk.SignitException;
import cn.signit.sdk.http.Authentication;
import cn.signit.sdk.http.HttpClient;
import cn.signit.sdk.pojo.OauthData;
import cn.signit.sdk.pojo.SignatureRequest;
import cn.signit.sdk.pojo.SignatureResponse;
import cn.signit.sdk.pojo.WebhookData;
import cn.signit.sdk.type.TokenType;
import cn.signit.sdk.util.FastjsonDecoder;
import cn.signit.sdk.util.Validator;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class SignitClient {
    private Authentication auth;
    private HttpClient httpClient;
    private final int MAX_COUNT = 3;
    private final AtomicInteger count = new AtomicInteger(3);
    private final Pattern LEFT_QUOTATION = Pattern.compile("\"\\{");
    private final Pattern RIGHT_QUOTATION = Pattern.compile("\\}\"");
    private final Pattern BACKLASH_QUOTATION = Pattern.compile("\\\\\"");
    private String BASE_URL;
    private String OAUTH_TOKEN_URL;

    public SignitClient(Authentication auth) {
        this(auth, new HttpClient(), "https://open.signit.cn");
    }

    public SignitClient(Authentication auth, String url) {
        this(auth, new HttpClient(), url);
    }

    private SignitClient(Authentication auth, HttpClient httpClient, String url) {
        this.setUrl(url);
        this.auth = auth;
        this.httpClient = httpClient;
    }

    private void setUrl(String environmentUrl) {
        String tempUrl = environmentUrl == null || environmentUrl.trim().equals("") ? "https://open.signit.cn" : environmentUrl;
        this.BASE_URL = tempUrl + "/v1/open/signatures/quick-sign";
        this.OAUTH_TOKEN_URL = tempUrl + "/v1/oauth/oauth/token";
    }

    public SignitClient setEnvironmentUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public SignitClient setOauthUrl(String url) {
        this.BASE_URL = url;
        return this;
    }

    public SignitClient setSignUrl(String url) {
        this.BASE_URL = url;
        return this;
    }

    public SignatureResponse sendSignatureRequest(SignatureRequest request) throws SignitException, IOException {
        if (request == null) {
            return null;
        }
        if (!(this.auth.hasAccessTokenType() && this.auth.hasAppId() && this.auth.hasSecretKey())) {
            throw new SignitException("\u8bf7\u5b8c\u5584\u5f00\u53d1\u8005\u4fe1\u606f");
        }
        this.httpClient.withAuth(this.auth).withPostObject(request);
        this.getOauthData(this.auth.getAppId(), this.auth.getSecretKey(), this.auth.getAccessTokenType(), true);
        return this.retrySendRequest();
    }

    private SignatureResponse retrySendRequest() throws SignitException {
        if (this.count.decrementAndGet() <= -1) {
            throw new SignitException("\u8bf7\u6838\u5b9e\u5f00\u53d1\u8005\u8d26\u6237\u6570\u636e\u662f\u5426\u65e0\u8bef");
        }
        try {
            return this.httpClient.withAuth(this.auth).post(this.BASE_URL).AsObject(SignatureResponse.class);
        }
        catch (SignitException e) {
            if ("invalid_token".equals(e.getMessage())) {
                this.getOauthData(this.auth.getAppId(), this.auth.getSecretKey(), this.auth.getAccessTokenType(), true);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    return this.retrySendRequest();
                }
                return this.retrySendRequest();
            }
            throw e;
        }
        catch (Exception e) {
            throw new SignitException(e);
        }
    }

    public OauthData getOauthData(String apiKey, String secretKey, TokenType grantType, boolean autoSetRequestToken) throws SignitException {
        if (apiKey == null || secretKey == null) {
            throw new SignitException("\u8bf7\u5b8c\u5584\u5f00\u53d1\u8005\u8d26\u6237\u6570\u636e");
        }
        String response = this.httpClient.withAuth(this.auth).withGetParam("client_id", apiKey).withGetParam("client_secret", secretKey).withGetParam("grant_type", TokenType.CLIENT_CREDENTIALS.name().toLowerCase()).get(this.OAUTH_TOKEN_URL).getLastResponse();
        JSONObject data = JSON.parseObject(Validator.notNull(response, "\u8bf7\u6c42token\u6570\u636e\u5931\u8d25"));
        if (data != null && autoSetRequestToken) {
            this.auth.setAccessToken(Validator.notNull(data.getString("access_token"), "token\u83b7\u53d6\u5931\u8d25"));
        }
        return (OauthData)FastjsonDecoder.decodeAsBean(response, OauthData.class);
    }

    public WebhookData parseWebhookData(String webhook) {
        if (webhook == null || webhook.trim().length() <= 0) {
            return null;
        }
        webhook = this.LEFT_QUOTATION.matcher(webhook).replaceAll("{");
        webhook = this.RIGHT_QUOTATION.matcher(webhook).replaceAll("}");
        webhook = this.BACKLASH_QUOTATION.matcher(webhook).replaceAll("\"");
        return (WebhookData)FastjsonDecoder.decodeAsBean(webhook, WebhookData.class);
    }
}

