/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.scanner;

import cn.shellming.thrift.client.common.ThriftServiceSignature;
import cn.shellming.thrift.client.scanner.ThriftClientInvocationHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public class ThriftClientFactoryBean<T>
implements FactoryBean<T>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftClientFactoryBean.class);
    private String beanName;
    private Class<?> beanClass;
    private String beanClassName;
    private Class<?> serviceClass;
    private ThriftServiceSignature serviceSignature;
    private Class<?> clientClass;
    private Constructor<? extends TServiceClient> clientConstructor;

    public T getObject() throws Exception {
        if (this.beanClass.isInterface()) {
            LOGGER.info("Prepare to generate proxy for {} with JDK", (Object)this.beanClass.getName());
            ThriftClientInvocationHandler invocationHandler = new ThriftClientInvocationHandler(this.serviceSignature, this.clientClass, this.clientConstructor);
            return (T)Proxy.newProxyInstance(this.beanClass.getClassLoader(), new Class[]{this.beanClass}, (InvocationHandler)invocationHandler);
        }
        LOGGER.info("Prepare to generate proxy for {} with Cglib", (Object)this.beanClass.getName());
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(this.beanClass);
        enhancer.setNamingPolicy((NamingPolicy)SpringNamingPolicy.INSTANCE);
        enhancer.setUseFactory(true);
        MethodInterceptor callback = (target, method, args, methodProxy) -> methodProxy.invokeSuper(target, args);
        enhancer.setCallback((Callback)callback);
        return (T)enhancer.create();
    }

    public Class<?> getObjectType() {
        if (Objects.isNull(this.beanClass) && StringUtils.isBlank((CharSequence)this.beanName)) {
            LOGGER.warn("Bean class is not found");
            return null;
        }
        if (Objects.nonNull(this.beanClass)) {
            return this.beanClass;
        }
        if (StringUtils.isNotBlank((CharSequence)this.beanClassName)) {
            try {
                this.beanClass = Class.forName(this.beanClassName);
                return this.beanClass;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            LOGGER.warn("Bean class is not found");
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.info("Succeed to instantiate an instance of ThriftClientFactoryBean: {}", (Object)this);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public void setBeanClassName(String beanClassName) {
        this.beanClassName = beanClassName;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public ThriftServiceSignature getServiceSignature() {
        return this.serviceSignature;
    }

    public void setServiceSignature(ThriftServiceSignature serviceSignature) {
        this.serviceSignature = serviceSignature;
    }

    public Class<?> getClientClass() {
        return this.clientClass;
    }

    public void setClientClass(Class<?> clientClass) {
        this.clientClass = clientClass;
    }

    public Constructor<? extends TServiceClient> getClientConstructor() {
        return this.clientConstructor;
    }

    public void setClientConstructor(Constructor<? extends TServiceClient> clientConstructor) {
        this.clientConstructor = clientConstructor;
    }
}

