/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.scanner;

import cn.shellming.thrift.client.annotation.ThriftClient;
import cn.shellming.thrift.client.common.ThriftServiceSignature;
import cn.shellming.thrift.client.exception.ThriftClientConfigException;
import cn.shellming.thrift.client.exception.ThriftClientInstantiateException;
import cn.shellming.thrift.client.scanner.ThriftClientFactoryBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public final class ThriftClientBeanScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftClientBeanScanner.class);

    public ThriftClientBeanScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }

    protected void registerDefaultFilters() {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ThriftClient.class));
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set definitionHolders = super.doScan(basePackages);
        LOGGER.info("Packages scanned by thriftClientBeanDefinitionScanner is [{}]", (Object)StringUtils.join((Object[])basePackages, (String)", "));
        for (BeanDefinitionHolder definitionHolder : definitionHolders) {
            Constructor<? extends TServiceClient> constructor;
            Class<?> beanClass;
            GenericBeanDefinition definition = (GenericBeanDefinition)definitionHolder.getBeanDefinition();
            LOGGER.info("Scanned and found thrift client, bean {} assigned from {}", (Object)definitionHolder.getBeanName(), (Object)definition.getBeanClassName());
            try {
                beanClass = Class.forName(definition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            ThriftClient thriftClient = (ThriftClient)AnnotationUtils.findAnnotation(beanClass, ThriftClient.class);
            if (thriftClient == null) {
                LOGGER.warn("Thrift client is not found");
                continue;
            }
            String beanName = StringUtils.isNotBlank((CharSequence)thriftClient.value()) ? thriftClient.value() : (StringUtils.isNotBlank((CharSequence)thriftClient.name()) ? thriftClient.name() : StringUtils.uncapitalize((String)beanClass.getSimpleName()));
            definition.getPropertyValues().addPropertyValue("beanName", (Object)beanName);
            definition.getPropertyValues().addPropertyValue("beanClass", beanClass);
            definition.getPropertyValues().addPropertyValue("beanClassName", (Object)beanClass.getName());
            Class<?> referClass = thriftClient.refer();
            definition.getPropertyValues().addPropertyValue("serviceClass", referClass);
            ThriftServiceSignature serviceSignature = new ThriftServiceSignature(thriftClient.serviceId(), thriftClient.refer(), thriftClient.version());
            Class<? extends TServiceClient> clientClass = this.getClientClassFromAnnotation(beanClass);
            try {
                constructor = clientClass.getConstructor(TProtocol.class);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ThriftClientInstantiateException("Failed to get constructor with args TProtocol", e);
            }
            definition.getPropertyValues().addPropertyValue("serviceSignature", (Object)serviceSignature);
            definition.getPropertyValues().addPropertyValue("clientClass", clientClass);
            definition.getPropertyValues().addPropertyValue("clientConstructor", constructor);
            definition.setBeanClass(ThriftClientFactoryBean.class);
        }
        return definitionHolders;
    }

    private Class<? extends TServiceClient> getClientClassFromAnnotation(Class<?> beanClass) {
        ParameterizedType clientAwareType = (ParameterizedType)beanClass.getGenericInterfaces()[0];
        if (Objects.isNull(clientAwareType)) {
            throw new ThriftClientConfigException("Interface annotated with @ThriftClient should be inherited from ThriftClientAware");
        }
        Object[] typeArguments = clientAwareType.getActualTypeArguments();
        if (ArrayUtils.isEmpty((Object[])typeArguments) || typeArguments.length == 0) {
            throw new ThriftClientConfigException("ThriftClientAware should declare an argument");
        }
        Class clientClass = (Class)typeArguments[0];
        if (!ClassUtils.isAssignable(TServiceClient.class, (Class)clientClass)) {
            throw new ThriftClientConfigException("ThriftClientAware without argument inherited from TServiceClient");
        }
        return clientClass;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        AnnotationMetadata metadata = beanDefinition.getMetadata();
        return metadata.hasAnnotation(ThriftClient.class.getName()) && metadata.isInterface();
    }
}

