/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.pool;

import cn.shellming.thrift.client.common.ThriftServerNode;
import cn.shellming.thrift.client.exception.ThriftClientConfigException;
import org.apache.thrift.transport.TFastFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftTransportFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftTransportFactory.class);
    private static final int CONNECT_TIMEOUT = 10;

    public static TTransport determineTTranport(String serviceModel, ThriftServerNode serverNode, int connectTimeout) {
        TTransport transport;
        switch (serviceModel) {
            case "simple": 
            case "threadPool": {
                transport = ThriftTransportFactory.createTSocket(serviceModel, serverNode, connectTimeout);
                break;
            }
            case "nonBlocking": 
            case "hsHa": 
            case "threadedSelector": {
                transport = ThriftTransportFactory.createTFramedTransport(serviceModel, serverNode, connectTimeout);
                break;
            }
            default: {
                throw new ThriftClientConfigException("Service model is configured in wrong way");
            }
        }
        return transport;
    }

    public static TTransport determineTTranport(String serviceModel, ThriftServerNode serverNode) {
        return ThriftTransportFactory.determineTTranport(serviceModel, serverNode, 10);
    }

    private static TTransport createTSocket(String serviceModel, ThriftServerNode serverNode, int connectTimeout) {
        TSocket transport = new TSocket(serverNode.getHost(), serverNode.getPort(), connectTimeout > 0 ? connectTimeout : 10);
        LOGGER.info("Established a new socket transport, service model is {}", (Object)serviceModel);
        return transport;
    }

    private static TTransport createTFramedTransport(String serviceModel, ThriftServerNode serverNode, int connectTimeout) {
        TFastFramedTransport transport = new TFastFramedTransport((TTransport)new TSocket(serverNode.getHost(), serverNode.getPort(), connectTimeout > 0 ? connectTimeout : 10));
        LOGGER.info("Established a new framed transport, service model is {}", (Object)serviceModel);
        return transport;
    }
}

