/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.loadbalancer;

import cn.shellming.thrift.client.common.ThriftServerNode;
import cn.shellming.thrift.client.discovery.ServerListUpdater;
import cn.shellming.thrift.client.discovery.ThriftConsulServerListUpdater;
import cn.shellming.thrift.client.discovery.ThriftConsulServerNode;
import cn.shellming.thrift.client.discovery.ThriftConsulServerNodeList;
import cn.shellming.thrift.client.loadbalancer.AbstractLoadBalancer;
import cn.shellming.thrift.client.loadbalancer.IRule;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftConsulServerListLoadBalancer
extends AbstractLoadBalancer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ThriftConsulServerNodeList serverNodeList;
    private IRule rule;
    private volatile ServerListUpdater serverListUpdater;
    private final ServerListUpdater.UpdateAction updateAction = this::updateListOfServers;

    public ThriftConsulServerListLoadBalancer(ThriftConsulServerNodeList serverNodeList, IRule rule) {
        this.serverNodeList = serverNodeList;
        this.rule = rule;
        this.serverListUpdater = new ThriftConsulServerListUpdater();
        this.startUpdateAction();
    }

    @Override
    public ThriftConsulServerNodeList getThriftServerNodeList() {
        return this.serverNodeList;
    }

    @Override
    public ThriftConsulServerNode chooseServerNode(String key) {
        ThriftServerNode serverNode;
        if (this.rule == null) {
            return null;
        }
        try {
            serverNode = this.rule.choose(key);
        }
        catch (Exception e) {
            this.log.warn("LoadBalancer [{}]:  Error choosing server for key {}", new Object[]{this.getClass().getSimpleName(), key, e});
            return null;
        }
        if (serverNode instanceof ThriftConsulServerNode) {
            return (ThriftConsulServerNode)serverNode;
        }
        return null;
    }

    private synchronized void startUpdateAction() {
        this.log.info("Using serverListUpdater {}", (Object)this.serverListUpdater.getClass().getSimpleName());
        if (this.serverListUpdater == null) {
            this.serverListUpdater = new ThriftConsulServerListUpdater();
        }
        this.serverListUpdater.start(this.updateAction);
    }

    public void stopServerListRefreshing() {
        if (this.serverListUpdater != null) {
            this.serverListUpdater.stop();
        }
    }

    private void updateListOfServers() {
        Map<String, LinkedHashSet<ThriftConsulServerNode>> thriftConsulServers = this.serverNodeList.refreshThriftServers();
        ArrayList serverList = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, LinkedHashSet<ThriftConsulServerNode>> serverEntry : thriftConsulServers.entrySet()) {
            serverList.add(sb.append(serverEntry.getKey()).append(": ").append(serverEntry.getValue()).toString());
            sb.setLength(0);
        }
        this.log.info("Refreshed thrift serverList: [" + String.join((CharSequence)", ", serverList) + "]");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThriftConsulServerListLoadBalancer:");
        sb.append(super.toString());
        sb.append("ServerList:").append(String.valueOf(this.serverNodeList));
        return sb.toString();
    }
}

