/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.discovery;

import cn.shellming.thrift.client.common.ThriftServerNodeList;
import cn.shellming.thrift.client.discovery.ThriftConsulServerNode;
import cn.shellming.thrift.client.discovery.ThriftConsulServerUtils;
import cn.shellming.thrift.client.exception.ThriftClientException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.model.health.Service;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.option.QueryOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ThriftConsulServerNodeList
extends ThriftServerNodeList<ThriftConsulServerNode> {
    private final Consul consul;
    private final HealthClient healthClient;
    private final CatalogClient catalogClient;
    private static ThriftConsulServerNodeList serverNodeList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThriftConsulServerNodeList singleton(Consul consul) {
        if (serverNodeList != null) return serverNodeList;
        Class<ThriftConsulServerNodeList> clazz = ThriftConsulServerNodeList.class;
        synchronized (ThriftConsulServerNodeList.class) {
            if (serverNodeList != null) return serverNodeList;
            serverNodeList = new ThriftConsulServerNodeList(consul);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return serverNodeList;
        }
    }

    private ThriftConsulServerNodeList(Consul consul) {
        this.consul = consul;
        this.healthClient = this.consul.healthClient();
        this.catalogClient = this.consul.catalogClient();
    }

    @Override
    public List<ThriftConsulServerNode> getThriftServer(String serviceName) {
        LinkedHashSet serverNodeSet;
        if (MapUtils.isNotEmpty((Map)this.serverNodeMap) && this.serverNodeMap.containsKey(serviceName) && CollectionUtils.isNotEmpty((Collection)(serverNodeSet = (LinkedHashSet)this.serverNodeMap.get(serviceName)))) {
            return Lists.newArrayList((Iterable)serverNodeSet);
        }
        return this.refreshThriftServer(serviceName);
    }

    @Override
    public List<ThriftConsulServerNode> refreshThriftServer(String serviceName) {
        ArrayList serverNodeList = Lists.newArrayList();
        List serviceHealthList = (List)this.healthClient.getAllServiceInstances(serviceName).getResponse();
        this.filterAndCompoServerNodes(serverNodeList, serviceHealthList);
        if (CollectionUtils.isNotEmpty((Collection)serverNodeList)) {
            this.serverNodeMap.put(serviceName, Sets.newLinkedHashSet((Iterable)serverNodeList));
        }
        return serverNodeList;
    }

    @Override
    public Map<String, LinkedHashSet<ThriftConsulServerNode>> getThriftServers() {
        if (MapUtils.isNotEmpty((Map)this.serverNodeMap)) {
            return this.serverNodeMap;
        }
        return this.refreshThriftServers();
    }

    @Override
    public Map<String, LinkedHashSet<ThriftConsulServerNode>> refreshThriftServers() {
        Map catalogServiceMap = (Map)this.catalogClient.getServices(QueryOptions.BLANK).getResponse();
        if (MapUtils.isEmpty((Map)catalogServiceMap)) {
            return this.serverNodeMap;
        }
        ConcurrentMap serverNodeMap = Maps.newConcurrentMap();
        for (Map.Entry catalogServiceEntry : catalogServiceMap.entrySet()) {
            String serviceName = (String)catalogServiceEntry.getKey();
            List tags = (List)catalogServiceEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)tags)) continue;
            List serviceHealthList = (List)this.healthClient.getAllServiceInstances(serviceName).getResponse();
            LinkedHashSet serverNodeSet = Sets.newLinkedHashSet();
            ArrayList serverNodes = Lists.newArrayList((Iterable)serverNodeSet);
            this.filterAndCompoServerNodes(serverNodes, serviceHealthList);
            if (!CollectionUtils.isNotEmpty((Collection)serverNodeSet)) continue;
            serverNodeMap.put(serviceName, serverNodeSet);
        }
        this.serverNodeMap.clear();
        this.serverNodeMap.putAll(serverNodeMap);
        return ImmutableMap.copyOf((Map)this.serverNodeMap);
    }

    private static ThriftConsulServerNode getThriftConsulServerNode(ServiceHealth serviceHealth) {
        ThriftConsulServerNode serverNode = new ThriftConsulServerNode();
        Node node = serviceHealth.getNode();
        serverNode.setNode(node.getNode());
        Service service = serviceHealth.getService();
        serverNode.setAddress(service.getAddress());
        serverNode.setPort(service.getPort());
        serverNode.setHost(ThriftConsulServerUtils.findHost(serviceHealth));
        serverNode.setServiceId(service.getService());
        serverNode.setTags(service.getTags());
        serverNode.setHealth(ThriftConsulServerUtils.isPassingCheck(serviceHealth));
        return serverNode;
    }

    private void filterAndCompoServerNodes(List<ThriftConsulServerNode> serverNodeList, List<ServiceHealth> serviceHealthList) {
        for (ServiceHealth serviceHealth : serviceHealthList) {
            ThriftConsulServerNode serverNode = ThriftConsulServerNodeList.getThriftConsulServerNode(serviceHealth);
            if (serverNode == null || !serverNode.isHealth() || CollectionUtils.isEmpty(serverNode.getTags())) continue;
            serverNodeList.add(serverNode);
        }
    }

    private static class ThriftConsulResponseCallback
    implements ConsulResponseCallback<List<ServiceHealth>> {
        List<ThriftConsulServerNode> serverNodeList;

        public ThriftConsulResponseCallback(List<ThriftConsulServerNode> serverNodeList) {
            this.serverNodeList = serverNodeList;
        }

        public void onComplete(ConsulResponse<List<ServiceHealth>> consulResponse) {
            List response = (List)consulResponse.getResponse();
            for (ServiceHealth serviceHealth : response) {
                ThriftConsulServerNode serverNode = ThriftConsulServerNodeList.getThriftConsulServerNode(serviceHealth);
                this.serverNodeList.add(serverNode);
            }
        }

        public void onFailure(Throwable throwable) {
            throw new ThriftClientException("Failed to query service instances from consul agent", throwable);
        }
    }
}

